/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing;

import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.referencing.Resources;
import org.apache.sis.internal.referencing.provider.TransverseMercator;
import org.apache.sis.internal.system.SystemListener;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.referencing.AuthorityFactories;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.EPSGFactoryFallback;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.referencing.NamedIdentifier;
import org.apache.sis.referencing.StandardDefinitions;
import org.apache.sis.referencing.crs.DefaultEngineeringCRS;
import org.apache.sis.referencing.crs.DefaultGeocentricCRS;
import org.apache.sis.referencing.crs.DefaultGeographicCRS;
import org.apache.sis.referencing.crs.DefaultTemporalCRS;
import org.apache.sis.referencing.crs.DefaultVerticalCRS;
import org.apache.sis.referencing.cs.AbstractCS;
import org.apache.sis.referencing.cs.AxesConvention;
import org.apache.sis.referencing.cs.DefaultCartesianCS;
import org.apache.sis.referencing.cs.DefaultCoordinateSystemAxis;
import org.apache.sis.referencing.cs.DefaultTimeCS;
import org.apache.sis.referencing.cs.DefaultVerticalCS;
import org.apache.sis.referencing.datum.DefaultEngineeringDatum;
import org.apache.sis.referencing.datum.DefaultTemporalDatum;
import org.apache.sis.referencing.datum.DefaultVerticalDatum;
import org.apache.sis.referencing.factory.GeodeticAuthorityFactory;
import org.apache.sis.referencing.factory.UnavailableFactoryException;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.Exceptions;
import org.apache.sis.util.Utilities;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.EngineeringCRS;
import org.opengis.referencing.crs.GeocentricCRS;
import org.opengis.referencing.crs.GeodeticCRS;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.crs.VerticalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.cs.SphericalCS;
import org.opengis.referencing.cs.TimeCS;
import org.opengis.referencing.cs.VerticalCS;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.Ellipsoid;
import org.opengis.referencing.datum.EngineeringDatum;
import org.opengis.referencing.datum.GeodeticDatum;
import org.opengis.referencing.datum.PrimeMeridian;
import org.opengis.referencing.datum.TemporalDatum;
import org.opengis.referencing.datum.VerticalDatum;
import org.opengis.referencing.datum.VerticalDatumType;
import org.opengis.util.FactoryException;
import org.opengis.util.InternationalString;

public enum CommonCRS {
    WGS84(4326, 4979, 4978, 6326, 7030, 5041, 5042, 32600, 32700, 1, 60),
    WGS72(4322, 4985, 4984, 6322, 7043, 0, 0, 32200, 32300, 1, 60),
    NAD83(4269, 0, 0, 6269, 7019, 0, 0, 26900, 0, 1, 23),
    NAD27(4267, 0, 0, 6267, 7008, 0, 0, 26700, 0, 1, 22),
    ETRS89(4258, 4937, 4936, 6258, 7019, 0, 0, 25800, 0, 28, 37),
    ED50(4230, 0, 0, 6230, 7022, 0, 0, 23000, 0, 28, 38),
    GRS1980(4019, 0, 0, 6019, 7019, 0, 0, 0, 0, 0, 0),
    SPHERE(4047, 0, 0, 6047, 7048, 0, 0, 0, 0, 0, 0);

    static final CommonCRS DEFAULT;
    final short geographic;
    final short geo3D;
    final short geocentric;
    final short datum;
    final short ellipsoid;
    final short northUPS;
    final short southUPS;
    final short northUTM;
    final short southUTM;
    final byte firstZone;
    final byte lastZone;
    private volatile transient IdentifiedObject cached;
    private volatile transient GeographicCRS cachedNormalized;
    private volatile transient GeographicCRS cachedGeo3D;
    private volatile transient GeocentricCRS cachedGeocentric;
    private volatile transient GeocentricCRS cachedSpherical;
    private final Map<Integer, ProjectedCRS> cachedProjections;
    private static final int POLAR = 90;

    private CommonCRS(short s, short s2, short s3, short s4, short s5, short s6, short s7, short s8, short s9, byte by, byte by2) {
        this.geographic = s;
        this.geocentric = s3;
        this.geo3D = s2;
        this.datum = s4;
        this.ellipsoid = s5;
        this.northUPS = s6;
        this.southUPS = s7;
        this.northUTM = s8;
        this.southUTM = s9;
        this.firstZone = by;
        this.lastZone = by2;
        this.cachedProjections = new HashMap<Integer, ProjectedCRS>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final synchronized void clear() {
        this.cached = null;
        this.cachedGeo3D = null;
        this.cachedNormalized = null;
        this.cachedGeocentric = null;
        Map<Integer, ProjectedCRS> map = this.cachedProjections;
        synchronized (map) {
            this.cachedProjections.clear();
        }
    }

    public static CommonCRS forDatum(CoordinateReferenceSystem coordinateReferenceSystem) {
        CommonCRS commonCRS;
        SingleCRS singleCRS;
        if (coordinateReferenceSystem instanceof SingleCRS) {
            singleCRS = (SingleCRS)coordinateReferenceSystem;
        } else {
            singleCRS = CRS.getHorizontalComponent(coordinateReferenceSystem);
            if (singleCRS == null) {
                throw new IllegalArgumentException(Resources.format((short)71, IdentifiedObjects.getDisplayName(coordinateReferenceSystem, null)));
            }
        }
        Datum datum = singleCRS.getDatum();
        if (datum instanceof GeodeticDatum && (commonCRS = CommonCRS.forDatum((GeodeticDatum)datum)) != null) {
            return commonCRS;
        }
        throw new IllegalArgumentException(Errors.format((short)168, IdentifiedObjects.getDisplayName(datum, null)));
    }

    static CommonCRS forDatum(GeodeticDatum geodeticDatum) {
        String object;
        int n = 0;
        Identifier identifier = IdentifiedObjects.getIdentifier(geodeticDatum, Citations.EPSG);
        if (identifier != null && (object = identifier.getCode()) != null) {
            try {
                n = Integer.parseInt(object);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.recoverableException(Logger.getLogger("org.apache.sis.referencing"), CommonCRS.class, "forDatum", numberFormatException);
            }
        }
        for (CommonCRS commonCRS : CommonCRS.values()) {
            if (!(n != 0 ? commonCRS.datum == n : Utilities.equalsIgnoreMetadata(commonCRS.datum(), geodeticDatum))) continue;
            return commonCRS;
        }
        return null;
    }

    public static GeographicCRS defaultGeographic() {
        return DEFAULT.normalizedGeographic();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS normalizedGeographic() {
        GeographicCRS geographicCRS = this.cachedNormalized;
        if (geographicCRS == null) {
            DefaultGeographicCRS defaultGeographicCRS = DefaultGeographicCRS.castOrCopy(this.geographic());
            defaultGeographicCRS = defaultGeographicCRS.forConvention(AxesConvention.RIGHT_HANDED);
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geographicCRS = this.cachedNormalized;
                if (geographicCRS == null) {
                    this.cachedNormalized = geographicCRS = defaultGeographicCRS;
                }
            }
        }
        return geographicCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS geographic() {
        GeographicCRS geographicCRS = CommonCRS.geographic(this.cached);
        if (geographicCRS == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geographicCRS = CommonCRS.geographic(this.cached);
                if (geographicCRS == null) {
                    GeodeticAuthorityFactory geodeticAuthorityFactory = CommonCRS.factory();
                    if (geodeticAuthorityFactory != null) {
                        try {
                            geographicCRS = geodeticAuthorityFactory.createGeographicCRS(String.valueOf(this.geographic));
                            this.cached = geographicCRS;
                            return geographicCRS;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "geographic", factoryException, this.geographic);
                        }
                    }
                    EllipsoidalCS ellipsoidalCS = this == DEFAULT ? (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6422, true) : DEFAULT.geographic().getCoordinateSystem();
                    geographicCRS = StandardDefinitions.createGeographicCRS(this.geographic, this.datum(), ellipsoidalCS);
                    this.cached = geographicCRS;
                }
            }
        }
        return geographicCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeographicCRS geographic3D() {
        GeographicCRS geographicCRS = this.cachedGeo3D;
        if (geographicCRS == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geographicCRS = this.cachedGeo3D;
                if (geographicCRS == null) {
                    Object object;
                    if (this.geo3D != 0 && (object = CommonCRS.factory()) != null) {
                        try {
                            this.cachedGeo3D = geographicCRS = ((GeodeticAuthorityFactory)object).createGeographicCRS(String.valueOf(this.geo3D));
                            return geographicCRS;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "geographic3D", factoryException, this.geo3D);
                        }
                    }
                    object = this == DEFAULT ? (EllipsoidalCS)StandardDefinitions.createCoordinateSystem((short)6423, true) : DEFAULT.geographic3D().getCoordinateSystem();
                    GeographicCRS geographicCRS2 = this.geographic();
                    this.cachedGeo3D = geographicCRS = new DefaultGeographicCRS(CommonCRS.properties(geographicCRS2, this.geo3D), geographicCRS2.getDatum(), (EllipsoidalCS)object);
                }
            }
        }
        return geographicCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeocentricCRS geocentric() {
        GeocentricCRS geocentricCRS = this.cachedGeocentric;
        if (geocentricCRS == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geocentricCRS = this.cachedGeocentric;
                if (geocentricCRS == null) {
                    Object object;
                    if (this.geocentric != 0 && (object = CommonCRS.factory()) != null) {
                        try {
                            this.cachedGeocentric = geocentricCRS = ((GeodeticAuthorityFactory)object).createGeocentricCRS(String.valueOf(this.geocentric));
                            return geocentricCRS;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "geocentric", factoryException, this.geocentric);
                        }
                    }
                    object = this == DEFAULT ? (CartesianCS)StandardDefinitions.createCoordinateSystem((short)6500, true) : (CartesianCS)DEFAULT.geocentric().getCoordinateSystem();
                    GeographicCRS geographicCRS = this.geographic();
                    this.cachedGeocentric = geocentricCRS = new DefaultGeocentricCRS(CommonCRS.properties(geographicCRS, this.geocentric), geographicCRS.getDatum(), (CartesianCS)object);
                }
            }
        }
        return geocentricCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeocentricCRS spherical() {
        GeocentricCRS geocentricCRS = this.cachedSpherical;
        if (geocentricCRS == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geocentricCRS = this.cachedSpherical;
                if (geocentricCRS == null) {
                    Object object;
                    SphericalCS sphericalCS = null;
                    if (this == DEFAULT) {
                        object = CommonCRS.factory();
                        if (object != null) {
                            try {
                                sphericalCS = ((GeodeticAuthorityFactory)object).createSphericalCS(Short.toString((short)6404));
                            }
                            catch (FactoryException factoryException) {
                                CommonCRS.failure((Object)this, "spherical", factoryException, 6404);
                            }
                        }
                        if (sphericalCS == null) {
                            sphericalCS = (SphericalCS)StandardDefinitions.createCoordinateSystem((short)6404, true);
                        }
                    } else {
                        sphericalCS = (SphericalCS)DEFAULT.spherical().getCoordinateSystem();
                    }
                    object = this.geographic();
                    this.cachedSpherical = geocentricCRS = new DefaultGeocentricCRS(IdentifiedObjects.getProperties((IdentifiedObject)object, CommonCRS.exclude()), object.getDatum(), sphericalCS);
                }
            }
        }
        return geocentricCRS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeodeticDatum datum() {
        GeodeticDatum geodeticDatum = CommonCRS.datum(this.cached);
        if (geodeticDatum == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                geodeticDatum = CommonCRS.datum(this.cached);
                if (geodeticDatum == null) {
                    GeodeticAuthorityFactory geodeticAuthorityFactory = CommonCRS.factory();
                    if (geodeticAuthorityFactory != null) {
                        try {
                            geodeticDatum = geodeticAuthorityFactory.createGeodeticDatum(String.valueOf(this.datum));
                            this.cached = geodeticDatum;
                            return geodeticDatum;
                        }
                        catch (FactoryException factoryException) {
                            CommonCRS.failure((Object)this, "datum", factoryException, this.datum);
                        }
                    }
                    geodeticDatum = StandardDefinitions.createGeodeticDatum(this.datum, this.ellipsoid(), this.primeMeridian());
                    this.cached = geodeticDatum;
                }
            }
        }
        return geodeticDatum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ellipsoid ellipsoid() {
        Ellipsoid ellipsoid = CommonCRS.ellipsoid(this.cached);
        if (ellipsoid == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                ellipsoid = CommonCRS.ellipsoid(this.cached);
                if (ellipsoid == null) {
                    if (this == NAD83) {
                        ellipsoid = ETRS89.ellipsoid();
                    } else {
                        GeodeticAuthorityFactory geodeticAuthorityFactory = CommonCRS.factory();
                        if (geodeticAuthorityFactory != null) {
                            try {
                                ellipsoid = geodeticAuthorityFactory.createEllipsoid(String.valueOf(this.ellipsoid));
                                this.cached = ellipsoid;
                                return ellipsoid;
                            }
                            catch (FactoryException factoryException) {
                                CommonCRS.failure((Object)this, "ellipsoid", factoryException, this.ellipsoid);
                            }
                        }
                        ellipsoid = StandardDefinitions.createEllipsoid(this.ellipsoid);
                    }
                    this.cached = ellipsoid;
                }
            }
        }
        return ellipsoid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PrimeMeridian primeMeridian() {
        PrimeMeridian primeMeridian = CommonCRS.primeMeridian(this.cached);
        if (primeMeridian == null) {
            CommonCRS commonCRS = this;
            synchronized (commonCRS) {
                primeMeridian = CommonCRS.primeMeridian(this.cached);
                if (primeMeridian == null) {
                    if (this != DEFAULT) {
                        primeMeridian = DEFAULT.primeMeridian();
                    } else {
                        GeodeticAuthorityFactory geodeticAuthorityFactory = CommonCRS.factory();
                        if (geodeticAuthorityFactory != null) {
                            try {
                                primeMeridian = geodeticAuthorityFactory.createPrimeMeridian("8901");
                                this.cached = primeMeridian;
                                return primeMeridian;
                            }
                            catch (FactoryException factoryException) {
                                CommonCRS.failure((Object)this, "primeMeridian", factoryException, 8901);
                            }
                        }
                        primeMeridian = StandardDefinitions.primeMeridian();
                    }
                    this.cached = primeMeridian;
                }
            }
        }
        return primeMeridian;
    }

    private static GeographicCRS geographic(IdentifiedObject identifiedObject) {
        return identifiedObject instanceof GeographicCRS ? (GeographicCRS)identifiedObject : null;
    }

    private static GeodeticDatum datum(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof GeodeticDatum) {
            return (GeodeticDatum)identifiedObject;
        }
        if (identifiedObject instanceof GeodeticCRS) {
            return ((GeodeticCRS)identifiedObject).getDatum();
        }
        return null;
    }

    private static Ellipsoid ellipsoid(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof Ellipsoid) {
            return (Ellipsoid)identifiedObject;
        }
        GeodeticDatum geodeticDatum = CommonCRS.datum(identifiedObject);
        return geodeticDatum != null ? geodeticDatum.getEllipsoid() : null;
    }

    private static PrimeMeridian primeMeridian(IdentifiedObject identifiedObject) {
        if (identifiedObject instanceof PrimeMeridian) {
            return (PrimeMeridian)identifiedObject;
        }
        GeodeticDatum geodeticDatum = CommonCRS.datum(identifiedObject);
        return geodeticDatum != null ? geodeticDatum.getPrimeMeridian() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectedCRS universal(double d, double d2) {
        ProjectedCRS projectedCRS;
        ArgumentChecks.ensureBetween("latitude", -90.0, 90.0, d);
        ArgumentChecks.ensureBetween("longitude", -4.052915431398935E8, 4.052915431398935E8, d2);
        boolean bl = MathFunctions.isNegative(d);
        boolean bl2 = d >= -80.0 && d < 84.0;
        int n = bl2 ? TransverseMercator.Zoner.UTM.zone(d, d2) : 90;
        Integer n2 = bl ? -n : n;
        Map<Integer, ProjectedCRS> map = this.cachedProjections;
        synchronized (map) {
            projectedCRS = this.cachedProjections.get(n2);
        }
        if (projectedCRS == null) {
            Object object;
            Object object2;
            int n3 = 0;
            if (!bl2) {
                n3 = Short.toUnsignedInt(bl ? this.southUPS : this.northUPS);
            } else if (n >= this.firstZone && n <= this.lastZone) {
                n3 = Short.toUnsignedInt(bl ? this.southUTM : this.northUTM);
            }
            if (n3 != 0) {
                if (bl2) {
                    n3 += n;
                }
                if ((object2 = CommonCRS.factory()) != null) {
                    try {
                        return ((GeodeticAuthorityFactory)object2).createProjectedCRS(String.valueOf(n3));
                    }
                    catch (FactoryException factoryException) {
                        CommonCRS.failure((Object)this, "universal", factoryException, n3);
                    }
                }
            }
            object2 = null;
            if (bl2) {
                object = CommonCRS.DEFAULT.cachedProjections;
                synchronized (object) {
                    for (Map.Entry<Integer, ProjectedCRS> entry : CommonCRS.DEFAULT.cachedProjections.entrySet()) {
                        if (Math.abs(entry.getKey()) == 90) continue;
                        object2 = entry.getValue().getCoordinateSystem();
                        break;
                    }
                }
            }
            if (object2 == null) {
                object2 = this != DEFAULT ? DEFAULT.universal(d, d2).getCoordinateSystem() : (CartesianCS)StandardDefinitions.createCoordinateSystem(bl2 ? (short)4400 : (bl ? (short)1027 : 1026), true);
            }
            projectedCRS = StandardDefinitions.createUniversal(n3, this.geographic(), bl2, d, d2, (CartesianCS)object2);
            Map<Integer, ProjectedCRS> map2 = this.cachedProjections;
            synchronized (map2) {
                object = this.cachedProjections.putIfAbsent(n2, projectedCRS);
            }
            if (object != null) {
                return object;
            }
        }
        return projectedCRS;
    }

    private static Map<String, ?> properties(short s) {
        return CommonCRS.properties(Vocabulary.formatInternational(s));
    }

    private static Map<String, ?> properties(InternationalString internationalString) {
        return Collections.singletonMap("name", new NamedIdentifier(null, internationalString));
    }

    private static Map<String, ?> properties(IdentifiedObject identifiedObject, short s) {
        HashMap hashMap = new HashMap(IdentifiedObjects.getProperties(identifiedObject, CommonCRS.exclude()));
        hashMap.put("identifiers", new NamedIdentifier(Citations.EPSG, String.valueOf(s)));
        return hashMap;
    }

    private static String[] exclude() {
        return new String[]{"identifiers"};
    }

    private static GeodeticAuthorityFactory factory() {
        GeodeticAuthorityFactory geodeticAuthorityFactory = AuthorityFactories.EPSG();
        if (!(geodeticAuthorityFactory instanceof EPSGFactoryFallback)) {
            return geodeticAuthorityFactory;
        }
        return null;
    }

    private static void failure(Object object, String string, FactoryException factoryException, int n) {
        String string2 = Resources.format((short)5, "EPSG:" + n);
        string2 = Exceptions.formatChainedMessages(null, string2, factoryException);
        LogRecord logRecord = new LogRecord(Level.WARNING, string2);
        if (!(factoryException instanceof UnavailableFactoryException) || AuthorityFactories.failure((UnavailableFactoryException)factoryException)) {
            logRecord.setThrown(factoryException);
        }
        logRecord.setLoggerName("org.apache.sis.referencing.factory");
        Logging.log(object.getClass(), string, logRecord);
    }

    static {
        DEFAULT = WGS84;
        SystemListener.add(new SystemListener("org.apache.sis.referencing"){

            @Override
            protected void classpathChanged() {
                for (CommonCRS commonCRS : CommonCRS.values()) {
                    commonCRS.clear();
                }
            }
        });
    }

    public static enum Engineering {
        GEODISPLAY(new DefaultEngineeringDatum(JDK9.mapOf("name", "Computer display", "anchorPoint", "Origin is in upper left."))),
        DISPLAY(Engineering.GEODISPLAY.datum),
        GRID(new DefaultEngineeringDatum(Collections.singletonMap("name", "Cell indices"))),
        TIME(new DefaultEngineeringDatum(Collections.singletonMap("name", "Time")));

        private final EngineeringDatum datum;
        private EngineeringCRS crs;

        private Engineering(EngineeringDatum engineeringDatum) {
            this.datum = engineeringDatum;
        }

        public synchronized EngineeringCRS crs() {
            if (this.crs == null) {
                AxisDirection axisDirection;
                String string;
                AxisDirection axisDirection2;
                String string2;
                Map<String, ReferenceIdentifier> map = Collections.singletonMap("name", this.datum.getName());
                HashMap<String, ReferenceIdentifier> hashMap = new HashMap<String, ReferenceIdentifier>(map);
                AbstractCS abstractCS = null;
                switch (this) {
                    case GEODISPLAY: {
                        string2 = "i";
                        axisDirection2 = AxisDirection.EAST;
                        string = "j";
                        axisDirection = AxisDirection.SOUTH;
                        hashMap.put("name", new NamedIdentifier(Citations.WMS, "1"));
                        break;
                    }
                    case DISPLAY: {
                        string2 = "x";
                        axisDirection2 = AxisDirection.DISPLAY_RIGHT;
                        string = "y";
                        axisDirection = AxisDirection.DISPLAY_DOWN;
                        break;
                    }
                    case GRID: {
                        string2 = "i";
                        axisDirection2 = AxisDirection.COLUMN_POSITIVE;
                        string = "j";
                        axisDirection = AxisDirection.ROW_POSITIVE;
                        break;
                    }
                    case TIME: {
                        string = "t";
                        string2 = "t";
                        axisDirection2 = axisDirection = AxisDirection.FUTURE;
                        abstractCS = new DefaultTimeCS(map, new DefaultCoordinateSystemAxis(Collections.singletonMap("name", string2), string2, axisDirection2, Units.SECOND));
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)this);
                    }
                }
                if (abstractCS == null) {
                    abstractCS = new DefaultCartesianCS((Map<String, ?>)map, (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", string2), string2, axisDirection2, Units.PIXEL), (CoordinateSystemAxis)new DefaultCoordinateSystemAxis(Collections.singletonMap("name", string), string, axisDirection, Units.PIXEL));
                }
                this.crs = new DefaultEngineeringCRS(hashMap, this.datum, abstractCS);
            }
            return this.crs;
        }

        public EngineeringDatum datum() {
            return this.datum;
        }
    }

    public static enum Temporal {
        JULIAN(111, -210866760000000L, "JulianDate", true),
        MODIFIED_JULIAN(136, -3506716800000L, "ModifiedJulianDate", false),
        TRUNCATED_JULIAN(202, -50716800000L, "TruncatedJulianDate", true),
        DUBLIN_JULIAN(70, -2209032000000L, "DublinJulian", false),
        UNIX(196, 0L, "UnixTime", true),
        JAVA(196, 0L, "JavaTime", false);

        private final short key;
        private final long epoch;
        private final String identifier;
        private final boolean isOGC;
        private volatile transient IdentifiedObject cached;

        private Temporal(short s, long l, String string2, boolean bl) {
            this.key = s;
            this.epoch = l;
            this.identifier = string2;
            this.isOGC = bl;
        }

        final synchronized void clear() {
            this.cached = null;
        }

        public static Temporal forIdentifier(String string, boolean bl) {
            ArgumentChecks.ensureNonEmpty("identifier", string);
            for (Temporal temporal : Temporal.values()) {
                if (!temporal.identifier.equalsIgnoreCase(string)) continue;
                if (bl & !temporal.isOGC) {
                    throw new IllegalArgumentException(Errors.format((short)199, "OGC", temporal.identifier));
                }
                return temporal;
            }
            throw new IllegalArgumentException(Errors.format((short)146, Temporal.class, string));
        }

        public static Temporal forEpoch(Instant instant) {
            if (instant != null) {
                long l = instant.toEpochMilli();
                for (Temporal temporal : Temporal.values()) {
                    if (temporal.epoch != l) continue;
                    return temporal;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemporalCRS crs() {
            TemporalCRS temporalCRS = Temporal.crs(this.cached);
            if (temporalCRS == null) {
                Temporal temporal = this;
                synchronized (temporal) {
                    temporalCRS = Temporal.crs(this.cached);
                    if (temporalCRS == null) {
                        TemporalDatum temporalDatum = this.datum();
                        Map map = this == JAVA ? CommonCRS.properties(Vocabulary.formatInternational(this.key, (Object)"Java")) : IdentifiedObjects.getProperties(temporalDatum, CommonCRS.exclude());
                        HashMap<String, NamedIdentifier> hashMap = new HashMap<String, NamedIdentifier>(map);
                        hashMap.put("identifiers", new NamedIdentifier(this.isOGC ? Citations.OGC : Citations.SIS, this.identifier));
                        temporalCRS = new DefaultTemporalCRS(hashMap, temporalDatum, this.cs());
                        this.cached = temporalCRS;
                    }
                }
            }
            return temporalCRS;
        }

        private TimeCS cs() {
            Map<String, ?> map;
            Map<String, ?> map2;
            Unit<Time> unit = Units.SECOND;
            switch (this) {
                default: {
                    return TRUNCATED_JULIAN.crs().getCoordinateSystem();
                }
                case TRUNCATED_JULIAN: {
                    unit = Units.DAY;
                }
                case UNIX: {
                    TimeCS timeCS = JAVA.crs().getCoordinateSystem();
                    map2 = IdentifiedObjects.getProperties(timeCS, CommonCRS.exclude());
                    map = IdentifiedObjects.getProperties(timeCS.getAxis(0), CommonCRS.exclude());
                    break;
                }
                case JAVA: {
                    map2 = CommonCRS.properties((short)191);
                    map = CommonCRS.properties((short)195);
                    unit = Units.MILLISECOND;
                }
            }
            return new DefaultTimeCS(map2, new DefaultCoordinateSystemAxis(map, "t", AxisDirection.FUTURE, unit));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TemporalDatum datum() {
            TemporalDatum temporalDatum = Temporal.datum(this.cached);
            if (temporalDatum == null) {
                Temporal temporal = this;
                synchronized (temporal) {
                    temporalDatum = Temporal.datum(this.cached);
                    if (temporalDatum == null) {
                        if (this == UNIX) {
                            temporalDatum = JAVA.datum();
                        } else {
                            Map map = this.key == 196 ? CommonCRS.properties(Vocabulary.formatInternational(this.key, (Object)"Unix/POSIX")) : CommonCRS.properties(this.key);
                            temporalDatum = new DefaultTemporalDatum(map, new Date(this.epoch));
                        }
                        this.cached = temporalDatum;
                    }
                }
            }
            return temporalDatum;
        }

        private static TemporalCRS crs(IdentifiedObject identifiedObject) {
            return identifiedObject instanceof TemporalCRS ? (TemporalCRS)identifiedObject : null;
        }

        private static TemporalDatum datum(IdentifiedObject identifiedObject) {
            if (identifiedObject instanceof TemporalDatum) {
                return (TemporalDatum)identifiedObject;
            }
            if (identifiedObject instanceof TemporalCRS) {
                return ((TemporalCRS)identifiedObject).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add(new SystemListener("org.apache.sis.referencing"){

                @Override
                protected void classpathChanged() {
                    for (Temporal temporal : Temporal.values()) {
                        temporal.clear();
                    }
                }
            });
        }
    }

    public static enum Vertical {
        BAROMETRIC(false, 16, 32),
        MEAN_SEA_LEVEL(true, 5714, 5100),
        DEPTH(true, 5715, 5100),
        NAVD88(true, 5703, 5103),
        ELLIPSOIDAL(false, 74, 72),
        OTHER_SURFACE(false, 98, 156);

        final boolean isEPSG;
        final short crs;
        final short datum;
        private volatile transient IdentifiedObject cached;

        private Vertical(boolean bl, short s, short s2) {
            this.isEPSG = bl;
            this.crs = s;
            this.datum = s2;
        }

        final synchronized void clear() {
            this.cached = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerticalCRS crs() {
            VerticalCRS verticalCRS = Vertical.crs(this.cached);
            if (verticalCRS == null) {
                Vertical vertical = this;
                synchronized (vertical) {
                    verticalCRS = Vertical.crs(this.cached);
                    if (verticalCRS == null) {
                        if (this.isEPSG) {
                            GeodeticAuthorityFactory geodeticAuthorityFactory = CommonCRS.factory();
                            if (geodeticAuthorityFactory != null) {
                                try {
                                    verticalCRS = geodeticAuthorityFactory.createVerticalCRS(String.valueOf(this.crs));
                                    this.cached = verticalCRS;
                                    return verticalCRS;
                                }
                                catch (FactoryException factoryException) {
                                    CommonCRS.failure((Object)this, "crs", factoryException, this.crs);
                                }
                            }
                            verticalCRS = StandardDefinitions.createVerticalCRS(this.crs, this.datum());
                        } else {
                            VerticalCS verticalCS = this.cs();
                            verticalCRS = new DefaultVerticalCRS(IdentifiedObjects.getProperties(verticalCS, CommonCRS.exclude()), this.datum(), verticalCS);
                        }
                        this.cached = verticalCRS;
                    }
                }
            }
            return verticalCRS;
        }

        private VerticalCS cs() {
            Unit<Quantity<Length>> unit;
            Map map = CommonCRS.properties(this.crs);
            switch (this) {
                default: {
                    unit = Units.METRE;
                    break;
                }
                case BAROMETRIC: {
                    unit = Units.HECTOPASCAL;
                }
            }
            return new DefaultVerticalCS(map, new DefaultCoordinateSystemAxis(map, "h", AxisDirection.UP, unit));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public VerticalDatum datum() {
            VerticalDatum verticalDatum = Vertical.datum(this.cached);
            if (verticalDatum == null) {
                Vertical vertical = this;
                synchronized (vertical) {
                    verticalDatum = Vertical.datum(this.cached);
                    if (verticalDatum == null) {
                        if (this.isEPSG) {
                            GeodeticAuthorityFactory geodeticAuthorityFactory = CommonCRS.factory();
                            if (geodeticAuthorityFactory != null) {
                                try {
                                    verticalDatum = geodeticAuthorityFactory.createVerticalDatum(String.valueOf(this.datum));
                                    this.cached = verticalDatum;
                                    return verticalDatum;
                                }
                                catch (FactoryException factoryException) {
                                    CommonCRS.failure((Object)this, "datum", factoryException, this.datum);
                                }
                            }
                            verticalDatum = StandardDefinitions.createVerticalDatum(this.datum);
                        } else {
                            verticalDatum = new DefaultVerticalDatum(CommonCRS.properties(this.datum), VerticalDatumType.valueOf(this.name()));
                        }
                        this.cached = verticalDatum;
                    }
                }
            }
            return verticalDatum;
        }

        private static VerticalCRS crs(IdentifiedObject identifiedObject) {
            return identifiedObject instanceof VerticalCRS ? (VerticalCRS)identifiedObject : null;
        }

        private static VerticalDatum datum(IdentifiedObject identifiedObject) {
            if (identifiedObject instanceof VerticalDatum) {
                return (VerticalDatum)identifiedObject;
            }
            if (identifiedObject instanceof VerticalCRS) {
                return ((VerticalCRS)identifiedObject).getDatum();
            }
            return null;
        }

        static {
            SystemListener.add(new SystemListener("org.apache.sis.referencing"){

                @Override
                protected void classpathChanged() {
                    for (Vertical vertical : Vertical.values()) {
                        vertical.clear();
                    }
                }
            });
        }
    }
}

