/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.parameter;

import java.io.Closeable;
import java.io.Console;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicReference;
import javax.measure.Unit;
import org.apache.sis.internal.metadata.NameToIdentifier;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.X364;
import org.apache.sis.io.TableAppender;
import org.apache.sis.io.TabularFormat;
import org.apache.sis.io.wkt.Colors;
import org.apache.sis.measure.Range;
import org.apache.sis.parameter.ParameterTableRow;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.IdentifiedObjects;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.IndexedResourceBundle;
import org.apache.sis.util.resources.Vocabulary;
import org.opengis.metadata.Identifier;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.operation.OperationMethod;
import org.opengis.util.CodeList;
import org.opengis.util.GenericName;
import org.opengis.util.InternationalString;

public class ParameterFormat
extends TabularFormat<Object> {
    private static final long serialVersionUID = -1345231739800152411L;
    private static final AtomicReference<ParameterFormat> INSTANCE = new AtomicReference();
    private static final String SEPARATOR = " \u2502 ";
    private final Locale displayLocale;
    private ContentLevel contentLevel = ContentLevel.BRIEF;
    private Set<String> preferredCodespaces;
    private Colors colors;

    public ParameterFormat() {
        super(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
        this.displayLocale = Locale.getDefault(Locale.Category.DISPLAY);
        this.columnSeparator = SEPARATOR;
    }

    public ParameterFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
        this.displayLocale = locale != null ? locale : Locale.ROOT;
        this.columnSeparator = SEPARATOR;
    }

    @Override
    public final Class<Object> getValueType() {
        return Object.class;
    }

    @Override
    public Locale getLocale(Locale.Category category) {
        return category == Locale.Category.DISPLAY ? this.displayLocale : super.getLocale(category);
    }

    public ContentLevel getContentLevel() {
        return this.contentLevel;
    }

    public void setContentLevel(ContentLevel contentLevel) {
        ArgumentChecks.ensureNonNull("level", (Object)contentLevel);
        this.contentLevel = contentLevel;
    }

    public String[] getPreferredCodespaces() {
        Set<String> set = this.preferredCodespaces;
        return set != null ? set.toArray(new String[set.size()]) : null;
    }

    public void setPreferredCodespaces(String ... stringArray) {
        Set<String> set = null;
        if (stringArray != null) {
            set = CollectionsExt.immutableSet(true, stringArray);
        }
        this.preferredCodespaces = set;
    }

    private boolean isPreferredCodespace(String string) {
        Set<String> set = this.preferredCodespaces;
        return set == null || set.contains(string);
    }

    public Colors getColors() {
        return this.colors;
    }

    public void setColors(Colors colors) {
        this.colors = colors;
    }

    private void nextColumn(TableAppender tableAppender) {
        tableAppender.append(this.beforeFill);
        tableAppender.nextColumn(this.fillCharacter);
    }

    @Override
    public void format(Object object, Appendable appendable) throws IOException {
        Object object2;
        ReferenceIdentifier referenceIdentifier;
        ParameterDescriptorGroup parameterDescriptorGroup;
        ParameterValueGroup parameterValueGroup;
        boolean bl;
        ArgumentChecks.ensureNonNull("object", object);
        ArgumentChecks.ensureNonNull("toAppendTo", appendable);
        boolean bl2 = bl = this.contentLevel == ContentLevel.NAME_SUMMARY;
        if (object instanceof ParameterValueGroup) {
            parameterValueGroup = (ParameterValueGroup)object;
            parameterDescriptorGroup = parameterValueGroup.getDescriptor();
            referenceIdentifier = parameterDescriptorGroup.getName();
        } else if (object instanceof ParameterDescriptorGroup) {
            parameterDescriptorGroup = (ParameterDescriptorGroup)object;
            parameterValueGroup = null;
            referenceIdentifier = parameterDescriptorGroup.getName();
        } else if (object instanceof OperationMethod) {
            object2 = (OperationMethod)object;
            parameterDescriptorGroup = object2.getParameters();
            parameterValueGroup = null;
            referenceIdentifier = object2.getName();
        } else {
            if (bl && object instanceof IdentifiedObject[]) {
                this.formatSummary((IdentifiedObject[])object, appendable);
                return;
            }
            throw new IllegalArgumentException(Errors.getResources(this.displayLocale).getString((short)163, object.getClass()));
        }
        if (bl) {
            object2 = parameterDescriptorGroup.descriptors();
            this.formatSummary(object2.toArray(new IdentifiedObject[object2.size()]), appendable);
        } else {
            this.format(referenceIdentifier.getCode(), parameterDescriptorGroup, parameterValueGroup, appendable);
        }
    }

    private void format(String string, ParameterDescriptorGroup parameterDescriptorGroup, ParameterValueGroup parameterValueGroup, Appendable appendable) throws IOException {
        Object object;
        Object object2;
        int n;
        int n2;
        int n3;
        Object object3;
        Unit<?> unit;
        FieldPosition fieldPosition;
        Object object4;
        boolean bl = this.contentLevel == ContentLevel.BRIEF;
        boolean bl2 = !bl || parameterValueGroup == null;
        boolean bl3 = this.colors != null;
        String string2 = this.lineSeparator;
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        ParameterTableRow parameterTableRow = new ParameterTableRow(parameterDescriptorGroup, this.displayLocale, this.preferredCodespaces, linkedHashMap, bl);
        String string3 = parameterTableRow.getCodeSpace();
        int n32 = 0;
        List<Object> list = parameterValueGroup != null ? parameterValueGroup.values() : parameterDescriptorGroup.descriptors();
        LinkedHashMap<Object, Object> linkedHashMap2 = new LinkedHashMap<Object, Object>(Containers.hashMapCapacity(list.size()));
        ArrayList arrayList = null;
        for (Object e : list) {
            Map.Entry n7;
            GeneralParameterValue bl4;
            if (parameterValueGroup != null) {
                bl4 = (GeneralParameterValue)e;
                object4 = bl4.getDescriptor();
            } else {
                bl4 = null;
                object4 = (GeneralParameterDescriptor)e;
            }
            if (object4 instanceof ParameterDescriptorGroup) {
                if (arrayList == null) {
                    arrayList = new ArrayList(4);
                }
                arrayList.add(e);
                continue;
            }
            fieldPosition = null;
            unit = null;
            if (bl4 instanceof ParameterValue) {
                n7 = (ParameterValue)bl4;
                fieldPosition = n7.getValue();
                unit = n7.getUnit();
            } else if (object4 instanceof ParameterDescriptor) {
                n7 = (ParameterDescriptor)object4;
                fieldPosition = n7.getDefaultValue();
                unit = n7.getUnit();
            }
            n7 = (ParameterTableRow)linkedHashMap2.get(object4);
            if (n7 == null) {
                n7 = new ParameterTableRow((IdentifiedObject)object4, this.displayLocale, this.preferredCodespaces, linkedHashMap, bl);
                linkedHashMap2.put(object4, n7);
                if (((ParameterTableRow)((Object)n7)).codespaceWidth > n32) {
                    n32 = ((ParameterTableRow)((Object)n7)).codespaceWidth;
                }
            }
            ((ParameterTableRow)((Object)n7)).addValue(fieldPosition, unit);
        }
        int n4 = 0;
        boolean n5 = false;
        boolean bl4 = string3 == null;
        object4 = new StringBuffer();
        fieldPosition = new FieldPosition(-1);
        for (Map.Entry n7 : linkedHashMap2.entrySet()) {
            Range<?> n9;
            object3 = (GeneralParameterDescriptor)n7.getKey();
            if (!(object3 instanceof ParameterDescriptor)) continue;
            ParameterTableRow n8 = (ParameterTableRow)n7.getValue();
            if (!bl4 && !string3.equals(((ParameterTableRow)n7.getValue()).getCodeSpace())) {
                bl4 = true;
            }
            if ((n9 = Parameters.getValueDomain((ParameterDescriptor)object3)) != null && (n3 = n8.setValueDomain(n9, this.getFormat(Range.class), (StringBuffer)object4)) > n2) {
                n2 = n3;
            }
            n8.expandSingleton();
            n3 = n8.units.size();
            for (n = 0; n < n3; ++n) {
                object2 = n8.units.get(n);
                if (object2 == null) continue;
                if (this.getFormat(Unit.class).format(object2, (StringBuffer)object4, fieldPosition).length() != 0 && Character.isLetterOrDigit(((StringBuffer)object4).codePointAt(0))) {
                    ((StringBuffer)object4).insert(0, ' ');
                }
                object = ((StringBuffer)object4).toString();
                n8.units.set(n, object);
                ((StringBuffer)object4).setLength(0);
                int parameterDescriptor = ((String)object).length();
                if (parameterDescriptor <= n4) continue;
                n4 = parameterDescriptor;
            }
        }
        unit = Vocabulary.getResources(this.displayLocale);
        parameterTableRow.writeIdentifiers(appendable, true, this.colors, false, string2);
        appendable.append(string2);
        int n6 = bl ? 9472 : 9552;
        object3 = bl || !this.columnSeparator.equals(SEPARATOR) ? new TableAppender(appendable, this.columnSeparator) : new TableAppender(appendable);
        ((TableAppender)object3).setMultiLinesCells(true);
        ((TableAppender)object3).nextLine((char)n6);
        int n7 = 0;
        int n8 = 0;
        while (true) {
            block49: {
                n3 = 0;
                switch (n8) {
                    case 0: {
                        n = 139;
                        break;
                    }
                    case 1: {
                        n = 203;
                        break;
                    }
                    case 2: {
                        if (bl2) {
                            n = 147;
                            break;
                        }
                        break block49;
                    }
                    case 3: {
                        n = 214;
                        break;
                    }
                    case 4: {
                        n = parameterValueGroup == null ? 56 : 213;
                        n3 = 1;
                        break;
                    }
                    default: {
                        throw new AssertionError(n8);
                    }
                }
                if (bl3) {
                    ((TableAppender)object3).append(X364.BOLD.sequence());
                }
                ((TableAppender)object3).append(((IndexedResourceBundle)((Object)unit)).getString((short)n));
                if (bl3) {
                    ((TableAppender)object3).append(X364.NORMAL.sequence());
                }
                if (!bl4 && n8 == 0) {
                    ((TableAppender)object3).append(" (").append(string3).append(')');
                }
                if (n3 != 0) break;
                this.nextColumn((TableAppender)object3);
                ++n7;
            }
            ++n8;
        }
        ((TableAppender)object3).nextLine();
        n8 = n6;
        for (Map.Entry entry : linkedHashMap2.entrySet()) {
            if (n8 != 0) {
                ((TableAppender)object3).nextLine('\u2500');
            }
            n8 = bl ? 0 : 9472;
            object2 = (ParameterTableRow)entry.getValue();
            ((ParameterTableRow)object2).codespaceWidth = n32;
            ((ParameterTableRow)object2).writeIdentifiers((Appendable)object3, bl4, null, bl3, string2);
            this.nextColumn((TableAppender)object3);
            object = (GeneralParameterDescriptor)entry.getKey();
            if (object instanceof ParameterDescriptor) {
                String n11;
                int n9;
                ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
                Class clazz = parameterDescriptor.getValueClass();
                if (clazz != null) {
                    ((TableAppender)object3).append(this.getFormat(Class.class).format(clazz, (StringBuffer)object4, fieldPosition).toString());
                }
                this.nextColumn((TableAppender)object3);
                ((StringBuffer)object4).setLength(0);
                if (bl2) {
                    int n10 = parameterDescriptor.getMinimumOccurs();
                    n9 = parameterDescriptor.getMaximumOccurs();
                    if (n9 == 1) {
                        ((TableAppender)object3).append(((IndexedResourceBundle)((Object)unit)).getString(n10 == 0 ? (short)152 : 125));
                    } else {
                        Format format = this.getFormat(Integer.class);
                        ((TableAppender)object3).append(format.format(n10, (StringBuffer)object4, fieldPosition).toString()).append(" \u2026 ");
                        ((StringBuffer)object4).setLength(0);
                        if (n9 == Integer.MAX_VALUE) {
                            ((TableAppender)object3).append('\u221e');
                        } else {
                            ((TableAppender)object3).append(format.format(n9, (StringBuffer)object4, fieldPosition).toString());
                            ((StringBuffer)object4).setLength(0);
                        }
                    }
                    this.nextColumn((TableAppender)object3);
                }
                if ((n11 = ((ParameterTableRow)object2).valueDomain) != null) {
                    ((TableAppender)object3).append(CharSequences.spaces(n2 - ((ParameterTableRow)object2).valueDomainAlignment)).append(n11);
                }
                this.nextColumn((TableAppender)object3);
                n9 = clazz != null && Number.class.isAssignableFrom(clazz) ? 1 : -1;
                ((TableAppender)object3).setCellAlignment((byte)n9);
                int format = ((ParameterTableRow)object2).values.size();
                for (int i = 0; i < format; ++i) {
                    CharSequence j;
                    Object object5;
                    Object object6 = ((ParameterTableRow)object2).values.get(i);
                    if (object6 == null) continue;
                    if (i != 0) {
                        object5 = ((IndexedResourceBundle)((Object)unit)).getString((short)68);
                        ((TableAppender)object3).nextLine();
                        ((TableAppender)object3).setCellAlignment((byte)0);
                        for (int k = 0; k < n7; ++k) {
                            ((TableAppender)object3).append((CharSequence)object5);
                            this.nextColumn((TableAppender)object3);
                        }
                        ((TableAppender)object3).setCellAlignment((byte)n9);
                    }
                    if ((object5 = this.getFormat(object6.getClass())) != null) {
                        if (object5 instanceof NumberFormat && object6 instanceof Number) {
                            ParameterFormat.configure((NumberFormat)object5, Math.abs(((Number)object6).doubleValue()));
                        }
                        j = ((Format)object5).format(object6, (StringBuffer)object4, fieldPosition);
                    } else {
                        j = object6 instanceof CodeList ? Types.getCodeTitle((CodeList)object6).toString(this.getLocale()) : (object6 instanceof InternationalString ? ((InternationalString)object6).toString(this.getLocale()) : object6.toString());
                    }
                    ((TableAppender)object3).append(j);
                    ((StringBuffer)object4).setLength(0);
                    int n12 = n4;
                    String string4 = (String)((ParameterTableRow)object2).units.get(i);
                    if (string4 != null) {
                        ((TableAppender)object3).append(string4);
                        n12 -= string4.length();
                    }
                    ((TableAppender)object3).append(CharSequences.spaces(n12));
                }
            }
            ((TableAppender)object3).nextLine();
            ((TableAppender)object3).setCellAlignment((byte)-1);
        }
        ((TableAppender)object3).nextLine((char)n6);
        ((TableAppender)object3).flush();
        for (Map.Entry entry : linkedHashMap.entrySet()) {
            ParameterTableRow.writeFootnoteNumber(appendable, (Integer)entry.getValue());
            appendable.append(' ').append((CharSequence)entry.getKey()).append(string2);
        }
        if (arrayList != null) {
            for (Map.Entry entry : arrayList) {
                if (entry instanceof ParameterValueGroup) {
                    object2 = (ParameterValueGroup)((Object)entry);
                    object = object2.getDescriptor();
                } else {
                    object2 = null;
                    object = (ParameterDescriptorGroup)((Object)entry);
                }
                appendable.append(string2);
                this.format(string + '/' + object.getName().getCode(), (ParameterDescriptorGroup)object, (ParameterValueGroup)object2, appendable);
            }
        }
    }

    private static void configure(NumberFormat numberFormat, double d) {
        int n;
        if (numberFormat.getMaximumFractionDigits() <= 9 && (n = d < 10.0 ? 9 : (d < 1000.0 ? 6 : 3)) >= numberFormat.getMinimumFractionDigits()) {
            numberFormat.setMaximumFractionDigits(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formatSummary(IdentifiedObject[] identifiedObjectArray, Appendable appendable) throws IOException {
        Object object;
        Vocabulary vocabulary = Vocabulary.getResources(this.displayLocale);
        boolean bl = false;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        LinkedHashMap<String, Integer> linkedHashMap = new LinkedHashMap<String, Integer>();
        linkedHashMap.put(null, 0);
        if (this.preferredCodespaces != null) {
            for (String string : this.preferredCodespaces) {
                linkedHashMap.put(string, linkedHashMap.size());
            }
        }
        for (IdentifiedObject object2 : identifiedObjectArray) {
            Collection<GenericName> collection;
            String[] stringArray = new String[linkedHashMap.size()];
            Set<ReferenceIdentifier> set = object2.getIdentifiers();
            if (set != null) {
                object = null;
                collection = set.iterator();
                while (collection.hasNext()) {
                    ReferenceIdentifier referenceIdentifier = (ReferenceIdentifier)collection.next();
                    if (referenceIdentifier == null) continue;
                    if (this.isPreferredCodespace(referenceIdentifier.getCodeSpace())) {
                        object = referenceIdentifier;
                        break;
                    }
                    if (object != null) continue;
                    object = referenceIdentifier;
                }
                if (object != null) {
                    stringArray[0] = IdentifiedObjects.toString((Identifier)object);
                    bl = true;
                }
            }
            if ((object = object2.getName()) != null && this.isPreferredCodespace((String)((Object)(collection = object.getCodeSpace())))) {
                stringArray = ParameterFormat.putIfAbsent(vocabulary, stringArray, linkedHashMap, collection, object.getCode());
                object = null;
            }
            if ((collection = object2.getAlias()) != null) {
                for (GenericName genericName : collection) {
                    String string;
                    if (genericName == null || !this.isPreferredCodespace(string = NameToIdentifier.getCodeSpace(genericName, this.displayLocale))) continue;
                    stringArray = ParameterFormat.putIfAbsent(vocabulary, stringArray, linkedHashMap, string, genericName.tip().toInternationalString().toString(this.displayLocale));
                    object = null;
                }
            }
            if (object != null) {
                stringArray = ParameterFormat.putIfAbsent(vocabulary, stringArray, linkedHashMap, object.getCodeSpace(), object.getCode());
            }
            arrayList.add(stringArray);
        }
        boolean bl2 = this.colors != null;
        TableAppender tableAppender = new TableAppender(appendable, this.columnSeparator);
        tableAppender.setMultiLinesCells(true);
        tableAppender.appendHorizontalSeparator();
        for (String string : linkedHashMap.keySet()) {
            void var10_21;
            if (string == null) {
                if (!bl) continue;
                String string2 = vocabulary.getString((short)99);
            }
            if (bl2) {
                void var10_19;
                String string3 = X364.BOLD.sequence() + (String)var10_19 + X364.NORMAL.sequence();
            }
            tableAppender.append((CharSequence)var10_21);
            this.nextColumn(tableAppender);
        }
        tableAppender.appendHorizontalSeparator();
        int n = linkedHashMap.size();
        for (String[] stringArray : arrayList) {
            int n2;
            int n3 = n2 = bl ? 0 : 1;
            while (n2 < n) {
                if (n2 < stringArray.length && (object = stringArray[n2]) != null) {
                    tableAppender.append((CharSequence)object);
                }
                this.nextColumn(tableAppender);
                ++n2;
            }
            tableAppender.nextLine();
        }
        tableAppender.appendHorizontalSeparator();
        tableAppender.flush();
    }

    private static String[] putIfAbsent(Vocabulary vocabulary, String[] stringArray, Map<String, Integer> map, String string, String string2) {
        int n;
        Integer n2;
        if (string == null) {
            string = vocabulary.getString((short)208);
        }
        if ((n2 = map.get(string)) != null) {
            n = n2;
        } else {
            n = map.size();
            map.put(string, n);
        }
        if (n >= stringArray.length) {
            stringArray = Arrays.copyOf(stringArray, n + 1);
        }
        if (stringArray[n] == null) {
            stringArray[n] = string2;
        }
        return stringArray;
    }

    private static ParameterFormat getSharedInstance(Colors colors) {
        ParameterFormat parameterFormat = INSTANCE.getAndSet(null);
        if (parameterFormat == null) {
            parameterFormat = new ParameterFormat();
        }
        parameterFormat.setColors(colors);
        return parameterFormat;
    }

    static String sharedFormat(Object object) {
        ParameterFormat parameterFormat = ParameterFormat.getSharedInstance(null);
        String string = parameterFormat.format(object);
        INSTANCE.set(parameterFormat);
        return string;
    }

    static void print(Object object) {
        Console console = System.console();
        Closeable closeable = console != null ? console.writer() : System.out;
        ParameterFormat parameterFormat = ParameterFormat.getSharedInstance(Colors.NAMING);
        try {
            parameterFormat.format(object, (Appendable)((Object)closeable));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        INSTANCE.set(parameterFormat);
    }

    @Override
    public Object parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        throw new ParseException(Errors.getResources(this.displayLocale).getString((short)162, "parse"), parsePosition.getIndex());
    }

    @Override
    public ParameterFormat clone() {
        ParameterFormat parameterFormat = (ParameterFormat)super.clone();
        parameterFormat.colors = parameterFormat.colors.clone();
        return parameterFormat;
    }

    public static enum ContentLevel {
        DETAILED,
        BRIEF,
        NAME_SUMMARY;

    }
}

