/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.esri;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.Line;
import com.esri.core.geometry.MultiPath;
import com.esri.core.geometry.MultiPoint;
import com.esri.core.geometry.OperatorCentroid2D;
import com.esri.core.geometry.OperatorImportFromWkb;
import com.esri.core.geometry.OperatorImportFromWkt;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polygon;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.Segment;
import java.io.ObjectStreamException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.sis.internal.feature.Geometries;
import org.apache.sis.internal.feature.GeometryType;
import org.apache.sis.internal.feature.GeometryWrapper;
import org.apache.sis.internal.feature.esri.Wrapper;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.math.Vector;
import org.apache.sis.setup.GeometryLibrary;

public final class Factory
extends Geometries<Geometry> {
    private static final long serialVersionUID = 7832006589071845318L;
    public static final Factory INSTANCE = new Factory();

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }

    private Factory() {
        super(GeometryLibrary.ESRI, Geometry.class, Point.class, Polyline.class, Polygon.class);
    }

    @Override
    public GeometryWrapper<Geometry> castOrWrap(Object object) {
        return object == null || object instanceof Wrapper ? (Wrapper)object : new Wrapper((Geometry)object);
    }

    @Override
    protected GeometryWrapper<Geometry> createWrapper(Geometry geometry) {
        return new Wrapper(geometry);
    }

    @Override
    public Object createPoint(double d, double d2) {
        return new Point(d, d2);
    }

    @Override
    public Object createPoint(double d, double d2, double d3) {
        return new Point(d, d2, d3);
    }

    @Override
    public Geometry createPolyline(boolean bl, int n, Vector ... polygon) {
        if (n != 2) {
            throw new UnsupportedOperationException(Factory.unsupported(n));
        }
        boolean bl2 = false;
        Polyline polyline = new Polyline();
        for (Vector vector : polygon) {
            if (vector == null) continue;
            int n2 = vector.size();
            int n3 = 0;
            while (n3 < n2) {
                double d = vector.doubleValue(n3++);
                double d2 = vector.doubleValue(n3++);
                if (Double.isNaN(d) || Double.isNaN(d2)) {
                    bl2 = false;
                    continue;
                }
                if (bl2) {
                    polyline.lineTo(d, d2);
                    continue;
                }
                polyline.startPath(d, d2);
                bl2 = true;
            }
        }
        if (bl) {
            Polygon polygon2 = new Polygon();
            polygon2.add((MultiPath)polyline, false);
            return polygon2;
        }
        return polyline;
    }

    @Override
    public GeometryWrapper<Geometry> createMultiPolygon(Object[] objectArray) {
        Polygon polygon = new Polygon();
        for (Object object : objectArray) {
            polygon.add((MultiPath)Factory.unwrap(object), false);
        }
        return new Wrapper((Geometry)polygon);
    }

    @Override
    public GeometryWrapper<Geometry> createFromComponents(GeometryType geometryType, Object object) {
        List<Object> list = object instanceof Collection ? (List<Object>)object : Arrays.asList((Object[])object);
        Geometry geometry = (Geometry)CollectionsExt.singletonOrNull(list);
        if (geometry == null) {
            Iterator iterator;
            MultiPoint multiPoint;
            boolean bl = false;
            switch (geometryType) {
                case MULTI_LINESTRING: 
                case LINESTRING: {
                    break;
                }
                case MULTI_POLYGON: 
                case POLYGON: {
                    bl = true;
                    break;
                }
                case GEOMETRY_COLLECTION: {
                    multiPoint = list.iterator();
                    while (multiPoint.hasNext() && (bl = ((Geometry)(iterator = multiPoint.next())).getType() == Geometry.Type.Polygon)) {
                    }
                    break;
                }
                case GEOMETRY: 
                case POINT: 
                case MULTI_POINT: {
                    multiPoint = new MultiPoint();
                    for (Object object2 : list) {
                        multiPoint.add((Point)object2);
                    }
                    geometry = multiPoint;
                    if (geometryType != GeometryType.POINT) break;
                    geometry = new Point(OperatorCentroid2D.local().execute(geometry, null));
                    break;
                }
                default: {
                    throw new AssertionError((Object)geometryType);
                }
            }
            if (geometry == null) {
                Object object2 = multiPoint = bl ? new Polygon() : new Polyline();
                if (geometryType.isCollection()) {
                    for (Object e : list) {
                        multiPoint.add((MultiPath)e, false);
                    }
                } else {
                    iterator = list.iterator();
                    if (iterator.hasNext()) {
                        Line line = new Line();
                        line.setEnd((Point)iterator.next());
                        while (iterator.hasNext()) {
                            line.setStartXY(line.getEndX(), line.getEndY());
                            line.setEnd((Point)iterator.next());
                            multiPoint.addSegment((Segment)line, false);
                        }
                    }
                }
                geometry = multiPoint;
            }
        }
        return new Wrapper(geometry);
    }

    @Override
    public GeometryWrapper<Geometry> parseWKT(String string) {
        return new Wrapper(OperatorImportFromWkt.local().execute(0, Geometry.Type.Unknown, string, null));
    }

    @Override
    public GeometryWrapper<Geometry> parseWKB(ByteBuffer byteBuffer) {
        return new Wrapper(OperatorImportFromWkb.local().execute(0, Geometry.Type.Unknown, byteBuffer, null));
    }
}

