/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.UncheckedIOException;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Angle;
import javax.measure.quantity.Length;
import javax.measure.quantity.Time;
import org.apache.sis.geometry.GeneralDirectPosition;
import org.apache.sis.internal.jdk9.JDK9;
import org.apache.sis.internal.referencing.AxisDirections;
import org.apache.sis.internal.referencing.Formulas;
import org.apache.sis.internal.referencing.ReferencingUtilities;
import org.apache.sis.internal.util.LocalizedParseException;
import org.apache.sis.internal.util.Numerics;
import org.apache.sis.io.CompoundFormat;
import org.apache.sis.math.DecimalFunctions;
import org.apache.sis.math.MathFunctions;
import org.apache.sis.measure.AngleFormat;
import org.apache.sis.measure.Latitude;
import org.apache.sis.measure.Longitude;
import org.apache.sis.measure.QuantityFormat;
import org.apache.sis.measure.UnitFormat;
import org.apache.sis.measure.Units;
import org.apache.sis.referencing.CRS;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.logging.Logging;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.TemporalCRS;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.cs.CoordinateSystemAxis;
import org.opengis.referencing.datum.Ellipsoid;

public class CoordinateFormat
extends CompoundFormat<DirectPosition> {
    private static final long serialVersionUID = 6633388113040644304L;
    private static final int READ_AHEAD_LIMIT = 256;
    private static final int DEFAULT_DIMENSION = 4;
    private static final Set<Unit<?>> SCALABLES = JDK9.setOf(Units.METRE, Units.PASCAL);
    private String separator = "\u2003";
    private transient String parseSeparator = "";
    private Quantity<?> groundPrecision;
    private Quantity<?> groundAccuracy;
    private transient double accuracyThreshold;
    private transient long groundDimensions;
    private double[] desiredPrecisions;
    private transient boolean isPrecisionApplied;
    private transient boolean isAccuracyVisible;
    private CoordinateReferenceSystem defaultCRS;
    private transient CoordinateReferenceSystem lastCRS;
    private static final byte LONGITUDE = 1;
    private static final byte LATITUDE = 2;
    private static final byte ANGLE = 3;
    private static final byte DATE = 4;
    private static final byte TIME = 5;
    private static final byte INDEX = 6;
    private transient byte[] types;
    private transient Format[] sharedFormats;
    private transient Format[] formats;
    private transient Unit<?>[] units;
    private transient UnitConverter[] toFormatUnit;
    private transient String[] unitSymbols;
    private transient String[] unitSymbolsUnscaled;
    private transient String[] directionSymbols;
    private transient String accuracyText;
    private transient long negate;
    private transient long[] epochs;
    private transient FieldPosition dummy;
    private transient StringBuffer buffer;

    public CoordinateFormat() {
        this(Locale.getDefault(Locale.Category.FORMAT), TimeZone.getDefault());
    }

    public CoordinateFormat(Locale locale, TimeZone timeZone) {
        super(locale, timeZone);
    }

    public String getSeparator() {
        return this.separator;
    }

    public void setSeparator(String string) {
        ArgumentChecks.ensureNonEmpty("separator", string);
        this.separator = string;
        this.parseSeparator = CharSequences.trimWhitespaces(string);
    }

    public CoordinateReferenceSystem getDefaultCRS() {
        return this.defaultCRS;
    }

    public void setDefaultCRS(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.isPrecisionApplied &= coordinateReferenceSystem == this.defaultCRS;
        this.defaultCRS = coordinateReferenceSystem;
    }

    private void createFormats(CoordinateReferenceSystem coordinateReferenceSystem) {
        this.types = null;
        this.formats = null;
        this.sharedFormats = null;
        this.units = null;
        this.toFormatUnit = null;
        this.unitSymbols = null;
        this.unitSymbolsUnscaled = null;
        this.directionSymbols = null;
        this.epochs = null;
        this.negate = 0L;
        this.lastCRS = coordinateReferenceSystem;
        this.isPrecisionApplied = false;
        if (coordinateReferenceSystem == null) {
            return;
        }
        CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
        if (coordinateSystem == null) {
            return;
        }
        int n = coordinateSystem.getDimension();
        byte[] byArray = new byte[n];
        Format[] formatArray = new Format[n];
        for (int i = 0; i < n; ++i) {
            CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
            if (coordinateSystemAxis == null) {
                formatArray[i] = this.getDefaultFormat();
                continue;
            }
            AxisDirection axisDirection = coordinateSystemAxis.getDirection();
            Unit<?> unit = coordinateSystemAxis.getUnit();
            if (Units.isAngular(unit)) {
                int n2 = 3;
                if (AxisDirection.NORTH.equals(axisDirection)) {
                    n2 = 2;
                } else if (AxisDirection.EAST.equals(axisDirection)) {
                    n2 = 1;
                } else if (AxisDirection.SOUTH.equals(axisDirection)) {
                    n2 = 2;
                    this.negate(i);
                } else if (AxisDirection.WEST.equals(axisDirection)) {
                    n2 = 1;
                    this.negate(i);
                }
                byArray[i] = n2;
                formatArray[i] = this.getFormat(org.apache.sis.measure.Angle.class);
                this.setConverter(n, i, unit.asType(Angle.class).getConverterTo(Units.DEGREE));
                continue;
            }
            if (Units.isTemporal(unit)) {
                CoordinateReferenceSystem coordinateReferenceSystem2 = CRS.getComponentAt(coordinateReferenceSystem, i, i + 1);
                if (coordinateReferenceSystem2 instanceof TemporalCRS) {
                    if (this.epochs == null) {
                        this.epochs = new long[n];
                    }
                    byArray[i] = 4;
                    formatArray[i] = this.getFormat(Date.class);
                    this.epochs[i] = ((TemporalCRS)coordinateReferenceSystem2).getDatum().getOrigin().getTime();
                    this.setConverter(n, i, unit.asType(Time.class).getConverterTo(Units.MILLISECOND));
                    if (!AxisDirection.PAST.equals(axisDirection)) continue;
                    this.negate(i);
                    continue;
                }
                byArray[i] = 5;
            } else if (AxisDirections.isGrid(axisDirection) && (unit == null || Units.PIXEL.isCompatible(unit))) {
                byArray[i] = 6;
            }
            formatArray[i] = this.getFormat(byArray[i] == 6 ? Long.class : Number.class);
            if (unit != null) {
                if (this.units == null) {
                    this.units = new Unit[n];
                }
                this.units[i] = unit;
                String string = this.getFormat(Unit.class).format(unit);
                if (!string.isEmpty()) {
                    if (this.unitSymbols == null) {
                        this.unitSymbolsUnscaled = new String[n];
                        this.unitSymbols = this.unitSymbolsUnscaled;
                    }
                    this.unitSymbols[i] = '\u202f' + string;
                }
            }
            if (!AxisDirections.isCompass(axisDirection)) continue;
            if (this.directionSymbols == null) {
                this.directionSymbols = new String[n * 2];
            }
            this.directionSymbols[i * 2] = CoordinateFormat.symbol(axisDirection);
            this.directionSymbols[i * 2 + 1] = CoordinateFormat.symbol(AxisDirections.opposite(axisDirection));
        }
        this.types = byArray;
        this.formats = formatArray;
        this.sharedFormats = formatArray;
    }

    private static String symbol(AxisDirection axisDirection) {
        return ((StringBuilder)CharSequences.camelCaseToAcronym(axisDirection.identifier())).insert(0, '\u00a0').toString();
    }

    private Format getFormatClone(int n) {
        Format format;
        if (this.formats == this.sharedFormats) {
            this.formats = (Format[])this.formats.clone();
        }
        if ((format = this.formats[n]) == this.sharedFormats[n]) {
            this.formats[n] = format = (Format)format.clone();
        }
        return format;
    }

    private Format getDefaultFormat() {
        return this.getFormat(Number.class);
    }

    private void setConverter(int n, int n2, UnitConverter unitConverter) {
        if (!unitConverter.isIdentity()) {
            if (this.toFormatUnit == null) {
                this.toFormatUnit = new UnitConverter[n];
            }
            this.toFormatUnit[n2] = unitConverter;
        }
    }

    private <Q extends Quantity<Q>> void scaleUnit(int n, Unit<Q> unit) {
        if (this.toFormatUnit == null) {
            this.toFormatUnit = new UnitConverter[this.formats.length];
        }
        if (this.toFormatUnit[n] == null) {
            Unit<Q> unit2 = unit.multiply(1000.0);
            this.toFormatUnit[n] = unit.getConverterTo(unit2);
            if (this.unitSymbols == this.unitSymbolsUnscaled) {
                this.unitSymbols = (String[])this.unitSymbols.clone();
            }
            this.unitSymbols[n] = '\u202f' + this.getFormat(Unit.class).format(unit2);
        }
    }

    private void negate(int n) {
        if (n >= 64) {
            throw new ArithmeticException(Errors.format((short)37, n + 1));
        }
        this.negate |= 1L << n;
    }

    private boolean isNegative(int n) {
        return (this.negate & Numerics.bitmask(n)) != 0L;
    }

    public double[] getPrecisions() {
        this.configure(this.defaultCRS);
        Object[] objectArray = this.formats;
        if (objectArray == null) {
            objectArray = new Format[4];
            Arrays.fill(objectArray, this.getDefaultFormat());
        }
        double[] dArray = new double[objectArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            Object object = objectArray[i];
            if (object instanceof DecimalFormat) {
                dArray[i] = MathFunctions.pow10(-((DecimalFormat)object).getMaximumFractionDigits());
                continue;
            }
            if (!(object instanceof AngleFormat)) continue;
            dArray[i] = ((AngleFormat)object).getPrecision();
        }
        return dArray;
    }

    public void setPrecisions(double ... dArray) {
        if (dArray == null) {
            this.desiredPrecisions = null;
            this.formats = this.sharedFormats;
        } else {
            if (this.desiredPrecisions == null || this.desiredPrecisions.length != dArray.length) {
                this.desiredPrecisions = new double[dArray.length];
            }
            this.isPrecisionApplied &= this.formats != null;
            for (int i = 0; i < dArray.length; ++i) {
                double d = Math.abs(dArray[i]);
                if (!(d < Double.POSITIVE_INFINITY)) {
                    d = 0.0;
                }
                if (this.desiredPrecisions[i] == (this.desiredPrecisions[i] = d) || !this.isPrecisionApplied) continue;
                this.applyPrecision(i);
            }
        }
        this.updateAccuracyVisibility();
    }

    private void applyPrecision(int n) {
        double d = this.desiredPrecisions[n];
        if (d > 0.0) {
            Format format = this.formats[n];
            if (format instanceof DecimalFormat && (this.types == null || this.types[n] != 6)) {
                Object object;
                int n2 = DecimalFunctions.fractionDigitsForDelta(d, false);
                if (this.unitSymbols != null && SCALABLES.contains(object = this.units[n])) {
                    if (d >= 10.0) {
                        n2 += 3;
                        this.scaleUnit(n, (Unit)object);
                    } else if (this.toFormatUnit != null) {
                        this.toFormatUnit[n] = null;
                        this.unitSymbols[n] = this.unitSymbolsUnscaled[n];
                    }
                }
                n2 = Math.max(n2, 0);
                object = (DecimalFormat)this.getFormatClone(n);
                ((DecimalFormat)object).setMinimumFractionDigits(n2);
                ((DecimalFormat)object).setMaximumFractionDigits(n2);
            } else if (format instanceof AngleFormat) {
                ((AngleFormat)this.getFormatClone(n)).setPrecision(d, true);
            }
        }
    }

    private void configure(CoordinateReferenceSystem coordinateReferenceSystem) {
        if (this.lastCRS != coordinateReferenceSystem) {
            this.createFormats(coordinateReferenceSystem);
        }
        if (!this.isPrecisionApplied) {
            if (this.groundPrecision != null) {
                this.applyGroundPrecision(coordinateReferenceSystem);
            }
            if (this.desiredPrecisions != null) {
                if (this.sharedFormats == null) {
                    this.sharedFormats = new Format[this.desiredPrecisions.length];
                    this.formats = this.sharedFormats;
                    Arrays.fill(this.formats, this.getDefaultFormat());
                    this.types = new byte[this.formats.length];
                }
                int n = Math.min(this.desiredPrecisions.length, this.formats.length);
                for (int i = 0; i < n; ++i) {
                    this.applyPrecision(i);
                }
            }
            this.applyGroundAccuracy(coordinateReferenceSystem);
            this.updateAccuracyVisibility();
            this.isPrecisionApplied = true;
        }
    }

    public void setGroundPrecision(Quantity<?> quantity) {
        ArgumentChecks.ensureNonNull("precision", quantity);
        this.groundPrecision = quantity;
        if (this.isPrecisionApplied) {
            this.applyGroundPrecision(this.lastCRS);
        }
    }

    public void setGroundAccuracy(Quantity<?> quantity) {
        this.accuracyText = null;
        this.groundAccuracy = quantity;
        if (quantity != null) {
            NumberFormat numberFormat = NumberFormat.getInstance(this.getLocale(Locale.Category.FORMAT));
            QuantityFormat quantityFormat = new QuantityFormat(numberFormat, (UnitFormat)this.getFormat(Unit.class));
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            this.buffer.setLength(0);
            this.accuracyText = quantityFormat.format(quantity, this.buffer.append("\u2003\u00b1\u00a0"), this.dummy).toString();
        }
        if (this.isPrecisionApplied) {
            this.applyGroundAccuracy(this.lastCRS);
            this.updateAccuracyVisibility();
        }
    }

    private void applyGroundPrecision(CoordinateReferenceSystem coordinateReferenceSystem) {
        CoordinateSystem coordinateSystem;
        IncommensurableException incommensurableException;
        Resolution resolution;
        Resolution resolution2 = new Resolution(this.groundPrecision);
        try {
            resolution = resolution2.derived(coordinateReferenceSystem);
            incommensurableException = null;
        }
        catch (IncommensurableException incommensurableException2) {
            resolution = null;
            incommensurableException = incommensurableException2;
        }
        this.groundDimensions = 0L;
        boolean bl = false;
        boolean bl2 = false;
        if (coordinateReferenceSystem != null && (coordinateSystem = coordinateReferenceSystem.getCoordinateSystem()) != null) {
            int n = coordinateSystem.getDimension();
            boolean bl3 = false;
            while (true) {
                for (int i = 0; i < n; ++i) {
                    CoordinateSystemAxis coordinateSystemAxis = coordinateSystem.getAxis(i);
                    if (coordinateSystemAxis == null) continue;
                    AxisDirection axisDirection = coordinateSystemAxis.getDirection();
                    if (!bl3 && !AxisDirections.isCompass(axisDirection)) continue;
                    resolution2.findMaxValue(coordinateSystemAxis);
                    Unit<?> unit = coordinateSystemAxis.getUnit();
                    if (unit == null) continue;
                    try {
                        boolean bl4 = resolution2.findMinResolution(unit, bl);
                        bl |= bl4;
                        if (!bl4 && resolution != null) {
                            bl4 = resolution.findMinResolution(unit, bl2);
                            bl2 |= bl4;
                        }
                        if (!bl4) continue;
                        this.groundDimensions |= Numerics.bitmask(i);
                        continue;
                    }
                    catch (IncommensurableException incommensurableException3) {
                        if (incommensurableException == null) {
                            incommensurableException = incommensurableException3;
                            continue;
                        }
                        incommensurableException.addSuppressed(incommensurableException3);
                    }
                }
                if (bl | bl2) break;
                if (bl3) {
                    bl = true;
                    resolution = null;
                    break;
                }
                bl3 = true;
            }
        }
        if (bl) {
            resolution2.setPrecision(this);
        }
        if (bl2) {
            resolution.setPrecision(this);
        }
        if (incommensurableException != null) {
            CoordinateFormat.unexpectedException("setGroundPrecision", incommensurableException);
        }
    }

    private void applyGroundAccuracy(CoordinateReferenceSystem coordinateReferenceSystem) {
        block7: {
            long l = this.groundDimensions;
            if (l != 0L && this.groundAccuracy != null) {
                try {
                    int n;
                    Resolution resolution = new Resolution(this.groundAccuracy);
                    Resolution resolution2 = resolution.derived(coordinateReferenceSystem);
                    CoordinateSystem coordinateSystem = coordinateReferenceSystem.getCoordinateSystem();
                    this.accuracyThreshold = 0.0;
                    do {
                        double d;
                        Unit<?> unit;
                        if ((unit = coordinateSystem.getAxis(n = Long.numberOfTrailingZeros(l)).getUnit()).isCompatible(resolution.unit)) {
                            d = resolution.resolution(unit);
                        } else {
                            if (resolution2 == null || !unit.isCompatible(resolution2.unit)) break block7;
                            d = resolution2.resolution(unit);
                        }
                        if (!(d > this.accuracyThreshold)) continue;
                        this.accuracyThreshold = d;
                    } while ((l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
                    return;
                }
                catch (IncommensurableException incommensurableException) {
                    CoordinateFormat.unexpectedException("setGroundAccuracy", incommensurableException);
                }
            }
        }
        this.accuracyThreshold = Double.POSITIVE_INFINITY;
    }

    private void updateAccuracyVisibility() {
        long l;
        boolean bl = this.isAccuracyVisible = this.accuracyText != null;
        if (this.isAccuracyVisible && this.desiredPrecisions != null && (l = this.groundDimensions & Numerics.bitmask(this.desiredPrecisions.length) - 1L) != 0L) {
            int n;
            this.isAccuracyVisible = false;
            do {
                double d;
                if (!((d = this.desiredPrecisions[n = Long.numberOfTrailingZeros(l)]) > 0.0) || !(d <= this.accuracyThreshold)) continue;
                this.isAccuracyVisible = true;
                break;
            } while ((l &= 1L << n ^ 0xFFFFFFFFFFFFFFFFL) != 0L);
        }
    }

    public Quantity<?> getGroundAccuracy() {
        return this.groundAccuracy;
    }

    public Optional<String> getGroundAccuracyText() {
        return Optional.ofNullable(this.accuracyText);
    }

    public String getPattern(Class<?> clazz) {
        Format format = this.getFormat(clazz);
        if (format instanceof AngleFormat) {
            return ((AngleFormat)format).toPattern();
        }
        if (format instanceof DecimalFormat) {
            return ((DecimalFormat)format).toPattern();
        }
        if (format instanceof SimpleDateFormat) {
            return ((SimpleDateFormat)format).toPattern();
        }
        return null;
    }

    public boolean applyPattern(Class<?> clazz, String string) {
        ArgumentChecks.ensureNonNull("pattern", string);
        Format format = this.getFormat(clazz);
        if (format instanceof DecimalFormat) {
            ((DecimalFormat)format).applyPattern(string);
        } else if (format instanceof SimpleDateFormat) {
            ((SimpleDateFormat)format).applyPattern(string);
        } else if (format instanceof AngleFormat) {
            ((AngleFormat)format).applyPattern(string);
        } else {
            return false;
        }
        this.formats = this.sharedFormats;
        return true;
    }

    @Override
    public final Class<DirectPosition> getValueType() {
        return DirectPosition.class;
    }

    @Override
    protected Format createFormat(Class<?> clazz) {
        Locale locale;
        if (clazz == Date.class && !Locale.ROOT.equals(locale = super.getLocale())) {
            DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3, locale);
            dateFormat.setTimeZone(this.getTimeZone());
            return dateFormat;
        }
        return super.createFormat(clazz);
    }

    public String format(DirectPosition directPosition) {
        if (this.buffer == null) {
            this.buffer = new StringBuffer();
        }
        this.buffer.setLength(0);
        try {
            this.format(directPosition, (Appendable)this.buffer);
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return this.buffer.toString();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    public void format(DirectPosition var1_1, Appendable var2_2) throws IOException {
        ArgumentChecks.ensureNonNull("position", var1_1);
        ArgumentChecks.ensureNonNull("toAppendTo", var2_2);
        var3_3 = var1_1.getCoordinateReferenceSystem();
        if (var3_3 == null) {
            var3_3 = this.defaultCRS;
        }
        this.configure(var3_3);
        if (var2_2 instanceof StringBuffer) {
            var4_4 = (StringBuffer)var2_2;
        } else {
            if (this.buffer == null) {
                this.buffer = new StringBuffer();
            }
            var4_4 = this.buffer;
            var4_4.setLength(0);
        }
        if (this.dummy == null) {
            this.dummy = new FieldPosition(0);
        }
        var5_5 = var1_1.getDimension();
        for (var6_6 = 0; var6_6 < var5_5; ++var6_6) {
            block25: {
                block24: {
                    var7_7 = var1_1.getOrdinate(var6_6);
                    if (this.formats == null || var6_6 >= this.formats.length) break block24;
                    var12_11 = this.formats[var6_6];
                    v0 = var10_9 = this.unitSymbols != null ? this.unitSymbols[var6_6] : null;
                    if (this.directionSymbols == null) {
                        var11_10 = null;
                    } else if (var7_7 < 0.0) {
                        var7_7 = -var7_7;
                        var11_10 = this.directionSymbols[var6_6 * 2 + 1];
                    } else {
                        var11_10 = this.directionSymbols[var6_6 * 2];
                    }
                    if (this.isNegative(var6_6)) {
                        var7_7 = -var7_7;
                    }
                    if (this.toFormatUnit != null && (var13_12 = this.toFormatUnit[var6_6]) != null) {
                        var7_7 = var13_12.convert(var7_7);
                    }
                    switch (this.types[var6_6]) {
                        default: {
                            var9_8 /* !! */  = var7_7;
                            break block25;
                        }
                        case 6: {
                            var9_8 /* !! */  = Math.round(var7_7);
                            break block25;
                        }
                        case 1: {
                            var9_8 /* !! */  = new Longitude(var7_7);
                            break block25;
                        }
                        case 2: {
                            var9_8 /* !! */  = new Latitude(var7_7);
                            break block25;
                        }
                        case 3: {
                            var9_8 /* !! */  = new org.apache.sis.measure.Angle(var7_7);
                            break block25;
                        }
                        case 4: {
                            if (!Double.isFinite(var7_7)) ** GOTO lbl54
                            var9_8 /* !! */  = new Date(Math.addExact(Math.round(var7_7), this.epochs[var6_6]));
                            break block25;
lbl54:
                            // 1 sources

                            if (var6_6 != 0) {
                                var2_2.append(this.separator);
                            }
                            var2_2.append(String.valueOf(var7_7));
                            break;
                        }
                    }
                    continue;
                }
                var9_8 /* !! */  = var7_7;
                var12_11 = this.getDefaultFormat();
                var11_10 = null;
                var10_9 = null;
            }
            if (var6_6 != 0) {
                var2_2.append(this.separator);
            }
            if (var12_11.format(var9_8 /* !! */ , var4_4, this.dummy) != var2_2) {
                var2_2.append(var4_4);
                var4_4.setLength(0);
            }
            if (var10_9 != null) {
                var2_2.append(var10_9);
            }
            if (var11_10 == null) continue;
            var2_2.append(var11_10);
        }
        if (this.isAccuracyVisible) {
            var2_2.append(this.accuracyText);
        }
    }

    @Override
    public DirectPosition parse(CharSequence charSequence, ParsePosition parsePosition) throws ParseException {
        int n;
        int n2;
        double[] dArray;
        Format format;
        Format[] formatArray;
        String string;
        ParsePosition parsePosition2;
        int n3;
        ArgumentChecks.ensureNonNull("text", charSequence);
        ArgumentChecks.ensureNonNull("pos", parsePosition);
        int n4 = parsePosition.getIndex();
        int n5 = charSequence.length();
        if (charSequence instanceof String) {
            n3 = 0;
            parsePosition2 = parsePosition;
            string = (String)charSequence;
        } else {
            n3 = n4;
            parsePosition2 = new ParsePosition(0);
            string = charSequence.subSequence(n4, Math.min(n4 + 256, n5)).toString();
        }
        if (this.lastCRS != this.defaultCRS) {
            this.createFormats(this.defaultCRS);
        }
        if ((formatArray = this.formats) != null) {
            format = null;
            dArray = new double[formatArray.length];
        } else {
            format = this.getDefaultFormat();
            dArray = new double[4];
        }
        for (n2 = 0; n2 < dArray.length; ++n2) {
            int n6;
            Object object;
            Object[] objectArray;
            CharSequence charSequence2;
            block49: {
                if (n2 != 0) {
                    short s;
                    int n7;
                    int n8;
                    int n9 = parsePosition2.getIndex();
                    for (n7 = n3 + n9; n7 < n5; n7 += Character.charCount(n8)) {
                        if (this.parseSeparator.isEmpty()) {
                            n8 = CharSequences.skipLeadingWhitespaces(charSequence, n7, n5);
                            if (n8 > n7) {
                                parsePosition2.setIndex(n8 - n3);
                                break block49;
                            }
                        } else if (CharSequences.regionMatches(charSequence, n7, this.parseSeparator)) {
                            parsePosition2.setIndex(n7 + this.parseSeparator.length() - n3);
                            break block49;
                        }
                        if (!Character.isSpaceChar(n8 = Character.codePointAt(charSequence, n7))) break;
                    }
                    if (formatArray == null) {
                        parsePosition.setIndex(n7);
                        return new GeneralDirectPosition(Arrays.copyOf(dArray, n2));
                    }
                    parsePosition.setIndex(n4);
                    parsePosition.setErrorIndex(n7);
                    CharSequence charSequence3 = charSequence.subSequence(n4, n9);
                    charSequence2 = CharSequences.token(charSequence, n7);
                    if (charSequence2.length() != 0) {
                        s = 135;
                        objectArray = new CharSequence[]{charSequence3, charSequence2};
                    } else {
                        s = 138;
                        objectArray = new CharSequence[]{charSequence3};
                    }
                    throw new LocalizedParseException(this.getLocale(), s, objectArray, n7);
                }
            }
            if (formatArray != null) {
                format = formatArray[n2];
            }
            if ((object = format.parseObject(string, parsePosition2)) == null) {
                Class clazz = Number.class;
                if (this.types != null) {
                    switch (this.types[n2]) {
                        case 1: {
                            clazz = Longitude.class;
                            break;
                        }
                        case 2: {
                            clazz = Latitude.class;
                            break;
                        }
                        case 3: {
                            clazz = org.apache.sis.measure.Angle.class;
                            break;
                        }
                        case 4: {
                            clazz = Date.class;
                            break;
                        }
                        case 6: {
                            clazz = Long.class;
                        }
                    }
                }
                parsePosition.setIndex(n4);
                if (parsePosition2 != parsePosition) {
                    parsePosition.setErrorIndex(n3 + parsePosition2.getErrorIndex());
                }
                throw new LocalizedParseException(this.getLocale(), clazz, charSequence, parsePosition);
            }
            double d = object instanceof org.apache.sis.measure.Angle ? ((org.apache.sis.measure.Angle)object).degrees() : (object instanceof Date ? (double)Math.subtractExact(((Date)object).getTime(), this.epochs[n2]) : ((Number)object).doubleValue());
            charSequence2 = null;
            String string2 = null;
            if (this.directionSymbols != null) {
                charSequence2 = this.directionSymbols[n2 * 2];
                string2 = this.directionSymbols[n2 * 2 + 1];
            }
            UnitConverter unitConverter = null;
            if (this.units != null && (objectArray = this.units[n2]) != null) {
                int n10;
                for (int i = n6 = parsePosition2.getIndex(); i < string.length(); i += Character.charCount(n10)) {
                    n10 = string.codePointAt(i);
                    if (Character.isSpaceChar(n10)) {
                        continue;
                    }
                    int n11 = i;
                    int n12 = -1;
                    if (charSequence2 != null) {
                        while ((n11 += Character.charCount(n10)) < string.length()) {
                            n10 = string.codePointAt(n11);
                            if (!Character.isSpaceChar(n10)) continue;
                            if (string.regionMatches(true, n11, (String)charSequence2, 0, ((String)charSequence2).length())) {
                                n12 = n11 + ((String)charSequence2).length();
                                break;
                            }
                            if (!string.regionMatches(true, n11, string2, 0, string2.length())) break;
                            n12 = n11 + string2.length();
                            d = -d;
                            break;
                        }
                    }
                    Format format2 = this.getFormat(Unit.class);
                    try {
                        Object object2;
                        if (n12 < 0) {
                            parsePosition2.setIndex(i);
                            object2 = format2.parseObject(string, parsePosition2);
                        } else {
                            object2 = format2.parseObject(string.substring(i, n11));
                            parsePosition2.setIndex(n12);
                            string2 = null;
                            charSequence2 = null;
                        }
                        if (object2 == null) {
                            parsePosition2.setIndex(n6);
                            parsePosition2.setErrorIndex(-1);
                        } else {
                            unitConverter = ((Unit)object2).getConverterToAny((Unit<?>)objectArray);
                        }
                        break;
                    }
                    catch (ParseException | IncommensurableException exception) {
                        parsePosition.setIndex(n4);
                        parsePosition.setErrorIndex(i += n3);
                        if (exception instanceof ParseException) {
                            throw (ParseException)exception;
                        }
                        throw (ParseException)new ParseException(exception.getMessage(), i).initCause(exception);
                    }
                }
            } else if (this.toFormatUnit != null && (unitConverter = this.toFormatUnit[n2]) != null) {
                unitConverter = unitConverter.inverse();
            }
            if (charSequence2 != null) {
                n6 = parsePosition2.getIndex();
                if (string.regionMatches(true, n6, (String)charSequence2, 0, ((String)charSequence2).length())) {
                    n6 += ((String)charSequence2).length();
                } else if (string.regionMatches(true, n6, string2, 0, string2.length())) {
                    n6 += string2.length();
                    d = -d;
                }
                parsePosition2.setIndex(n6);
            }
            if (unitConverter != null) {
                d = unitConverter.convert(d);
            }
            if (this.isNegative(n2)) {
                d = -d;
            }
            dArray[n2] = d;
        }
        if (this.accuracyText != null && string.regionMatches(true, n2 = parsePosition2.getIndex(), this.accuracyText, 0, n = this.accuracyText.length())) {
            parsePosition2.setIndex(n2 + n);
        }
        GeneralDirectPosition generalDirectPosition = new GeneralDirectPosition(dArray);
        generalDirectPosition.setCoordinateReferenceSystem(this.defaultCRS);
        return generalDirectPosition;
    }

    private static void unexpectedException(String string, Exception exception) {
        Logging.unexpectedException(Logger.getLogger("org.apache.sis.measure"), CoordinateFormat.class, string, exception);
    }

    @Override
    public CoordinateFormat clone() {
        CoordinateFormat coordinateFormat = (CoordinateFormat)super.clone();
        coordinateFormat.dummy = null;
        coordinateFormat.buffer = null;
        coordinateFormat.createFormats(null);
        if (this.desiredPrecisions != null) {
            coordinateFormat.desiredPrecisions = (double[])this.desiredPrecisions.clone();
        }
        return coordinateFormat;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.parseSeparator = CharSequences.trimWhitespaces(this.separator);
    }

    private static final class Resolution {
        private double magnitude;
        private double resolution;
        private Unit<?> unit;
        final boolean isAngular;

        Resolution(Quantity<?> quantity) {
            this.resolution = Math.abs(quantity.getValue().doubleValue());
            this.unit = quantity.getUnit();
            this.isAngular = Units.isAngular(this.unit);
        }

        private Resolution(Resolution resolution, double d, Unit<Length> unit) throws IncommensurableException {
            boolean bl = this.isAngular = !resolution.isAngular;
            if (this.isAngular) {
                this.resolution = Math.toDegrees(resolution.resolution(unit) / d);
                this.unit = Units.DEGREE;
            } else {
                this.resolution = resolution.resolution(Units.RADIAN) * d;
                this.unit = unit;
            }
        }

        Resolution derived(CoordinateReferenceSystem coordinateReferenceSystem) throws IncommensurableException {
            Unit<Length> unit;
            Ellipsoid ellipsoid;
            double d;
            if ((this.isAngular || Units.isLinear(this.unit)) && (d = Formulas.getAuthalicRadius(ellipsoid = ReferencingUtilities.getEllipsoid(coordinateReferenceSystem))) > 0.0 && (unit = ellipsoid.getAxisUnit()) != null) {
                return new Resolution(this, d, unit);
            }
            return null;
        }

        private double resolution(Unit<?> unit) throws IncommensurableException {
            return Math.abs(this.unit.getConverterToAny(unit).convert(this.resolution));
        }

        boolean findMinResolution(Unit<?> unit, boolean bl) throws IncommensurableException {
            if (!unit.isCompatible(this.unit)) {
                return false;
            }
            double d = this.resolution(unit);
            if (!bl || d < this.resolution) {
                this.resolution = d;
                this.unit = unit;
            }
            return true;
        }

        final void findMaxValue(CoordinateSystemAxis coordinateSystemAxis) {
            double d = Math.max(Math.abs(coordinateSystemAxis.getMinimumValue()), Math.abs(coordinateSystemAxis.getMaximumValue()));
            if (d > this.magnitude) {
                this.magnitude = d;
            }
        }

        void setPrecision(CoordinateFormat coordinateFormat) {
            if (Units.isTemporal(this.unit)) {
                return;
            }
            Format format = coordinateFormat.getFormat(this.isAngular ? org.apache.sis.measure.Angle.class : Number.class);
            if (format instanceof DecimalFormat) {
                if (this.resolution == 0.0) {
                    this.resolution = 1.0E-6;
                }
                int n = Math.max(0, DecimalFunctions.fractionDigitsForDelta(this.resolution, true));
                int n2 = Math.max(0, DecimalFunctions.fractionDigitsForDelta(Math.ulp(this.magnitude), false));
                ((DecimalFormat)format).setMinimumFractionDigits(Math.min(n, n2));
                ((DecimalFormat)format).setMaximumFractionDigits(n);
            } else if (format instanceof AngleFormat) {
                ((AngleFormat)format).setPrecision(this.resolution, true);
            }
        }
    }
}

