/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.DefaultFeatureType;
import org.apache.sis.feature.Features;
import org.apache.sis.feature.builder.AttributeTypeBuilder;
import org.apache.sis.feature.builder.FeatureTypeBuilder;
import org.apache.sis.feature.builder.PropertyTypeBuilder;
import org.apache.sis.filter.AssociationValue;
import org.apache.sis.filter.LeafExpression;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.XPath;
import org.apache.sis.internal.geoapi.filter.Name;
import org.apache.sis.internal.geoapi.filter.ValueReference;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.ObjectConverters;
import org.apache.sis.util.UnconvertibleObjectException;
import org.apache.sis.util.resources.Errors;
import org.opengis.util.ScopedName;

abstract class PropertyValue<V>
extends LeafExpression<AbstractFeature, V>
implements ValueReference<AbstractFeature, V>,
Optimization.OnExpression<AbstractFeature, V> {
    private static final long serialVersionUID = 3756361632664536269L;
    protected final String name;
    protected final boolean isVirtual;
    static final String VIRTUAL_PREFIX = "/*/";

    protected PropertyValue(String string, boolean bl) {
        this.name = string;
        this.isVirtual = bl;
    }

    @Override
    public final ScopedName getFunctionName() {
        return Name.VALUE_REFERENCE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static <V> ValueReference<AbstractFeature, V> create(String string, Class<V> clazz) {
        Object object;
        boolean bl = false;
        List<String> list = XPath.split(string);
        if (list != null) {
            object = list.get(0);
            bl = ((String)object).equals("/*");
            if (!bl && ((String)object).charAt(0) == '/') throw new IllegalArgumentException(Errors.format((short)195, string));
            int n = bl ? 1 : 0;
            int n2 = list.size() - 1;
            if (n2 < n) throw new IllegalArgumentException(Errors.format((short)195, string));
            string = list.get(n2);
            list = list.subList(n, n2);
        }
        object = clazz != Object.class ? new Converted<V>(clazz, string, bl) : new AsObject(string, bl);
        return list == null || list.isEmpty() ? object : new AssociationValue<V>(list, object);
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.isVirtual ? Arrays.asList(this.name, this.isVirtual) : Collections.singleton(this.name);
    }

    @Override
    public final String getXPath() {
        return this.isVirtual ? VIRTUAL_PREFIX.concat(this.name) : this.name;
    }

    protected Class<?> getSourceClass() {
        return Object.class;
    }

    final PropertyTypeBuilder expectedType(FeatureTypeBuilder featureTypeBuilder) {
        return ((AttributeTypeBuilder)featureTypeBuilder.addAttribute(this.getValueClass()).setName((CharSequence)this.name)).setMinimumOccurs(0);
    }

    public final <N> PropertyValue<N> toValueType(Class<N> clazz) {
        if (clazz.equals(this.getValueClass())) {
            return this;
        }
        Class<?> clazz2 = this.getSourceClass();
        if (clazz == Object.class) {
            return new AsObject(this.name, this.isVirtual);
        }
        if (clazz2 == Object.class) {
            return new Converted<N>(clazz, this.name, this.isVirtual);
        }
        return new CastedAndConverted(clazz2, clazz, this.name, this.isVirtual);
    }

    public abstract PropertyValue<V> optimize(Optimization var1);

    @Override
    public PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
        AbstractIdentifiedType abstractIdentifiedType;
        try {
            abstractIdentifiedType = defaultFeatureType.getProperty(this.name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            if (this.isVirtual) {
                return this.expectedType(featureTypeBuilder);
            }
            throw illegalArgumentException;
        }
        while (abstractIdentifiedType instanceof AbstractOperation) {
            AbstractIdentifiedType abstractIdentifiedType2 = ((AbstractOperation)abstractIdentifiedType).getResult();
            if (abstractIdentifiedType2 != abstractIdentifiedType && abstractIdentifiedType2 instanceof AbstractIdentifiedType) {
                abstractIdentifiedType = abstractIdentifiedType2;
                continue;
            }
            if (abstractIdentifiedType2 instanceof DefaultFeatureType) {
                return featureTypeBuilder.addAssociation((DefaultFeatureType)abstractIdentifiedType2).setName((CharSequence)this.name);
            }
            return null;
        }
        return featureTypeBuilder.addProperty(abstractIdentifiedType);
    }

    private static class Converted<V>
    extends PropertyValue<V> {
        private static final long serialVersionUID = -1436865010478207066L;
        protected final Class<V> type;

        protected Converted(Class<V> clazz, String string, boolean bl) {
            super(string, bl);
            this.type = clazz;
        }

        @Override
        public final Class<V> getValueClass() {
            return this.type;
        }

        @Override
        public V apply(AbstractFeature abstractFeature) {
            if (abstractFeature != null) {
                try {
                    return ObjectConverters.convert(abstractFeature.getValueOrFallback(this.name, null), this.type);
                }
                catch (UnconvertibleObjectException unconvertibleObjectException) {
                    this.warning(unconvertibleObjectException, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return null;
        }

        @Override
        public final PropertyValue<V> optimize(Optimization optimization) {
            DefaultFeatureType defaultFeatureType = optimization.getFeatureType();
            if (defaultFeatureType != null) {
                try {
                    String string = this.name;
                    AbstractIdentifiedType abstractIdentifiedType = defaultFeatureType.getProperty(string);
                    Optional<String> optional = Features.getLinkTarget(abstractIdentifiedType);
                    if (optional.isPresent()) {
                        try {
                            string = optional.get();
                            abstractIdentifiedType = defaultFeatureType.getProperty(string);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            this.warning(illegalArgumentException, true);
                            string = this.name;
                        }
                    }
                    Class<Object> clazz = this.getSourceClass();
                    Class<?> clazz2 = clazz;
                    if (abstractIdentifiedType instanceof DefaultAttributeType) {
                        clazz = ((DefaultAttributeType)abstractIdentifiedType).getValueClass();
                    }
                    if (!string.equals(this.name) || !clazz.equals(clazz2)) {
                        if (clazz == Object.class) {
                            return new Converted<V>(this.type, string, this.isVirtual);
                        }
                        return new CastedAndConverted<Object, V>(clazz, this.type, string, this.isVirtual);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return this;
        }

        @Override
        public final PropertyTypeBuilder expectedType(DefaultFeatureType defaultFeatureType, FeatureTypeBuilder featureTypeBuilder) {
            AttributeTypeBuilder attributeTypeBuilder;
            PropertyTypeBuilder propertyTypeBuilder = super.expectedType(defaultFeatureType, featureTypeBuilder);
            if (propertyTypeBuilder instanceof AttributeTypeBuilder && !this.type.isAssignableFrom((attributeTypeBuilder = (AttributeTypeBuilder)propertyTypeBuilder).getValueClass())) {
                return attributeTypeBuilder.setValueClass(this.type);
            }
            return propertyTypeBuilder;
        }
    }

    private static final class AsObject
    extends PropertyValue<Object> {
        private static final long serialVersionUID = 2854731969723006038L;

        AsObject(String string, boolean bl) {
            super(string, bl);
        }

        @Override
        public Object apply(AbstractFeature abstractFeature) {
            return abstractFeature != null ? abstractFeature.getValueOrFallback(this.name, null) : null;
        }

        @Override
        public PropertyValue<Object> optimize(Optimization optimization) {
            DefaultFeatureType defaultFeatureType = optimization.getFeatureType();
            if (defaultFeatureType != null) {
                try {
                    return Features.getLinkTarget(defaultFeatureType.getProperty(this.name)).map(string -> new AsObject((String)string, this.isVirtual)).orElse(this);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return this;
        }
    }

    private static final class CastedAndConverted<S, V>
    extends Converted<V> {
        private static final long serialVersionUID = -58453954752151703L;
        private final Class<S> source;
        private final ObjectConverter<? super S, ? extends V> converter;

        CastedAndConverted(Class<S> clazz, Class<V> clazz2, String string, boolean bl) {
            super(clazz2, string, bl);
            this.source = clazz;
            this.converter = ObjectConverters.find(clazz, clazz2);
        }

        @Override
        protected Class<S> getSourceClass() {
            return this.source;
        }

        @Override
        public V apply(AbstractFeature abstractFeature) {
            if (abstractFeature != null) {
                try {
                    return this.converter.apply(this.source.cast(abstractFeature.getValueOrFallback(this.name, null)));
                }
                catch (ClassCastException | UnconvertibleObjectException runtimeException) {
                    this.warning(runtimeException, false);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.warning(illegalArgumentException, true);
                }
            }
            return null;
        }
    }
}

