/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config;

import com.google.common.eventbus.Subscribe;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;
import java.util.function.LongConsumer;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.config.DynamicProperties;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.springframework.core.env.Environment;

public class DynamicPropertiesImpl
implements DynamicProperties {
    private final Map<String, Set<Holder<Consumer<String>, String>>> stringCallbacks = new ConcurrentHashMap<String, Set<Holder<Consumer<String>, String>>>();
    private final Map<String, Set<Holder<IntConsumer, Integer>>> intCallbacks = new ConcurrentHashMap<String, Set<Holder<IntConsumer, Integer>>>();
    private final Map<String, Set<Holder<LongConsumer, Long>>> longCallbacks = new ConcurrentHashMap<String, Set<Holder<LongConsumer, Long>>>();
    private final Map<String, Set<Holder<DoubleConsumer, Float>>> floatCallbacks = new ConcurrentHashMap<String, Set<Holder<DoubleConsumer, Float>>>();
    private final Map<String, Set<Holder<DoubleConsumer, Double>>> doubleCallbacks = new ConcurrentHashMap<String, Set<Holder<DoubleConsumer, Double>>>();
    private final Map<String, Set<Holder<Consumer<Boolean>, Boolean>>> booleanCallbacks = new ConcurrentHashMap<String, Set<Holder<Consumer<Boolean>, Boolean>>>();
    private final Environment environment;

    public DynamicPropertiesImpl(Environment environment) {
        this.environment = environment;
        EventManager.register((Object)this);
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (Map.Entry<String, Object> entry : event.getAdded().entrySet()) {
            this.updateValue(entry);
        }
        for (Map.Entry<String, Object> entry : event.getUpdated().entrySet()) {
            this.updateValue(entry);
        }
        for (Map.Entry<String, Object> entry : event.getDeleted().entrySet()) {
            this.updateValue(entry);
        }
    }

    private void updateValue(Map.Entry<String, Object> entry) {
        if (this.stringCallbacks.containsKey(entry.getKey())) {
            for (Holder<Consumer<String>, String> holder : this.stringCallbacks.get(entry.getKey())) {
                ((Consumer)holder.callback).accept(this.environment.getProperty(entry.getKey(), (String)holder.defaultValue));
            }
        }
        if (this.intCallbacks.containsKey(entry.getKey())) {
            for (Holder<Object, Object> holder : this.intCallbacks.get(entry.getKey())) {
                ((IntConsumer)holder.callback).accept((Integer)this.environment.getProperty(entry.getKey(), Integer.class, (Object)((Integer)holder.defaultValue)));
            }
        }
        if (this.longCallbacks.containsKey(entry.getKey())) {
            for (Holder<Object, Object> holder : this.longCallbacks.get(entry.getKey())) {
                ((LongConsumer)holder.callback).accept((Long)this.environment.getProperty(entry.getKey(), Long.class, (Object)((Long)holder.defaultValue)));
            }
        }
        if (this.floatCallbacks.containsKey(entry.getKey())) {
            for (Holder<Object, Object> holder : this.floatCallbacks.get(entry.getKey())) {
                ((DoubleConsumer)holder.callback).accept(((Float)this.environment.getProperty(entry.getKey(), Float.class, (Object)((Float)holder.defaultValue))).floatValue());
            }
        }
        if (this.doubleCallbacks.containsKey(entry.getKey())) {
            for (Holder<Object, Object> holder : this.doubleCallbacks.get(entry.getKey())) {
                ((DoubleConsumer)holder.callback).accept((Double)this.environment.getProperty(entry.getKey(), Double.class, (Object)((Double)holder.defaultValue)));
            }
        }
        if (this.booleanCallbacks.containsKey(entry.getKey())) {
            for (Holder<Object, Object> holder : this.booleanCallbacks.get(entry.getKey())) {
                ((Consumer)holder.callback).accept((Boolean)this.environment.getProperty(entry.getKey(), Boolean.class, (Object)((Boolean)holder.defaultValue)));
            }
        }
    }

    @Override
    public String getStringProperty(String propertyName, Consumer<String> consumer, String defaultValue) {
        this.stringCallbacks.computeIfAbsent(propertyName, key -> new HashSet()).add(new Holder<Consumer<String>, String>(consumer, defaultValue));
        return this.environment.getProperty(propertyName, defaultValue);
    }

    @Override
    public String getStringProperty(String propertyName, String defaultValue) {
        return this.environment.getProperty(propertyName, defaultValue);
    }

    @Override
    public int getIntProperty(String propertyName, IntConsumer consumer, int defaultValue) {
        this.intCallbacks.computeIfAbsent(propertyName, key -> new HashSet()).add(new Holder<IntConsumer, Integer>(consumer, defaultValue));
        return (Integer)this.environment.getProperty(propertyName, Integer.TYPE, (Object)defaultValue);
    }

    @Override
    public int getIntProperty(String propertyName, int defaultValue) {
        return (Integer)this.environment.getProperty(propertyName, Integer.TYPE, (Object)defaultValue);
    }

    @Override
    public long getLongProperty(String propertyName, LongConsumer consumer, long defaultValue) {
        this.longCallbacks.computeIfAbsent(propertyName, key -> new HashSet()).add(new Holder<LongConsumer, Long>(consumer, defaultValue));
        return (Long)this.environment.getProperty(propertyName, Long.TYPE, (Object)defaultValue);
    }

    @Override
    public long getLongProperty(String propertyName, long defaultValue) {
        return (Long)this.environment.getProperty(propertyName, Long.TYPE, (Object)defaultValue);
    }

    @Override
    public float getFloatProperty(String propertyName, DoubleConsumer consumer, float defaultValue) {
        this.floatCallbacks.computeIfAbsent(propertyName, key -> new HashSet()).add(new Holder<DoubleConsumer, Float>(consumer, Float.valueOf(defaultValue)));
        return ((Float)this.environment.getProperty(propertyName, Float.TYPE, (Object)Float.valueOf(defaultValue))).floatValue();
    }

    @Override
    public float getFloatProperty(String propertyName, float defaultValue) {
        return ((Float)this.environment.getProperty(propertyName, Float.TYPE, (Object)Float.valueOf(defaultValue))).floatValue();
    }

    @Override
    public double getDoubleProperty(String propertyName, DoubleConsumer consumer, double defaultValue) {
        this.doubleCallbacks.computeIfAbsent(propertyName, key -> new HashSet()).add(new Holder<DoubleConsumer, Double>(consumer, defaultValue));
        return (Double)this.environment.getProperty(propertyName, Double.TYPE, (Object)defaultValue);
    }

    @Override
    public double getDoubleProperty(String propertyName, double defaultValue) {
        return (Double)this.environment.getProperty(propertyName, Double.TYPE, (Object)defaultValue);
    }

    @Override
    public boolean getBooleanProperty(String propertyName, Consumer<Boolean> consumer, boolean defaultValue) {
        this.booleanCallbacks.computeIfAbsent(propertyName, key -> new HashSet()).add(new Holder<Consumer<Boolean>, Boolean>(consumer, defaultValue));
        return (Boolean)this.environment.getProperty(propertyName, Boolean.TYPE, (Object)defaultValue);
    }

    @Override
    public boolean getBooleanProperty(String propertyName, boolean defaultValue) {
        return (Boolean)this.environment.getProperty(propertyName, Boolean.TYPE, (Object)defaultValue);
    }

    private static class Holder<C, D> {
        C callback;
        D defaultValue;

        Holder(C callback, D defaultValue) {
            this.callback = callback;
            this.defaultValue = defaultValue;
        }
    }
}

