/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.authentication.consumer;

import java.util.Optional;
import javax.ws.rs.core.Response;
import org.apache.servicecomb.authentication.consumer.ConsumerTokenManager;
import org.apache.servicecomb.core.Handler;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.swagger.invocation.AsyncResponse;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;

public class ConsumerAuthHandler
implements Handler {
    private ConsumerTokenManager authenticationTokenManager = new ConsumerTokenManager();

    public void handle(Invocation invocation, AsyncResponse asyncResp) throws Exception {
        Optional<String> token = Optional.ofNullable(this.authenticationTokenManager.getToken());
        if (!token.isPresent()) {
            asyncResp.consumerFail((Throwable)new InvocationException((Response.StatusType)Response.Status.SERVICE_UNAVAILABLE, "auth token is not properly configured yet."));
            return;
        }
        invocation.addContext("x-cse-auth-rsatoken", token.get());
        invocation.next(asyncResp);
    }

    public void setAuthenticationTokenManager(ConsumerTokenManager authenticationTokenManager) {
        this.authenticationTokenManager = authenticationTokenManager;
    }
}

