/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.metrics.core.meter.os;

import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.List;
import org.apache.servicecomb.metrics.core.meter.os.cpu.OsCpuUsage;
import org.apache.servicecomb.metrics.core.meter.os.cpu.ProcessCpuUsage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuMeter {
    private static final Logger LOGGER = LoggerFactory.getLogger(CpuMeter.class);
    private OsCpuUsage allCpuUsage;
    private ProcessCpuUsage processCpuUsage;

    public CpuMeter(Id id) {
        this.allCpuUsage = new OsCpuUsage(id.withTag("type", "cpu"));
        this.processCpuUsage = new ProcessCpuUsage(id.withTag("type", "processCpu"));
        this.update();
        this.allCpuUsage.setUsage(0.0);
        this.processCpuUsage.setUsage(0.0);
    }

    public void calcMeasurements(List<Measurement> measurements, long msNow) {
        this.update();
        measurements.add(new Measurement(this.allCpuUsage.getId(), msNow, this.allCpuUsage.getUsage()));
        measurements.add(new Measurement(this.processCpuUsage.getId(), msNow, this.processCpuUsage.getUsage()));
    }

    public void update() {
        try {
            this.allCpuUsage.update();
            this.processCpuUsage.update();
        }
        catch (Throwable e) {
            LOGGER.error("Failed to update usage", e);
        }
    }

    public OsCpuUsage getAllCpuUsage() {
        return this.allCpuUsage;
    }

    public ProcessCpuUsage getProcessCpuUsage() {
        return this.processCpuUsage;
    }
}

