/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.transport.rest.servlet;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.servicecomb.foundation.common.utils.Log4jUtils;
import org.apache.servicecomb.transport.rest.servlet.CseXmlWebApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;

public class RestServletContextListener
implements ServletContextListener {
    private AbstractApplicationContext context;

    public void contextInitialized(ServletContextEvent sce) {
        try {
            this.initLog(sce);
            this.initSpring(sce);
        }
        catch (Exception e) {
            throw new Error(e);
        }
    }

    public void initLog(ServletContextEvent sce) throws Exception {
        String logMerged = sce.getServletContext().getInitParameter("servicecomb.logging.merged");
        if (!Boolean.FALSE.toString().equalsIgnoreCase(logMerged)) {
            Log4jUtils.init();
        }
    }

    public AbstractApplicationContext initSpring(ServletContextEvent sce) {
        this.context = new CseXmlWebApplicationContext(sce.getServletContext());
        this.context.refresh();
        return this.context;
    }

    public void contextDestroyed(ServletContextEvent sce) {
        if (this.context == null) {
            return;
        }
        this.context.close();
        this.context = null;
    }
}

