/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp.internal.traces;

import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler;
import io.opentelemetry.exporter.internal.otlp.traces.SpanReusableDataMarshaler;
import io.opentelemetry.exporter.logging.otlp.internal.traces.OtlpStdoutSpanExporterBuilder;
import io.opentelemetry.exporter.logging.otlp.internal.writer.JsonWriter;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.MemoryMode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpStdoutSpanExporter
implements SpanExporter {
    private static final Logger LOGGER = Logger.getLogger(OtlpStdoutSpanExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final Logger logger;
    private final JsonWriter jsonWriter;
    private final boolean wrapperJsonObject;
    private final MemoryMode memoryMode;
    private final Function<Collection<SpanData>, CompletableResultCode> marshaler;

    OtlpStdoutSpanExporter(Logger logger, JsonWriter jsonWriter, boolean wrapperJsonObject, MemoryMode memoryMode) {
        this.logger = logger;
        this.jsonWriter = jsonWriter;
        this.wrapperJsonObject = wrapperJsonObject;
        this.memoryMode = memoryMode;
        this.marshaler = OtlpStdoutSpanExporter.createMarshaler(jsonWriter, memoryMode, wrapperJsonObject);
    }

    public static OtlpStdoutSpanExporterBuilder builder() {
        return new OtlpStdoutSpanExporterBuilder(LOGGER).setOutput(System.out);
    }

    private static Function<Collection<SpanData>, CompletableResultCode> createMarshaler(JsonWriter jsonWriter, MemoryMode memoryMode, boolean wrapperJsonObject) {
        if (wrapperJsonObject) {
            SpanReusableDataMarshaler reusableDataMarshaler = new SpanReusableDataMarshaler(memoryMode, (marshaler, numItems) -> jsonWriter.write((Marshaler)marshaler));
            return arg_0 -> ((SpanReusableDataMarshaler)reusableDataMarshaler).export(arg_0);
        }
        return spans -> {
            for (ResourceSpansMarshaler marshaler : ResourceSpansMarshaler.create((Collection)spans)) {
                CompletableResultCode resultCode = jsonWriter.write((Marshaler)marshaler);
                if (resultCode.isSuccess()) continue;
                return resultCode;
            }
            return CompletableResultCode.ofSuccess();
        };
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        return this.marshaler.apply(spans);
    }

    public CompletableResultCode flush() {
        return this.jsonWriter.flush();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
        } else {
            this.jsonWriter.close();
        }
        return CompletableResultCode.ofSuccess();
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(", ", "OtlpStdoutSpanExporter{", "}");
        joiner.add("jsonWriter=" + this.jsonWriter);
        joiner.add("wrapperJsonObject=" + this.wrapperJsonObject);
        joiner.add("memoryMode=" + this.memoryMode);
        return joiner.toString();
    }
}

