/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.util.HashMap;
import java.util.Map;
import opennlp.tools.commons.Trainer;
import opennlp.tools.util.TrainingConfiguration;
import opennlp.tools.util.TrainingParameters;

public abstract class AbstractTrainer
implements Trainer {
    protected TrainingParameters trainingParameters;
    protected Map<String, String> reportMap;
    protected TrainingConfiguration trainingConfiguration;

    public AbstractTrainer() {
    }

    public AbstractTrainer(TrainingParameters trainParams) {
        this.init(trainParams, new HashMap<String, String>());
    }

    @Override
    public void init(TrainingParameters trainParams, Map<String, String> reportMap) {
        this.trainingParameters = trainParams;
        if (reportMap == null) {
            reportMap = new HashMap<String, String>();
        }
        this.reportMap = reportMap;
    }

    @Override
    public void init(TrainingParameters trainParams, Map<String, String> reportMap, TrainingConfiguration config) {
        this.init(trainParams, reportMap);
        this.trainingConfiguration = config;
    }

    public String getAlgorithm() {
        return this.trainingParameters.getStringParameter("Algorithm", "MAXENT");
    }

    public int getCutoff() {
        return this.trainingParameters.getIntParameter("Cutoff", 5);
    }

    public int getIterations() {
        return this.trainingParameters.getIntParameter("Iterations", 100);
    }

    public void validate() {
        try {
            this.trainingParameters.getIntParameter("Cutoff", 5);
            this.trainingParameters.getIntParameter("Iterations", 100);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void addToReport(String key, String value) {
        this.reportMap.put(key, value);
    }

    public TrainingConfiguration getTrainingConfiguration() {
        return this.trainingConfiguration;
    }
}

