/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.ad;

import java.nio.charset.Charset;
import opennlp.tools.chunker.ChunkSample;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.params.BasicFormatParams;
import opennlp.tools.commons.Internal;
import opennlp.tools.formats.LanguageSampleStreamFactory;
import opennlp.tools.formats.ad.ADChunkSampleStream;
import opennlp.tools.util.ObjectStream;

@Internal
public class ADChunkSampleStreamFactory
extends LanguageSampleStreamFactory<ChunkSample, Parameters> {
    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(ChunkSample.class, "ad", new ADChunkSampleStreamFactory(Parameters.class));
    }

    protected ADChunkSampleStreamFactory(Class<Parameters> params) {
        super(params);
    }

    @Override
    public ObjectStream<ChunkSample> create(String[] args) {
        Parameters params = this.validateBasicFormatParameters(args, Parameters.class);
        ObjectStream<String> lineStream = this.readData(args, Parameters.class);
        ADChunkSampleStream sampleStream = new ADChunkSampleStream(lineStream);
        if (params.getStart() != null && params.getStart() > -1) {
            sampleStream.setStart(params.getStart());
        }
        if (params.getEnd() != null && params.getEnd() > -1) {
            sampleStream.setEnd(params.getEnd());
        }
        return sampleStream;
    }

    public static interface Parameters
    extends BasicFormatParams {
        @Override
        @ArgumentParser.ParameterDescription(valueName="charsetName", description="encoding for reading and writing text, if absent the system default is used.")
        public Charset getEncoding();

        @ArgumentParser.ParameterDescription(valueName="language", description="language which is being processed.")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="start", description="index of first sentence")
        @ArgumentParser.OptionalParameter
        public Integer getStart();

        @ArgumentParser.ParameterDescription(valueName="end", description="index of last sentence")
        @ArgumentParser.OptionalParameter
        public Integer getEnd();
    }
}

