/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.server.core.deserializer.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.commons.api.Constants;
import org.apache.olingo.commons.api.IConstants;
import org.apache.olingo.commons.api.constants.Constantsv00;
import org.apache.olingo.commons.api.constants.Constantsv01;
import org.apache.olingo.commons.api.data.Annotation;
import org.apache.olingo.commons.api.data.ComplexValue;
import org.apache.olingo.commons.api.data.DeletedEntity;
import org.apache.olingo.commons.api.data.Delta;
import org.apache.olingo.commons.api.data.Entity;
import org.apache.olingo.commons.api.data.EntityCollection;
import org.apache.olingo.commons.api.data.Link;
import org.apache.olingo.commons.api.data.Parameter;
import org.apache.olingo.commons.api.data.Property;
import org.apache.olingo.commons.api.data.ValueType;
import org.apache.olingo.commons.api.edm.EdmAction;
import org.apache.olingo.commons.api.edm.EdmComplexType;
import org.apache.olingo.commons.api.edm.EdmEntityType;
import org.apache.olingo.commons.api.edm.EdmEnumType;
import org.apache.olingo.commons.api.edm.EdmMapping;
import org.apache.olingo.commons.api.edm.EdmNavigationProperty;
import org.apache.olingo.commons.api.edm.EdmParameter;
import org.apache.olingo.commons.api.edm.EdmPrimitiveType;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeException;
import org.apache.olingo.commons.api.edm.EdmPrimitiveTypeKind;
import org.apache.olingo.commons.api.edm.EdmProperty;
import org.apache.olingo.commons.api.edm.EdmStructuredType;
import org.apache.olingo.commons.api.edm.EdmType;
import org.apache.olingo.commons.api.edm.EdmTypeDefinition;
import org.apache.olingo.commons.api.edm.FullQualifiedName;
import org.apache.olingo.commons.api.edm.constants.EdmTypeKind;
import org.apache.olingo.commons.api.edm.geo.Geospatial;
import org.apache.olingo.commons.api.edm.geo.GeospatialCollection;
import org.apache.olingo.commons.api.edm.geo.LineString;
import org.apache.olingo.commons.api.edm.geo.MultiLineString;
import org.apache.olingo.commons.api.edm.geo.MultiPoint;
import org.apache.olingo.commons.api.edm.geo.MultiPolygon;
import org.apache.olingo.commons.api.edm.geo.Point;
import org.apache.olingo.commons.api.edm.geo.Polygon;
import org.apache.olingo.commons.api.edm.geo.SRID;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.deserializer.DeserializerException;
import org.apache.olingo.server.api.deserializer.DeserializerResult;
import org.apache.olingo.server.api.deserializer.ODataDeserializer;
import org.apache.olingo.server.api.serializer.SerializerException;
import org.apache.olingo.server.core.deserializer.DeserializerResultImpl;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilder;
import org.apache.olingo.server.core.deserializer.helper.ExpandTreeBuilderImpl;
import org.apache.olingo.server.core.deserializer.json.ODataJsonInstanceAnnotationDeserializer;
import org.apache.olingo.server.core.serializer.utils.ContentTypeHelper;

public class ODataJsonDeserializer
implements ODataDeserializer {
    private static final Map<String, Class<? extends Geospatial>> jsonNameToGeoDataType;
    private static final String ODATA_ANNOTATION_MARKER = "@";
    private static final String ODATA_CONTROL_INFORMATION_PREFIX = "@odata.";
    private static final String REASON = "reason";
    private static final String ODATA_STREAM_PROPERTY_MEDIA_READ_LINK = "mediaReadLink";
    private static final String ODATA_STREAM_PROPERTY_MEDIA_EDIT_LINK = "mediaEditLink";
    private static final String ODATA_STREAM_PROPERTY_MEDIA_MIME_TYPE = "mediaMimeType";
    private final boolean isIEEE754Compatible;
    private ServiceMetadata serviceMetadata;
    private IConstants constants;
    private ODataJsonInstanceAnnotationDeserializer instanceAnnotDeserializer;

    public ODataJsonDeserializer(ContentType contentType) {
        this(contentType, null, (IConstants)new Constantsv00());
    }

    public ODataJsonDeserializer(ContentType contentType, ServiceMetadata serviceMetadata) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.serviceMetadata = serviceMetadata;
        this.constants = new Constantsv00();
        this.instanceAnnotDeserializer = new ODataJsonInstanceAnnotationDeserializer();
    }

    public ODataJsonDeserializer(ContentType contentType, ServiceMetadata serviceMetadata, IConstants constants) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.serviceMetadata = serviceMetadata;
        this.constants = constants;
        this.instanceAnnotDeserializer = new ODataJsonInstanceAnnotationDeserializer();
    }

    public ODataJsonDeserializer(ContentType contentType, IConstants constants) {
        this.isIEEE754Compatible = ContentTypeHelper.isODataIEEE754Compatible(contentType);
        this.constants = constants;
        this.instanceAnnotDeserializer = new ODataJsonInstanceAnnotationDeserializer();
    }

    public DeserializerResult entityCollection(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            return DeserializerResultImpl.with().entityCollection(this.consumeEntityCollectionNode(edmEntityType, this.parseJsonTree(stream), null)).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private EntityCollection consumeEntityCollectionNode(EdmEntityType edmEntityType, ObjectNode tree, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        EntityCollection entitySet = new EntityCollection();
        JsonNode jsonNode = tree.get("value");
        if (jsonNode == null) {
            throw new DeserializerException("Could not find value array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.VALUE_ARRAY_NOT_PRESENT, new String[0]);
        }
        entitySet.getEntities().addAll(this.consumeEntitySetArray(edmEntityType, jsonNode, expandBuilder));
        tree.remove("value");
        if (tree.isObject()) {
            this.removeAnnotations(tree);
        }
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entitySet;
    }

    private List<Entity> consumeEntitySetArray(EdmEntityType edmEntityType, JsonNode jsonNode, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        if (jsonNode.isArray()) {
            ArrayList<Entity> entities = new ArrayList<Entity>();
            for (JsonNode arrayElement : jsonNode) {
                if (arrayElement.isArray() || arrayElement.isValueNode()) {
                    throw new DeserializerException("Nested Arrays and primitive values are not allowed for an entity value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ENTITY, new String[0]);
                }
                EdmEntityType derivedEdmEntityType = (EdmEntityType)this.getDerivedType((EdmStructuredType)edmEntityType, arrayElement);
                entities.add(this.consumeEntityNode(derivedEdmEntityType, (ObjectNode)arrayElement, expandBuilder));
            }
            return entities;
        }
        throw new DeserializerException("The content of the value tag must be an Array but is not.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.VALUE_TAG_MUST_BE_AN_ARRAY, new String[0]);
    }

    public DeserializerResult entity(InputStream stream, EdmEntityType edmEntityType) throws DeserializerException {
        try {
            ObjectNode tree = this.parseJsonTree(stream);
            ExpandTreeBuilder expandBuilder = ExpandTreeBuilderImpl.create();
            EdmEntityType derivedEdmEntityType = (EdmEntityType)this.getDerivedType((EdmStructuredType)edmEntityType, (JsonNode)tree);
            return DeserializerResultImpl.with().entity(this.consumeEntityNode(derivedEdmEntityType, tree, expandBuilder)).expandOption(expandBuilder.build()).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private Entity consumeEntityNode(EdmEntityType edmEntityType, ObjectNode tree, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        Entity entity = new Entity();
        entity.setType(edmEntityType.getFullQualifiedName().getFullQualifiedNameAsString());
        this.consumeId(tree, entity);
        this.consumeEntityProperties(edmEntityType, tree, entity);
        this.consumeExpandedNavigationProperties(edmEntityType, tree, entity, expandBuilder);
        this.consumeDeltaJsonNodeFields(edmEntityType, tree, entity, expandBuilder);
        this.consumeRemainingJsonNodeFields(edmEntityType, tree, entity);
        this.assertJsonNodeIsEmpty((JsonNode)tree);
        return entity;
    }

    private void consumeDeltaJsonNodeFields(EdmEntityType edmEntityType, ObjectNode node, Entity entity, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        if (this.constants instanceof Constantsv01) {
            List navigationPropertyNames = edmEntityType.getNavigationPropertyNames();
            for (String navigationPropertyName : navigationPropertyNames) {
                String delta = navigationPropertyName + ODATA_ANNOTATION_MARKER + "delta";
                JsonNode jsonNode = node.get(delta);
                EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
                if (jsonNode == null || !jsonNode.isArray() || !edmNavigationProperty.isCollection()) continue;
                this.checkNotNullOrValidNull(jsonNode, edmNavigationProperty);
                Link link = new Link();
                link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
                link.setTitle(navigationPropertyName);
                Delta deltaValue = new Delta();
                for (JsonNode arrayElement : jsonNode) {
                    String removed;
                    if (arrayElement.get(removed = "@removed") != null) {
                        JsonNode reasonNode = arrayElement.get(removed);
                        DeletedEntity deletedEntity = new DeletedEntity();
                        DeletedEntity.Reason reason = null;
                        if (reasonNode.get(REASON) != null) {
                            if (reasonNode.get(REASON).asText().equals(DeletedEntity.Reason.changed.name())) {
                                reason = DeletedEntity.Reason.changed;
                            } else if (reasonNode.get(REASON).asText().equals(DeletedEntity.Reason.deleted.name())) {
                                reason = DeletedEntity.Reason.deleted;
                            }
                        } else {
                            throw new DeserializerException("DeletedEntity reason is null.", (ODataLibraryException.MessageKey)SerializerException.MessageKeys.MISSING_DELTA_PROPERTY, new String[]{"Reason"});
                        }
                        deletedEntity.setReason(reason);
                        try {
                            deletedEntity.setId(new URI(arrayElement.get(this.constants.getId()).asText()));
                        }
                        catch (URISyntaxException e) {
                            throw new DeserializerException("Could not set Id for deleted Entity", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
                        }
                        deltaValue.getDeletedEntities().add(deletedEntity);
                        continue;
                    }
                    Entity inlineEntity = this.consumeEntityNode(edmNavigationProperty.getType(), (ObjectNode)arrayElement, expandBuilder);
                    deltaValue.getEntities().add(inlineEntity);
                }
                link.setInlineEntitySet((EntityCollection)deltaValue);
                entity.getNavigationLinks().add(link);
                node.remove(navigationPropertyName);
            }
        }
    }

    private void consumeId(ObjectNode node, Entity entity) throws DeserializerException {
        if (node.get(this.constants.getId()) != null && this.constants instanceof Constantsv01) {
            try {
                entity.setId(new URI(node.get(this.constants.getId()).textValue()));
                node.remove(this.constants.getId());
            }
            catch (URISyntaxException e) {
                throw new DeserializerException("Could not form Id", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
        }
    }

    public DeserializerResult actionParameters(InputStream stream, EdmAction edmAction) throws DeserializerException {
        Map<String, Parameter> parameters = new HashMap<String, Parameter>();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] inputContent = null;
        try {
            IOUtils.copy((InputStream)stream, (OutputStream)byteArrayOutputStream);
            inputContent = byteArrayOutputStream.toByteArray();
            if (inputContent.length > 0) {
                ByteArrayInputStream inputStream1 = new ByteArrayInputStream(inputContent);
                ObjectNode tree = this.parseJsonTree(inputStream1);
                parameters = this.consumeParameters(edmAction, tree);
                if (tree.isObject()) {
                    this.removeAnnotations(tree);
                }
                this.assertJsonNodeIsEmpty((JsonNode)tree);
            }
            return DeserializerResultImpl.with().actionParameters(parameters).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private ObjectNode parseJsonTree(InputStream stream) throws IOException, DeserializerException {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true);
        objectMapper.configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true);
        JsonParser parser = new JsonFactory((ObjectCodec)objectMapper).createParser(stream);
        JsonNode tree = (JsonNode)parser.getCodec().readTree(parser);
        if (tree == null || !tree.isObject()) {
            throw new DeserializerException("Invalid JSON syntax.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        return (ObjectNode)tree;
    }

    private Map<String, Parameter> consumeParameters(EdmAction edmAction, ObjectNode node) throws DeserializerException {
        List parameterNames = edmAction.getParameterNames();
        if (edmAction.isBound()) {
            parameterNames = parameterNames.subList(1, parameterNames.size());
        }
        LinkedHashMap<String, Parameter> parameters = new LinkedHashMap<String, Parameter>();
        block3: for (String paramName : parameterNames) {
            EdmParameter edmParameter = edmAction.getParameter(paramName);
            switch (edmParameter.getType().getKind()) {
                case PRIMITIVE: 
                case DEFINITION: 
                case ENUM: 
                case COMPLEX: 
                case ENTITY: {
                    Parameter parameter = this.createParameter(node.get(paramName), paramName, edmParameter);
                    parameters.put(paramName, parameter);
                    node.remove(paramName);
                    continue block3;
                }
            }
            throw new DeserializerException("Invalid type kind " + edmParameter.getType().getKind() + " for action parameter: " + paramName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ACTION_PARAMETER_TYPE, new String[]{paramName});
        }
        return parameters;
    }

    private Parameter createParameter(JsonNode node, String paramName, EdmParameter edmParameter) throws DeserializerException {
        Parameter parameter = new Parameter();
        parameter.setName(paramName);
        if (node == null || node.isNull()) {
            if (!edmParameter.isNullable()) {
                throw new DeserializerException("Non-nullable parameter not present or null: " + paramName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{paramName});
            }
            if (edmParameter.isCollection()) {
                throw new DeserializerException("Collection must not be null for parameter: " + paramName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PARAMETER, new String[]{paramName});
            }
            parameter.setValue(ValueType.PRIMITIVE, null);
        } else if (edmParameter.getType().getKind() == EdmTypeKind.ENTITY) {
            if (edmParameter.isCollection()) {
                EntityCollection entityCollection = new EntityCollection();
                entityCollection.getEntities().addAll(this.consumeEntitySetArray((EdmEntityType)edmParameter.getType(), node, null));
                parameter.setValue(ValueType.COLLECTION_ENTITY, (Object)entityCollection);
            } else {
                Entity entity = this.consumeEntityNode((EdmEntityType)edmParameter.getType(), (ObjectNode)node, null);
                parameter.setValue(ValueType.ENTITY, (Object)entity);
            }
        } else {
            Property property = this.consumePropertyNode(edmParameter.getName(), edmParameter.getType(), edmParameter.isCollection(), edmParameter.isNullable(), edmParameter.getMaxLength(), edmParameter.getPrecision(), edmParameter.getScale(), true, edmParameter.getMapping(), node);
            parameter.setValue(property.getValueType(), property.getValue());
            parameter.setType(property.getType());
        }
        return parameter;
    }

    public Parameter parameter(String content, EdmParameter parameter) throws DeserializerException {
        try {
            JsonParser parser = new JsonFactory((ObjectCodec)new ObjectMapper().configure(DeserializationFeature.FAIL_ON_READING_DUP_TREE_KEY, true)).createParser(content);
            JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
            if (node == null) {
                throw new DeserializerException("Invalid JSON syntax.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
            }
            Parameter result = this.createParameter(node, parameter.getName(), parameter);
            if (node.isObject()) {
                this.removeAnnotations((ObjectNode)node);
                this.assertJsonNodeIsEmpty(node);
            }
            return result;
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    private void consumeRemainingJsonNodeFields(EdmEntityType edmEntityType, ObjectNode node, Entity entity) throws DeserializerException {
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator fieldsIterator = node.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains(this.constants.getBind())) {
                Link bindingLink = this.consumeBindingLink((String)field.getKey(), (JsonNode)field.getValue(), edmEntityType);
                entity.getNavigationBindings().add(bindingLink);
                toRemove.add((String)field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX) && ((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER) && ((String)field.getKey()).substring(((String)field.getKey()).indexOf(ODATA_ANNOTATION_MARKER)).contains(".")) {
                String[] keySplit = ((String)field.getKey()).split(ODATA_ANNOTATION_MARKER);
                String termName = keySplit[1];
                Annotation annotation = this.instanceAnnotDeserializer.consumeInstanceAnnotation(termName, (JsonNode)field.getValue());
                if (!keySplit[0].isEmpty()) {
                    if (edmEntityType.getPropertyNames().contains(keySplit[0])) {
                        entity.getProperty(keySplit[0]).getAnnotations().add(annotation);
                    } else if (edmEntityType.getNavigationPropertyNames().contains(keySplit[0])) {
                        Link link = entity.getNavigationLink(keySplit[0]);
                        link.getAnnotations().add(annotation);
                    }
                } else {
                    entity.getAnnotations().add(annotation);
                }
                toRemove.add((String)field.getKey());
                continue;
            }
            if (!this.isStreamPropertyNode((String)field.getKey())) continue;
            this.consumeStreamPropertyNode(entity, edmEntityType, field);
            toRemove.add((String)field.getKey());
        }
        node.remove(toRemove);
        this.removeAnnotations(node);
    }

    private boolean isStreamPropertyNode(String jsonNodeKey) {
        return jsonNodeKey.endsWith(ODATA_STREAM_PROPERTY_MEDIA_READ_LINK) || jsonNodeKey.endsWith(ODATA_STREAM_PROPERTY_MEDIA_EDIT_LINK) || jsonNodeKey.endsWith(ODATA_STREAM_PROPERTY_MEDIA_MIME_TYPE);
    }

    private void consumeStreamPropertyNode(Entity entity, EdmEntityType edmEntityType, Map.Entry<String, JsonNode> field) throws DeserializerException {
        String[] keySplit = field.getKey().split(ODATA_ANNOTATION_MARKER);
        String termName = keySplit[1];
        Annotation annotation = this.instanceAnnotDeserializer.consumeInstanceAnnotation(termName, field.getValue());
        String propertyName = keySplit[0];
        if (edmEntityType.getProperty(propertyName) == null) {
            return;
        }
        Property property = entity.getProperty(propertyName);
        if (property == null) {
            property = new Property();
            property.setName(propertyName);
            entity.addProperty(property);
        }
        property.getAnnotations().add(annotation);
    }

    private void consumeEntityProperties(EdmEntityType edmEntityType, ObjectNode node, Entity entity) throws DeserializerException {
        List propertyNames = edmEntityType.getPropertyNames();
        for (String propertyName : propertyNames) {
            JsonNode jsonNode = node.get(propertyName);
            if (jsonNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(propertyName);
            if (jsonNode.isNull() && !edmProperty.isNullable()) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), jsonNode);
            entity.addProperty(property);
            node.remove(propertyName);
        }
    }

    private void consumeExpandedNavigationProperties(EdmEntityType edmEntityType, ObjectNode node, Entity entity, ExpandTreeBuilder expandBuilder) throws DeserializerException {
        List navigationPropertyNames = edmEntityType.getNavigationPropertyNames();
        for (String navigationPropertyName : navigationPropertyNames) {
            JsonNode jsonNode = node.get(navigationPropertyName);
            if (jsonNode == null) continue;
            EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
            this.checkNotNullOrValidNull(jsonNode, edmNavigationProperty);
            Link link = this.createLink(expandBuilder, navigationPropertyName, jsonNode, edmNavigationProperty);
            entity.getNavigationLinks().add(link);
            node.remove(navigationPropertyName);
        }
    }

    private void checkNotNullOrValidNull(JsonNode jsonNode, EdmNavigationProperty edmNavigationProperty) throws DeserializerException {
        boolean isNullable = edmNavigationProperty.isNullable();
        if (jsonNode.isNull() && !isNullable || jsonNode.isNull() && edmNavigationProperty.isCollection()) {
            throw new DeserializerException("Property: " + edmNavigationProperty.getName() + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{edmNavigationProperty.getName()});
        }
    }

    private Link createLink(ExpandTreeBuilder expandBuilder, String navigationPropertyName, JsonNode jsonNode, EdmNavigationProperty edmNavigationProperty) throws DeserializerException {
        Link link = new Link();
        link.setTitle(navigationPropertyName);
        ExpandTreeBuilder childExpandBuilder = expandBuilder != null ? expandBuilder.expand(edmNavigationProperty) : null;
        EdmEntityType derivedEdmEntityType = (EdmEntityType)this.getDerivedType((EdmStructuredType)edmNavigationProperty.getType(), jsonNode);
        if (jsonNode.isArray() && edmNavigationProperty.isCollection()) {
            link.setType(Constants.ENTITY_SET_NAVIGATION_LINK_TYPE);
            EntityCollection inlineEntitySet = new EntityCollection();
            inlineEntitySet.getEntities().addAll(this.consumeEntitySetArray(derivedEdmEntityType, jsonNode, childExpandBuilder));
            link.setInlineEntitySet(inlineEntitySet);
        } else if (!(jsonNode.isArray() || jsonNode.isValueNode() && !jsonNode.isNull() || edmNavigationProperty.isCollection())) {
            link.setType(Constants.ENTITY_NAVIGATION_LINK_TYPE);
            if (!jsonNode.isNull()) {
                Entity inlineEntity = this.consumeEntityNode(derivedEdmEntityType, (ObjectNode)jsonNode, childExpandBuilder);
                link.setInlineEntity(inlineEntity);
            }
        } else {
            throw new DeserializerException("Invalid value: " + jsonNode.getNodeType() + " for expanded navigation property: " + navigationPropertyName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_NAVIGATION_PROPERTY, new String[]{navigationPropertyName});
        }
        return link;
    }

    private Link consumeBindingLink(String key, JsonNode jsonNode, EdmEntityType edmEntityType) throws DeserializerException {
        String[] splitKey = key.split(ODATA_ANNOTATION_MARKER);
        String navigationPropertyName = splitKey[0];
        EdmNavigationProperty edmNavigationProperty = edmEntityType.getNavigationProperty(navigationPropertyName);
        if (edmNavigationProperty == null) {
            throw new DeserializerException("Invalid navigationPropertyName: " + navigationPropertyName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.NAVIGATION_PROPERTY_NOT_FOUND, new String[]{navigationPropertyName});
        }
        Link bindingLink = new Link();
        bindingLink.setTitle(navigationPropertyName);
        if (edmNavigationProperty.isCollection()) {
            this.assertIsNullNode(key, jsonNode);
            if (!jsonNode.isArray()) {
                throw new DeserializerException("Binding annotation: " + key + " must be an array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            ArrayList<String> bindingLinkStrings = new ArrayList<String>();
            for (JsonNode arrayValue : jsonNode) {
                this.assertIsNullNode(key, arrayValue);
                if (!arrayValue.isTextual()) {
                    throw new DeserializerException("Binding annotation: " + key + " must have string valued array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
                }
                bindingLinkStrings.add(arrayValue.asText());
            }
            bindingLink.setType(Constants.ENTITY_COLLECTION_BINDING_LINK_TYPE);
            bindingLink.setBindingLinks(bindingLinkStrings);
        } else {
            if (!jsonNode.isValueNode()) {
                throw new DeserializerException("Binding annotation: " + key + " must be a string value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_ANNOTATION_TYPE, new String[]{key});
            }
            if (edmNavigationProperty.isNullable() && jsonNode.isNull()) {
                bindingLink.setBindingLink(null);
            } else {
                this.assertIsNullNode(key, jsonNode);
                bindingLink.setBindingLink(jsonNode.asText());
            }
            bindingLink.setType(Constants.ENTITY_BINDING_LINK_TYPE);
        }
        return bindingLink;
    }

    private void assertIsNullNode(String key, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            throw new DeserializerException("Annotation: " + key + "must not have a null value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_ANNOTATION, new String[]{key});
        }
    }

    private Property consumePropertyNode(String name, EdmType type, boolean isCollection, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        Property property = new Property();
        property.setName(name);
        property.setType(type.getFullQualifiedName().getFullQualifiedNameAsString());
        if (isCollection) {
            this.consumePropertyCollectionNode(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode, property);
        } else {
            this.consumePropertySingleNode(name, type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode, property);
        }
        return property;
    }

    private void consumePropertySingleNode(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode, Property property) throws DeserializerException {
        switch (type.getKind()) {
            case PRIMITIVE: 
            case DEFINITION: 
            case ENUM: {
                Object value = this.readPrimitiveValue(name, (EdmPrimitiveType)type, isNullable, maxLength, precision, scale, isUnicode, mapping, jsonNode);
                property.setValue(type.getKind() == EdmTypeKind.ENUM ? ValueType.ENUM : ValueType.PRIMITIVE, value);
                break;
            }
            case COMPLEX: {
                EdmType derivedType = this.getDerivedType((EdmStructuredType)((EdmComplexType)type), jsonNode);
                property.setType(derivedType.getFullQualifiedName().getFullQualifiedNameAsString());
                Object value = this.readComplexNode(name, derivedType, isNullable, jsonNode);
                property.setValue(ValueType.COMPLEX, value);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + type.getKind(), (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
            }
        }
    }

    private Object readComplexNode(String name, EdmType type, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        ComplexValue value = this.readComplexValue(name, type, isNullable, jsonNode);
        if (jsonNode.isObject()) {
            this.removeAnnotations((ObjectNode)jsonNode);
        }
        this.assertJsonNodeIsEmpty(jsonNode);
        return value;
    }

    private void consumePropertyCollectionNode(String name, EdmType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode, Property property) throws DeserializerException {
        ArrayList<Object> valueArray = new ArrayList<Object>();
        Iterator<JsonNode> iterator = !jsonNode.isArray() ? Arrays.asList(jsonNode).iterator() : jsonNode.iterator();
        switch (type.getKind()) {
            case PRIMITIVE: 
            case DEFINITION: 
            case ENUM: {
                while (iterator.hasNext()) {
                    JsonNode arrayElement = iterator.next();
                    Object value = this.readPrimitiveValue(name, (EdmPrimitiveType)type, isNullable, maxLength, precision, scale, isUnicode, mapping, arrayElement);
                    valueArray.add(value);
                }
                property.setValue(type.getKind() == EdmTypeKind.ENUM ? ValueType.COLLECTION_ENUM : ValueType.COLLECTION_PRIMITIVE, valueArray);
                break;
            }
            case COMPLEX: {
                while (iterator.hasNext()) {
                    Object value = this.readComplexNode(name, type, isNullable, iterator.next());
                    valueArray.add(value);
                }
                property.setValue(ValueType.COLLECTION_COMPLEX, valueArray);
                break;
            }
            default: {
                throw new DeserializerException("Invalid Type Kind for a property found: " + type.getKind(), (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
            }
        }
    }

    private ComplexValue readComplexValue(String name, EdmType type, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        if (jsonNode.isArray() || !jsonNode.isContainerNode()) {
            throw new DeserializerException("Invalid value for property: " + name + " must not be an array or primitive value.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
        ComplexValue complexValue = new ComplexValue();
        EdmComplexType edmType = (EdmComplexType)type;
        edmType = (EdmComplexType)this.getDerivedType((EdmStructuredType)edmType, jsonNode);
        for (String propertyName : edmType.getPropertyNames()) {
            JsonNode subNode = jsonNode.get(propertyName);
            if (subNode == null) continue;
            EdmProperty edmProperty = (EdmProperty)edmType.getProperty(propertyName);
            if (subNode.isNull() && !edmProperty.isNullable()) {
                throw new DeserializerException("Property: " + propertyName + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{propertyName});
            }
            Property property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), subNode);
            complexValue.getValue().add(property);
            ((ObjectNode)jsonNode).remove(propertyName);
        }
        complexValue.setTypeName(edmType.getFullQualifiedName().getFullQualifiedNameAsString());
        return complexValue;
    }

    private Object readPrimitiveValue(String name, EdmPrimitiveType type, boolean isNullable, Integer maxLength, Integer precision, Integer scale, boolean isUnicode, EdmMapping mapping, JsonNode jsonNode) throws DeserializerException {
        if (this.isValidNull(name, isNullable, jsonNode)) {
            return null;
        }
        boolean isGeoType = type.getName().startsWith("Geo");
        if (!isGeoType) {
            this.checkForValueNode(name, jsonNode);
        }
        this.checkJsonTypeBasedOnPrimitiveType(name, type, jsonNode);
        try {
            if (isGeoType) {
                return this.readPrimitiveGeoValue(name, type, (ObjectNode)jsonNode);
            }
            return type.valueOfString(jsonNode.asText(), Boolean.valueOf(isNullable), maxLength, precision, scale, Boolean.valueOf(isUnicode), this.getJavaClassForPrimitiveType(mapping, type));
        }
        catch (EdmPrimitiveTypeException e) {
            throw new DeserializerException("Invalid value: " + jsonNode.asText() + " for property: " + name, (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
        }
    }

    private boolean isValidNull(String name, boolean isNullable, JsonNode jsonNode) throws DeserializerException {
        if (jsonNode.isNull()) {
            if (isNullable) {
                return true;
            }
            throw new DeserializerException("Property: " + name + " must not be null.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_NULL_PROPERTY, new String[]{name});
        }
        return false;
    }

    private Geospatial readPrimitiveGeoValue(String name, EdmPrimitiveType type, ObjectNode jsonNode) throws DeserializerException, EdmPrimitiveTypeException {
        Class<? extends Geospatial> geoDataType;
        JsonNode typeNode = jsonNode.remove("type");
        if (typeNode != null && typeNode.isTextual() && (geoDataType = jsonNameToGeoDataType.get(typeNode.asText())) != null && (type == null || geoDataType.equals(type.getDefaultType()))) {
            JsonNode topNode = jsonNode.remove(geoDataType.equals(GeospatialCollection.class) ? "geometries" : "coordinates");
            SRID srid = null;
            if (jsonNode.has("crs")) {
                srid = SRID.valueOf((String)jsonNode.remove("crs").get("properties").get("name").asText().split(":")[1]);
            }
            this.assertJsonNodeIsEmpty((JsonNode)jsonNode);
            if (topNode != null && topNode.isArray()) {
                Geospatial.Dimension dimension;
                Geospatial.Dimension dimension2 = dimension = type == null || type.getName().startsWith("Geometry") ? Geospatial.Dimension.GEOMETRY : Geospatial.Dimension.GEOGRAPHY;
                if (geoDataType.equals(Point.class)) {
                    return this.readGeoPointValue(name, dimension, topNode, srid);
                }
                if (geoDataType.equals(MultiPoint.class)) {
                    return new MultiPoint(dimension, srid, this.readGeoPointValues(name, dimension, 0, false, topNode));
                }
                if (geoDataType.equals(LineString.class)) {
                    return new LineString(dimension, srid, this.readGeoPointValues(name, dimension, 0, false, topNode));
                }
                if (geoDataType.equals(MultiLineString.class)) {
                    ArrayList<LineString> lines = new ArrayList<LineString>();
                    for (JsonNode element : topNode) {
                        lines.add(new LineString(dimension, srid, this.readGeoPointValues(name, dimension, 0, false, element)));
                    }
                    return new MultiLineString(dimension, srid, lines);
                }
                if (geoDataType.equals(Polygon.class)) {
                    return this.readGeoPolygon(name, dimension, topNode, srid);
                }
                if (geoDataType.equals(MultiPolygon.class)) {
                    ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                    for (JsonNode element : topNode) {
                        polygons.add(this.readGeoPolygon(name, dimension, element, null));
                    }
                    return new MultiPolygon(dimension, srid, polygons);
                }
                if (geoDataType.equals(GeospatialCollection.class)) {
                    ArrayList<Geospatial> elements = new ArrayList<Geospatial>();
                    for (JsonNode element : topNode) {
                        if (element.isObject()) {
                            elements.add(this.readPrimitiveGeoValue(name, null, (ObjectNode)element));
                            continue;
                        }
                        throw new DeserializerException("Invalid value '" + element + "' in property: " + name, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
                    }
                    return new GeospatialCollection(dimension, srid, elements);
                }
            }
        }
        throw new DeserializerException("Invalid value '" + jsonNode + "' for property: " + name, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
    }

    private Point readGeoPointValue(String name, Geospatial.Dimension dimension, JsonNode node, SRID srid) throws DeserializerException, EdmPrimitiveTypeException {
        if (node.isArray() && (node.size() == 2 || node.size() == 3) && node.get(0).isNumber() && node.get(1).isNumber() && (node.get(2) == null || node.get(2).isNumber())) {
            Point point = new Point(dimension, srid);
            point.setX(this.getDoubleValue(node.get(0).asText()));
            point.setY(this.getDoubleValue(node.get(1).asText()));
            if (node.get(2) != null) {
                point.setZ(this.getDoubleValue(node.get(2).asText()));
            }
            return point;
        }
        throw new DeserializerException("Invalid point value '" + node + "' in property: " + name, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
    }

    private double getDoubleValue(String value) throws EdmPrimitiveTypeException {
        BigDecimal bigDecimalValue = new BigDecimal(value);
        Double result = bigDecimalValue.doubleValue();
        if (result.isInfinite() || BigDecimal.valueOf(result).compareTo(bigDecimalValue) != 0) {
            throw new EdmPrimitiveTypeException("The literal '" + value + "' has illegal content.");
        }
        return result;
    }

    private List<Point> readGeoPointValues(String name, Geospatial.Dimension dimension, int minimalSize, boolean closed, JsonNode node) throws DeserializerException, EdmPrimitiveTypeException {
        if (node.isArray()) {
            ArrayList<Point> points = new ArrayList<Point>();
            for (JsonNode element : node) {
                points.add(this.readGeoPointValue(name, dimension, element, null));
            }
            if (points.size() >= minimalSize && (!closed || ((Point)points.get(points.size() - 1)).equals(points.get(0)))) {
                return points;
            }
        }
        throw new DeserializerException("Invalid point values '" + node + "' in property: " + name, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
    }

    private Polygon readGeoPolygon(String name, Geospatial.Dimension dimension, JsonNode node, SRID srid) throws DeserializerException, EdmPrimitiveTypeException {
        if (node.isArray() && node.size() >= 1) {
            ArrayList<LineString> interiors = new ArrayList<LineString>();
            for (int i = 1; i < node.size(); ++i) {
                interiors.add(new LineString(dimension, srid, this.readGeoPointValues(name, dimension, 4, true, node.get(i))));
            }
            return new Polygon(dimension, srid, interiors, new LineString(dimension, srid, this.readGeoPointValues(name, dimension, 4, true, node.get(0))));
        }
        throw new DeserializerException("Invalid polygon values '" + node + "' in property: " + name, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{name});
    }

    private Class<?> getJavaClassForPrimitiveType(EdmMapping mapping, EdmPrimitiveType type) {
        EdmPrimitiveType edmPrimitiveType = type.getKind() == EdmTypeKind.ENUM ? ((EdmEnumType)type).getUnderlyingType() : (type.getKind() == EdmTypeKind.DEFINITION ? ((EdmTypeDefinition)type).getUnderlyingType() : type);
        return mapping == null || mapping.getMappedJavaClass() == null ? edmPrimitiveType.getDefaultType() : mapping.getMappedJavaClass();
    }

    private void checkForValueNode(String name, JsonNode jsonNode) throws DeserializerException {
        if (!jsonNode.isValueNode()) {
            throw new DeserializerException("Invalid value for property: " + name + " must not be an object or array.", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_JSON_TYPE_FOR_PROPERTY, new String[]{name});
        }
    }

    private void removeAnnotations(ObjectNode tree) throws DeserializerException {
        ArrayList<String> toRemove = new ArrayList<String>();
        Iterator fieldsIterator = tree.fields();
        while (fieldsIterator.hasNext()) {
            Map.Entry field = (Map.Entry)fieldsIterator.next();
            if (((String)field.getKey()).contains(ODATA_CONTROL_INFORMATION_PREFIX)) {
                toRemove.add((String)field.getKey());
                continue;
            }
            if (!((String)field.getKey()).contains(ODATA_ANNOTATION_MARKER)) continue;
            if (this.constants instanceof Constantsv01) {
                toRemove.add((String)field.getKey());
                continue;
            }
            throw new DeserializerException("Custom annotation with field name: " + (String)field.getKey() + " not supported", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.NOT_IMPLEMENTED, new String[0]);
        }
        tree.remove(toRemove);
    }

    private void assertJsonNodeIsEmpty(JsonNode node) throws DeserializerException {
        if (node.size() != 0) {
            String unknownField = (String)node.fieldNames().next();
            throw new DeserializerException("Tree should be empty but still has content left: " + unknownField, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[]{unknownField});
        }
    }

    private void checkJsonTypeBasedOnPrimitiveType(String propertyName, EdmPrimitiveType edmPrimitiveType, JsonNode jsonNode) throws DeserializerException {
        boolean valid = true;
        if (edmPrimitiveType.getKind() == EdmTypeKind.DEFINITION) {
            this.checkJsonTypeBasedOnPrimitiveType(propertyName, ((EdmTypeDefinition)edmPrimitiveType).getUnderlyingType(), jsonNode);
        } else if (edmPrimitiveType.getKind() == EdmTypeKind.ENUM) {
            valid = jsonNode.isTextual();
        } else {
            EdmPrimitiveTypeKind primKind;
            String name = edmPrimitiveType.getName();
            try {
                primKind = EdmPrimitiveTypeKind.valueOf((String)name);
            }
            catch (IllegalArgumentException e) {
                throw new DeserializerException("Unknown Primitive Type: " + name, (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_PRIMITIVE_TYPE, new String[]{name, propertyName});
            }
            boolean bl = valid = this.matchTextualCase(jsonNode, primKind) || this.matchNumberCase(jsonNode, primKind) || this.matchBooleanCase(jsonNode, primKind) || this.matchIEEENumberCase(jsonNode, primKind) || jsonNode.isObject() && name.startsWith("Geo");
        }
        if (!valid) {
            throw new DeserializerException("Invalid json type: " + jsonNode.getNodeType() + " for " + edmPrimitiveType + " property: " + propertyName, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.INVALID_VALUE_FOR_PROPERTY, new String[]{propertyName});
        }
    }

    private boolean matchIEEENumberCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return (this.isIEEE754Compatible ? node.isTextual() : node.isNumber()) && (primKind == EdmPrimitiveTypeKind.Int64 || primKind == EdmPrimitiveTypeKind.Decimal);
    }

    private boolean matchBooleanCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return node.isBoolean() && primKind == EdmPrimitiveTypeKind.Boolean;
    }

    private boolean matchNumberCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return node.isNumber() && (primKind == EdmPrimitiveTypeKind.Int16 || primKind == EdmPrimitiveTypeKind.Int32 || primKind == EdmPrimitiveTypeKind.Byte || primKind == EdmPrimitiveTypeKind.SByte || primKind == EdmPrimitiveTypeKind.Single || primKind == EdmPrimitiveTypeKind.Double);
    }

    private boolean matchTextualCase(JsonNode node, EdmPrimitiveTypeKind primKind) {
        return node.isTextual() && (primKind == EdmPrimitiveTypeKind.String || primKind == EdmPrimitiveTypeKind.Binary || primKind == EdmPrimitiveTypeKind.Date || primKind == EdmPrimitiveTypeKind.DateTimeOffset || primKind == EdmPrimitiveTypeKind.Duration || primKind == EdmPrimitiveTypeKind.Guid || primKind == EdmPrimitiveTypeKind.TimeOfDay);
    }

    public DeserializerResult property(InputStream stream, EdmProperty edmProperty) throws DeserializerException {
        try {
            Property property;
            ObjectNode tree = this.parseJsonTree(stream);
            JsonNode jsonNode = tree.get("value");
            if (jsonNode != null) {
                property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), jsonNode);
                tree.remove("value");
            } else {
                property = this.consumePropertyNode(edmProperty.getName(), edmProperty.getType(), edmProperty.isCollection(), edmProperty.isNullable(), edmProperty.getMaxLength(), edmProperty.getPrecision(), edmProperty.getScale(), edmProperty.isUnicode(), edmProperty.getMapping(), (JsonNode)tree);
            }
            return DeserializerResultImpl.with().property(property).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
    }

    public DeserializerResult entityReferences(InputStream stream) throws DeserializerException {
        try {
            ArrayList<URI> parsedValues = new ArrayList<URI>();
            ObjectNode tree = this.parseJsonTree(stream);
            String key = this.constants.getId();
            JsonNode jsonNode = tree.get("value");
            if (jsonNode != null) {
                if (jsonNode.isArray()) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode;
                    for (JsonNode next : arrayNode) {
                        if (!next.has(key)) continue;
                        parsedValues.add(new URI(next.get(key).asText()));
                    }
                } else {
                    throw new DeserializerException("Value must be an array", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
                }
                tree.remove("value");
                return DeserializerResultImpl.with().entityReferences(parsedValues).build();
            }
            if (tree.get(key) == null) {
                throw new DeserializerException("Missing entity reference", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            parsedValues.add(new URI(tree.get(key).asText()));
            return DeserializerResultImpl.with().entityReferences(parsedValues).build();
        }
        catch (IOException e) {
            throw this.wrapParseException(e);
        }
        catch (URISyntaxException e) {
            throw new DeserializerException("failed to read @odata.id", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
        }
    }

    private DeserializerException wrapParseException(IOException e) {
        if (e instanceof JsonParseException) {
            return new DeserializerException("A JsonParseException occurred.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.JSON_SYNTAX_EXCEPTION, new String[0]);
        }
        if (e instanceof JsonMappingException) {
            return new DeserializerException("Duplicate json property detected.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.DUPLICATE_PROPERTY, new String[0]);
        }
        return new DeserializerException("An IOException occurred.", (Throwable)e, (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.IO_EXCEPTION, new String[0]);
    }

    private EdmType getDerivedType(EdmStructuredType edmType, JsonNode jsonNode) throws DeserializerException {
        String odataType;
        JsonNode odataTypeNode = jsonNode.get(this.constants.getType());
        if (odataTypeNode != null && !(odataType = odataTypeNode.asText()).isEmpty()) {
            EdmEntityType currentEdmType;
            if ((odataType = odataType.substring(1)).equalsIgnoreCase(edmType.getFullQualifiedName().getFullQualifiedNameAsString())) {
                return edmType;
            }
            if (this.serviceMetadata == null) {
                throw new DeserializerException("Failed to resolve Odata type " + odataType + " due to metadata is not available", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            Object object = currentEdmType = edmType.getKind() == EdmTypeKind.ENTITY ? this.serviceMetadata.getEdm().getEntityType(new FullQualifiedName(odataType)) : this.serviceMetadata.getEdm().getComplexType(new FullQualifiedName(odataType));
            if (!this.isAssignable(edmType, (EdmStructuredType)currentEdmType)) {
                throw new DeserializerException("Odata type " + odataType + " not allowed here", (ODataLibraryException.MessageKey)DeserializerException.MessageKeys.UNKNOWN_CONTENT, new String[0]);
            }
            return currentEdmType;
        }
        return edmType;
    }

    private boolean isAssignable(EdmStructuredType edmStructuredType, EdmStructuredType edmStructuredTypeToAssign) {
        return edmStructuredTypeToAssign != null && (edmStructuredType.getFullQualifiedName().equals((Object)edmStructuredTypeToAssign.getFullQualifiedName()) || this.isAssignable(edmStructuredType, edmStructuredTypeToAssign.getBaseType()));
    }

    static {
        HashMap<String, Class<GeospatialCollection>> temp = new HashMap<String, Class<GeospatialCollection>>();
        temp.put("Point", Point.class);
        temp.put("MultiPoint", MultiPoint.class);
        temp.put("LineString", LineString.class);
        temp.put("MultiLineString", MultiLineString.class);
        temp.put("Polygon", Polygon.class);
        temp.put("MultiPolygon", MultiPolygon.class);
        temp.put("GeometryCollection", GeospatialCollection.class);
        jsonNameToGeoDataType = Collections.unmodifiableMap(temp);
    }
}

