/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.client.core.edm.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import org.apache.olingo.client.core.edm.xml.AbstractClientCsdlEdmDeserializer;
import org.apache.olingo.client.core.edm.xml.ClientCsdlAnnotation;
import org.apache.olingo.client.core.edm.xml.ClientCsdlNavigationPropertyBinding;
import org.apache.olingo.commons.api.edm.provider.CsdlSingleton;

@JsonDeserialize(using=SingletonDeserializer.class)
class ClientCsdlSingleton
extends CsdlSingleton
implements Serializable {
    private static final long serialVersionUID = 1656749615107151921L;

    ClientCsdlSingleton() {
    }

    static class SingletonDeserializer
    extends AbstractClientCsdlEdmDeserializer<ClientCsdlSingleton> {
        SingletonDeserializer() {
        }

        @Override
        protected ClientCsdlSingleton doDeserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            ClientCsdlSingleton singleton = new ClientCsdlSingleton();
            while (jp.getCurrentToken() != JsonToken.END_OBJECT) {
                JsonToken token = jp.getCurrentToken();
                if (token == JsonToken.FIELD_NAME) {
                    if ("Name".equals(jp.getCurrentName())) {
                        singleton.setName(jp.nextTextValue());
                    } else if ("Type".equals(jp.getCurrentName())) {
                        singleton.setType(jp.nextTextValue());
                    } else if ("NavigationPropertyBinding".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        singleton.getNavigationPropertyBindings().add(jp.readValueAs(ClientCsdlNavigationPropertyBinding.class));
                    } else if ("Annotation".equals(jp.getCurrentName())) {
                        jp.nextToken();
                        singleton.getAnnotations().add(jp.readValueAs(ClientCsdlAnnotation.class));
                    }
                }
                jp.nextToken();
            }
            return singleton;
        }
    }
}

