/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.uri;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmEntityContainer;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFacets;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmLiteralException;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmParameter;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeFacade;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.exception.MessageReference;
import org.apache.olingo.odata2.api.exception.ODataBadRequestException;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.exception.ODataMessageException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationPropertySegment;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.api.uri.SelectItem;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.UriNotMatchingException;
import org.apache.olingo.odata2.api.uri.UriParser;
import org.apache.olingo.odata2.api.uri.UriSyntaxException;
import org.apache.olingo.odata2.api.uri.expression.ExpressionParserException;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.core.ODataPathSegmentImpl;
import org.apache.olingo.odata2.core.commons.Decoder;
import org.apache.olingo.odata2.core.edm.EdmSimpleTypeFacadeImpl;
import org.apache.olingo.odata2.core.exception.ODataRuntimeException;
import org.apache.olingo.odata2.core.uri.ExpandSelectTreeCreator;
import org.apache.olingo.odata2.core.uri.KeyPredicateImpl;
import org.apache.olingo.odata2.core.uri.NavigationPropertySegmentImpl;
import org.apache.olingo.odata2.core.uri.NavigationSegmentImpl;
import org.apache.olingo.odata2.core.uri.SelectItemImpl;
import org.apache.olingo.odata2.core.uri.SystemQueryOption;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.core.uri.UriType;
import org.apache.olingo.odata2.core.uri.expression.FilterParserImpl;
import org.apache.olingo.odata2.core.uri.expression.OrderByParserImpl;

public class UriParserImpl
extends UriParser {
    private static final Pattern INITIAL_SEGMENT_PATTERN = Pattern.compile("(?:([^.()]+)\\.)?([^.()]+)(?:\\((.+)\\)|(\\(\\)))?");
    private static final Pattern NAVIGATION_SEGMENT_PATTERN = Pattern.compile("([^()]+)(?:\\((.+)\\)|(\\(\\)))?");
    private static final Pattern NAMED_VALUE_PATTERN = Pattern.compile("(?:([^=]+)=)?([^=]+)");
    private static final char COMMA = ',';
    private static final char SQUOTE = '\'';
    private static final String ACCEPT_FORM_ENCODING = "odata-accept-forms-encoding";
    private final Edm edm;
    private final EdmSimpleTypeFacade simpleTypeFacade;
    private List<String> pathSegments;
    private String currentPathSegment;
    private UriInfoImpl uriResult;
    private Map<SystemQueryOption, String> systemQueryOptions;
    private Map<String, String> otherQueryParameters;
    private String originalFilterString = "";
    private boolean strictFilter = true;

    public UriParserImpl(Edm edm) {
        this.edm = edm;
        this.simpleTypeFacade = new EdmSimpleTypeFacadeImpl();
    }

    public UriInfo parse(List<PathSegment> pathSegments, Map<String, String> queryParameters) throws UriSyntaxException, UriNotMatchingException, EdmException {
        return this.parseAll(pathSegments, this.convertFromSingleMapToMultiMap(queryParameters));
    }

    public UriInfo parse(List<PathSegment> pathSegments, Map<String, String> queryParameters, boolean strictFilter) throws UriSyntaxException, UriNotMatchingException, EdmException {
        this.strictFilter = strictFilter;
        return this.parseAll(pathSegments, this.convertFromSingleMapToMultiMap(queryParameters));
    }

    public UriInfo parseAll(List<PathSegment> pathSegments, Map<String, List<String>> allQueryParameters) throws UriSyntaxException, UriNotMatchingException, EdmException {
        this.pathSegments = UriParserImpl.copyPathSegmentList(pathSegments);
        this.systemQueryOptions = new HashMap<SystemQueryOption, String>();
        this.otherQueryParameters = new HashMap<String, String>();
        this.uriResult = new UriInfoImpl();
        this.preparePathSegments();
        this.handleResourcePath();
        this.distributeQueryParameters(allQueryParameters);
        this.checkSystemQueryOptionsCompatibility();
        this.handleSystemQueryOptions();
        this.handleOtherQueryParameters();
        return this.uriResult;
    }

    private <T, K> Map<T, List<K>> convertFromSingleMapToMultiMap(Map<T, K> singleMap) {
        HashMap multiMap = new HashMap();
        for (Map.Entry<T, K> entry : singleMap.entrySet()) {
            LinkedList<K> valueList = new LinkedList<K>();
            valueList.add(entry.getValue());
            multiMap.put(entry.getKey(), valueList);
        }
        return multiMap;
    }

    private void preparePathSegments() throws UriSyntaxException {
        if (!this.pathSegments.isEmpty() && "".equals(this.pathSegments.get(0))) {
            this.pathSegments.remove(0);
        }
        if (!this.pathSegments.isEmpty() && "".equals(this.pathSegments.get(this.pathSegments.size() - 1))) {
            this.pathSegments.remove(this.pathSegments.size() - 1);
        }
        for (String pathSegment : this.pathSegments) {
            if (!"".equals(pathSegment)) continue;
            throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
        }
    }

    private void handleResourcePath() throws UriSyntaxException, UriNotMatchingException, EdmException {
        if (this.pathSegments.isEmpty()) {
            this.uriResult.setUriType(UriType.URI0);
        } else {
            this.currentPathSegment = this.pathSegments.remove(0);
            String decodedPath = UriParserImpl.percentDecode(this.currentPathSegment);
            if ("$metadata".equals(decodedPath)) {
                this.ensureLastSegment();
                this.uriResult.setUriType(UriType.URI8);
            } else if ("$batch".equals(decodedPath)) {
                this.ensureLastSegment();
                this.uriResult.setUriType(UriType.URI9);
            } else {
                this.handleNormalInitialSegment();
            }
        }
    }

    private void handleNormalInitialSegment() throws UriSyntaxException, UriNotMatchingException, EdmException {
        EdmEntityContainer entityContainer;
        Matcher matcher = INITIAL_SEGMENT_PATTERN.matcher(this.currentPathSegment);
        if (!matcher.matches()) {
            throw new UriNotMatchingException(UriNotMatchingException.MATCHPROBLEM.addContent(new Object[]{this.currentPathSegment}));
        }
        String entityContainerName = UriParserImpl.percentDecode(matcher.group(1));
        String segmentName = UriParserImpl.percentDecode(matcher.group(2));
        String keyPredicate = matcher.group(3);
        String emptyParentheses = matcher.group(4);
        EdmEntityContainer edmEntityContainer = entityContainer = entityContainerName == null ? this.edm.getDefaultEntityContainer() : this.edm.getEntityContainer(entityContainerName);
        if (entityContainer == null) {
            throw new UriNotMatchingException(UriNotMatchingException.CONTAINERNOTFOUND.addContent(new Object[]{entityContainerName}));
        }
        this.uriResult.setEntityContainer(entityContainer);
        EdmEntitySet entitySet = entityContainer.getEntitySet(segmentName);
        if (entitySet != null) {
            this.uriResult.setStartEntitySet(entitySet);
            this.handleEntitySet(entitySet, keyPredicate);
        } else {
            EdmFunctionImport functionImport = entityContainer.getFunctionImport(segmentName);
            if (functionImport == null) {
                throw new UriNotMatchingException(UriNotMatchingException.NOTFOUND.addContent(new Object[]{segmentName}));
            }
            this.uriResult.setFunctionImport(functionImport);
            this.handleFunctionImport(functionImport, emptyParentheses, keyPredicate);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleFunctionImportCollection(EdmEntitySet entitySet, String keyPredicate) throws UriSyntaxException, UriNotMatchingException, EdmException {
        EdmEntityType entityType = entitySet.getEntityType();
        this.uriResult.setTargetType((EdmType)entityType);
        this.uriResult.setTargetEntitySet(entitySet);
        if (keyPredicate == null) {
            if (this.pathSegments.isEmpty()) {
                this.uriResult.setUriType(UriType.URI10a);
                return;
            } else {
                this.currentPathSegment = this.pathSegments.remove(0);
                this.checkCount();
                if (!this.uriResult.isCount()) throw new UriSyntaxException(UriSyntaxException.ENTITYSETINSTEADOFENTITY.addContent(new Object[]{entitySet.getName()}));
                this.uriResult.setUriType(UriType.URI15);
            }
            return;
        } else {
            this.uriResult.setKeyPredicates(this.parseKey(keyPredicate, entityType));
            if (this.pathSegments.isEmpty()) {
                this.uriResult.setUriType(UriType.URI2);
                return;
            } else {
                this.handleNavigationPathOptions();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleEntitySet(EdmEntitySet entitySet, String keyPredicate) throws UriSyntaxException, UriNotMatchingException, EdmException {
        EdmEntityType entityType = entitySet.getEntityType();
        this.uriResult.setTargetType((EdmType)entityType);
        this.uriResult.setTargetEntitySet(entitySet);
        if (keyPredicate == null) {
            if (this.pathSegments.isEmpty()) {
                this.uriResult.setUriType(UriType.URI1);
                return;
            } else {
                this.currentPathSegment = this.pathSegments.remove(0);
                this.checkCount();
                if (!this.uriResult.isCount()) throw new UriSyntaxException(UriSyntaxException.ENTITYSETINSTEADOFENTITY.addContent(new Object[]{entitySet.getName()}));
                this.uriResult.setUriType(UriType.URI15);
            }
            return;
        } else {
            this.uriResult.setKeyPredicates(this.parseKey(keyPredicate, entityType));
            if (this.pathSegments.isEmpty()) {
                this.uriResult.setUriType(UriType.URI2);
                return;
            } else {
                this.handleNavigationPathOptions();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleNavigationPathOptions() throws UriSyntaxException, UriNotMatchingException, EdmException {
        this.currentPathSegment = this.pathSegments.remove(0);
        String decodedPath = UriParserImpl.percentDecode(this.currentPathSegment);
        this.checkCount();
        if (this.uriResult.isCount()) {
            this.uriResult.setUriType(UriType.URI16);
            return;
        } else if ("$value".equals(decodedPath)) {
            if (!this.uriResult.getTargetEntitySet().getEntityType().hasStream()) throw new UriSyntaxException(UriSyntaxException.NOMEDIARESOURCE);
            this.ensureLastSegment();
            this.uriResult.setUriType(UriType.URI17);
            this.uriResult.setValue(true);
            return;
        } else if ("$links".equals(decodedPath)) {
            this.uriResult.setLinks(true);
            if (this.pathSegments.isEmpty()) {
                throw new UriSyntaxException(UriSyntaxException.MUSTNOTBELASTSEGMENT.addContent(new Object[]{this.currentPathSegment}));
            }
            this.currentPathSegment = this.pathSegments.remove(0);
            this.handleNavigationProperties();
            return;
        } else {
            this.handleNavigationProperties();
        }
    }

    private void handleNavigationProperties() throws UriSyntaxException, UriNotMatchingException, EdmException {
        Matcher matcher = NAVIGATION_SEGMENT_PATTERN.matcher(this.currentPathSegment);
        if (!matcher.matches()) {
            throw new UriNotMatchingException(UriNotMatchingException.MATCHPROBLEM.addContent(new Object[]{this.currentPathSegment}));
        }
        String navigationPropertyName = UriParserImpl.percentDecode(matcher.group(1));
        String keyPredicateName = matcher.group(2);
        String emptyParentheses = matcher.group(3);
        EdmTyped property = this.uriResult.getTargetEntitySet().getEntityType().getProperty(navigationPropertyName);
        if (property == null) {
            throw new UriNotMatchingException(UriNotMatchingException.PROPERTYNOTFOUND.addContent(new Object[]{navigationPropertyName}));
        }
        switch (property.getType().getKind()) {
            case SIMPLE: 
            case COMPLEX: {
                if (keyPredicateName != null || emptyParentheses != null) {
                    throw new UriSyntaxException(UriSyntaxException.INVALIDSEGMENT.addContent(new Object[]{this.currentPathSegment}));
                }
                if (this.uriResult.isLinks()) {
                    throw new UriSyntaxException(UriSyntaxException.NONAVIGATIONPROPERTY.addContent(new Object[]{property}));
                }
                this.handlePropertyPath((EdmProperty)property);
                break;
            }
            case ENTITY: {
                EdmNavigationProperty navigationProperty = (EdmNavigationProperty)property;
                if ((keyPredicateName != null || emptyParentheses != null) && navigationProperty.getMultiplicity() != EdmMultiplicity.MANY) {
                    throw new UriSyntaxException(UriSyntaxException.INVALIDSEGMENT.addContent(new Object[]{this.currentPathSegment}));
                }
                this.addNavigationSegment(keyPredicateName, navigationProperty);
                boolean many = false;
                if (navigationProperty.getMultiplicity() == EdmMultiplicity.MANY) {
                    boolean bl = many = keyPredicateName == null;
                }
                if (this.pathSegments.isEmpty()) {
                    if (many) {
                        if (this.uriResult.isLinks()) {
                            this.uriResult.setUriType(UriType.URI7B);
                            break;
                        }
                        this.uriResult.setUriType(UriType.URI6B);
                        break;
                    }
                    if (this.uriResult.isLinks()) {
                        this.uriResult.setUriType(UriType.URI7A);
                        break;
                    }
                    this.uriResult.setUriType(UriType.URI6A);
                    break;
                }
                if (many || this.uriResult.isLinks()) {
                    this.currentPathSegment = this.pathSegments.remove(0);
                    this.checkCount();
                    if (!this.uriResult.isCount()) {
                        throw new UriSyntaxException(UriSyntaxException.INVALIDSEGMENT.addContent(new Object[]{this.currentPathSegment}));
                    }
                    if (many) {
                        if (this.uriResult.isLinks()) {
                            this.uriResult.setUriType(UriType.URI50B);
                            break;
                        }
                        this.uriResult.setUriType(UriType.URI15);
                        break;
                    }
                    this.uriResult.setUriType(UriType.URI50A);
                    break;
                }
                this.handleNavigationPathOptions();
                break;
            }
            default: {
                throw new UriSyntaxException(UriSyntaxException.INVALIDPROPERTYTYPE.addContent(new Object[]{property.getType().getKind()}));
            }
        }
    }

    private void addNavigationSegment(String keyPredicateName, EdmNavigationProperty navigationProperty) throws UriSyntaxException, EdmException {
        EdmEntitySet targetEntitySet = this.uriResult.getTargetEntitySet().getRelatedEntitySet(navigationProperty);
        EdmEntityType targetEntityType = targetEntitySet.getEntityType();
        this.uriResult.setTargetEntitySet(targetEntitySet);
        this.uriResult.setTargetType((EdmType)targetEntityType);
        NavigationSegmentImpl navigationSegment = new NavigationSegmentImpl();
        navigationSegment.setEntitySet(targetEntitySet);
        navigationSegment.setNavigationProperty(navigationProperty);
        if (keyPredicateName != null) {
            navigationSegment.setKeyPredicates(this.parseKey(keyPredicateName, targetEntityType));
        }
        this.uriResult.addNavigationSegment(navigationSegment);
    }

    private void handlePropertyPath(EdmProperty property) throws UriSyntaxException, UriNotMatchingException, EdmException {
        this.uriResult.addProperty(property);
        EdmType type = property.getType();
        if (this.pathSegments.isEmpty()) {
            if (type.getKind() == EdmTypeKind.SIMPLE) {
                if (this.uriResult.getPropertyPath().size() == 1) {
                    this.uriResult.setUriType(UriType.URI5);
                } else {
                    this.uriResult.setUriType(UriType.URI4);
                }
            } else if (type.getKind() == EdmTypeKind.COMPLEX) {
                this.uriResult.setUriType(UriType.URI3);
            } else {
                throw new UriSyntaxException(UriSyntaxException.INVALIDPROPERTYTYPE.addContent(new Object[]{type.getKind()}));
            }
            this.uriResult.setTargetType(type);
        } else {
            this.currentPathSegment = UriParserImpl.percentDecode(this.pathSegments.remove(0));
            switch (type.getKind()) {
                case SIMPLE: {
                    if ("$value".equals(UriParserImpl.percentDecode(this.currentPathSegment))) {
                        this.ensureLastSegment();
                        this.uriResult.setValue(true);
                        if (this.uriResult.getPropertyPath().size() == 1) {
                            this.uriResult.setUriType(UriType.URI5);
                        } else {
                            this.uriResult.setUriType(UriType.URI4);
                        }
                    } else {
                        throw new UriSyntaxException(UriSyntaxException.INVALIDSEGMENT.addContent(new Object[]{this.currentPathSegment}));
                    }
                    this.uriResult.setTargetType(type);
                    break;
                }
                case COMPLEX: {
                    EdmProperty nextProperty = (EdmProperty)((EdmComplexType)type).getProperty(this.currentPathSegment);
                    if (nextProperty == null) {
                        throw new UriNotMatchingException(UriNotMatchingException.PROPERTYNOTFOUND.addContent(new Object[]{this.currentPathSegment}));
                    }
                    this.handlePropertyPath(nextProperty);
                    break;
                }
                default: {
                    throw new UriSyntaxException(UriSyntaxException.INVALIDPROPERTYTYPE.addContent(new Object[]{type.getKind()}));
                }
            }
        }
    }

    private void ensureLastSegment() throws UriSyntaxException {
        if (!this.pathSegments.isEmpty()) {
            throw new UriSyntaxException(UriSyntaxException.MUSTBELASTSEGMENT.addContent(new Object[]{this.currentPathSegment}));
        }
    }

    private void checkCount() throws UriSyntaxException {
        if ("$count".equals(UriParserImpl.percentDecode(this.currentPathSegment))) {
            if (this.pathSegments.isEmpty()) {
                this.uriResult.setCount(true);
            } else {
                throw new UriSyntaxException(UriSyntaxException.MUSTBELASTSEGMENT.addContent(new Object[]{this.currentPathSegment}));
            }
        }
    }

    private ArrayList<KeyPredicate> parseKey(String keyPredicate, EdmEntityType entityType) throws UriSyntaxException, EdmException {
        List keyProperties = entityType.getKeyProperties();
        ArrayList<EdmProperty> parsedKeyProperties = new ArrayList<EdmProperty>();
        ArrayList<KeyPredicate> keyPredicates = new ArrayList<KeyPredicate>();
        List<String> keys = this.splitKeyPredicate(keyPredicate);
        for (String key : keys) {
            Matcher matcher = NAMED_VALUE_PATTERN.matcher(key);
            if (!matcher.matches()) {
                throw new UriSyntaxException(UriSyntaxException.INVALIDKEYPREDICATE.addContent(new Object[]{keyPredicate}));
            }
            String name = UriParserImpl.percentDecode(matcher.group(1));
            String value = UriParserImpl.percentDecode(matcher.group(2));
            if (name == null) {
                if (keyProperties.size() == 1) {
                    name = ((EdmProperty)keyProperties.get(0)).getName();
                } else {
                    throw new UriSyntaxException(UriSyntaxException.MISSINGKEYPREDICATENAME.addContent(new Object[]{key}));
                }
            }
            EdmProperty keyProperty = null;
            for (EdmProperty testKeyProperty : keyProperties) {
                if (!testKeyProperty.getName().equals(name)) continue;
                keyProperty = testKeyProperty;
                break;
            }
            if (keyProperty == null) {
                throw new UriSyntaxException(UriSyntaxException.INVALIDKEYPREDICATE.addContent(new Object[]{keyPredicate}));
            }
            if (parsedKeyProperties.contains(keyProperty)) {
                throw new UriSyntaxException(UriSyntaxException.DUPLICATEKEYNAMES.addContent(new Object[]{keyPredicate}));
            }
            parsedKeyProperties.add(keyProperty);
            EdmLiteral uriLiteral = this.parseLiteral(value, (EdmSimpleType)keyProperty.getType());
            keyPredicates.add(new KeyPredicateImpl(uriLiteral.getLiteral(), keyProperty));
        }
        if (parsedKeyProperties.size() != keyProperties.size()) {
            throw new UriSyntaxException(UriSyntaxException.INVALIDKEYPREDICATE.addContent(new Object[]{keyPredicate}));
        }
        return keyPredicates;
    }

    private List<String> splitKeyPredicate(String keyPredicate) {
        StringBuilder b = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        boolean inStringKeyValue = false;
        for (int i = 0; i < keyPredicate.length(); ++i) {
            char curChar = keyPredicate.charAt(i);
            if ('\'' == curChar) {
                inStringKeyValue = !inStringKeyValue;
                b.append(curChar);
                continue;
            }
            if (',' == curChar && !inStringKeyValue) {
                keys.add(b.toString());
                b = new StringBuilder();
                continue;
            }
            b.append(curChar);
        }
        keys.add(b.toString());
        return keys;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleFunctionImport(EdmFunctionImport functionImport, String emptyParentheses, String keyPredicate) throws UriSyntaxException, UriNotMatchingException, EdmException {
        EdmTyped returnType = functionImport.getReturnType();
        if (returnType != null && returnType.getType() != null) {
            boolean isCollection;
            EdmType type = returnType.getType();
            boolean bl = isCollection = returnType.getMultiplicity() == EdmMultiplicity.MANY;
            if (type.getKind() == EdmTypeKind.ENTITY && isCollection) {
                this.handleFunctionImportCollection(functionImport.getEntitySet(), keyPredicate);
                return;
            }
            if (emptyParentheses != null) {
                throw new UriSyntaxException(UriSyntaxException.INVALIDSEGMENT.addContent(new Object[]{emptyParentheses}));
            }
            this.uriResult.setTargetType(type);
            switch (type.getKind()) {
                case SIMPLE: {
                    this.uriResult.setUriType(isCollection ? UriType.URI13 : UriType.URI14);
                    break;
                }
                case COMPLEX: {
                    this.uriResult.setUriType(isCollection ? UriType.URI11 : UriType.URI12);
                    break;
                }
                case ENTITY: {
                    this.uriResult.setUriType(UriType.URI10);
                    break;
                }
                default: {
                    throw new UriSyntaxException(UriSyntaxException.INVALIDRETURNTYPE.addContent(new Object[]{type.getKind()}));
                }
            }
            if (!this.pathSegments.isEmpty() && this.uriResult.getUriType() == UriType.URI14) {
                this.currentPathSegment = this.pathSegments.remove(0);
                if (!"$value".equals(UriParserImpl.percentDecode(this.currentPathSegment))) throw new UriSyntaxException(UriSyntaxException.INVALIDSEGMENT.addContent(new Object[]{this.currentPathSegment}));
                this.uriResult.setValue(true);
            }
        } else {
            this.uriResult.setUriType(UriType.URI14);
        }
        this.ensureLastSegment();
    }

    private void distributeQueryParameters(Map<String, List<String>> queryParameters) throws UriSyntaxException {
        boolean formEncoding = false;
        if (queryParameters.containsKey(ACCEPT_FORM_ENCODING)) {
            formEncoding = Boolean.parseBoolean(queryParameters.get(ACCEPT_FORM_ENCODING).get(0));
            queryParameters.remove(ACCEPT_FORM_ENCODING);
        }
        for (String queryOptionString : queryParameters.keySet()) {
            String decodedString = UriParserImpl.percentDecode(queryOptionString);
            List<String> valueList = queryParameters.get(queryOptionString);
            if (valueList.size() >= 1) {
                String value = valueList.get(0);
                if (formEncoding) {
                    if (decodedString.equalsIgnoreCase(SystemQueryOption.$filter.toString())) {
                        this.originalFilterString = value;
                    }
                    value = this.getFormEncodedValue(value);
                }
                if (decodedString.startsWith("$")) {
                    SystemQueryOption queryOption;
                    try {
                        queryOption = SystemQueryOption.valueOf(decodedString);
                    }
                    catch (IllegalArgumentException e) {
                        throw new UriSyntaxException(UriSyntaxException.INVALIDSYSTEMQUERYOPTION.addContent(new Object[]{queryOptionString}), (Throwable)e);
                    }
                    if ("".equals(value)) {
                        throw new UriSyntaxException(UriSyntaxException.INVALIDNULLVALUE.addContent(new Object[]{queryOptionString}));
                    }
                    if (valueList.size() == 1 && !this.systemQueryOptions.containsKey((Object)queryOption)) {
                        this.systemQueryOptions.put(queryOption, value);
                        continue;
                    }
                    throw new UriSyntaxException(UriSyntaxException.DUPLICATESYSTEMQUERYPARAMETES.addContent(new Object[]{queryOptionString}));
                }
                this.otherQueryParameters.put(decodedString, value);
                continue;
            }
            throw new UriSyntaxException(UriSyntaxException.INVALIDNULLVALUE.addContent(new Object[]{queryOptionString}));
        }
    }

    private String getFormEncodedValue(String value) {
        if (value.contains("+")) {
            value = value.replaceAll("\\+", " ");
        }
        return value;
    }

    private void checkSystemQueryOptionsCompatibility() throws UriSyntaxException {
        UriType uriType = this.uriResult.getUriType();
        for (SystemQueryOption queryOption : this.systemQueryOptions.keySet()) {
            if (queryOption == SystemQueryOption.$format && (uriType == UriType.URI4 || uriType == UriType.URI5) && this.uriResult.isValue()) {
                throw new UriSyntaxException(UriSyntaxException.INCOMPATIBLESYSTEMQUERYOPTION.addContent(new Object[]{queryOption}));
            }
            if (uriType.isCompatible(queryOption)) continue;
            throw new UriSyntaxException(UriSyntaxException.INCOMPATIBLESYSTEMQUERYOPTION.addContent(new Object[]{queryOption}));
        }
    }

    private void handleSystemQueryOptions() throws UriSyntaxException, UriNotMatchingException, EdmException {
        block11: for (SystemQueryOption queryOption : this.systemQueryOptions.keySet()) {
            switch (queryOption) {
                case $format: {
                    this.handleSystemQueryOptionFormat(this.systemQueryOptions.get((Object)SystemQueryOption.$format));
                    continue block11;
                }
                case $filter: {
                    this.handleSystemQueryOptionFilter(this.systemQueryOptions.get((Object)SystemQueryOption.$filter));
                    continue block11;
                }
                case $inlinecount: {
                    this.handleSystemQueryOptionInlineCount(this.systemQueryOptions.get((Object)SystemQueryOption.$inlinecount));
                    continue block11;
                }
                case $orderby: {
                    this.handleSystemQueryOptionOrderBy(this.systemQueryOptions.get((Object)SystemQueryOption.$orderby));
                    continue block11;
                }
                case $skiptoken: {
                    this.handleSystemQueryOptionSkipToken(this.systemQueryOptions.get((Object)SystemQueryOption.$skiptoken));
                    continue block11;
                }
                case $skip: {
                    this.handleSystemQueryOptionSkip(this.systemQueryOptions.get((Object)SystemQueryOption.$skip));
                    continue block11;
                }
                case $top: {
                    this.handleSystemQueryOptionTop(this.systemQueryOptions.get((Object)SystemQueryOption.$top));
                    continue block11;
                }
                case $expand: {
                    this.handleSystemQueryOptionExpand(this.systemQueryOptions.get((Object)SystemQueryOption.$expand));
                    continue block11;
                }
                case $select: {
                    this.handleSystemQueryOptionSelect(this.systemQueryOptions.get((Object)SystemQueryOption.$select));
                    continue block11;
                }
            }
            throw new ODataRuntimeException("Invalid System Query Option " + (Object)((Object)queryOption));
        }
    }

    private void handleSystemQueryOptionFormat(String format) throws UriSyntaxException {
        this.uriResult.setFormat(format);
    }

    private void handleSystemQueryOptionFilter(String filter) throws UriSyntaxException {
        EdmType targetType = this.uriResult.getTargetType();
        if (targetType instanceof EdmEntityType) {
            try {
                this.uriResult.setFilter(new FilterParserImpl((EdmEntityType)targetType, this.strictFilter, this.originalFilterString).parseFilterString(filter, true));
            }
            catch (ExpressionParserException e) {
                throw new UriSyntaxException(UriSyntaxException.INVALIDFILTEREXPRESSION.addContent(new Object[]{filter}), (Throwable)e);
            }
            catch (ODataMessageException e) {
                throw new UriSyntaxException(UriSyntaxException.INVALIDFILTEREXPRESSION.addContent(new Object[]{filter}), (Throwable)e);
            }
        }
    }

    private void handleSystemQueryOptionOrderBy(String orderBy) throws UriSyntaxException {
        EdmType targetType = this.uriResult.getTargetType();
        if (targetType instanceof EdmEntityType) {
            try {
                this.uriResult.setOrderBy(this.parseOrderByString((EdmEntityType)targetType, orderBy));
            }
            catch (ExpressionParserException e) {
                throw new UriSyntaxException(UriSyntaxException.INVALIDORDERBYEXPRESSION.addContent(new Object[]{orderBy}), (Throwable)e);
            }
            catch (ODataMessageException e) {
                throw new UriSyntaxException(UriSyntaxException.INVALIDORDERBYEXPRESSION.addContent(new Object[]{orderBy}), (Throwable)e);
            }
        }
    }

    private void handleSystemQueryOptionInlineCount(String inlineCount) throws UriSyntaxException {
        if ("allpages".equals(inlineCount)) {
            this.uriResult.setInlineCount(InlineCount.ALLPAGES);
        } else if ("none".equals(inlineCount)) {
            this.uriResult.setInlineCount(InlineCount.NONE);
        } else {
            throw new UriSyntaxException(UriSyntaxException.INVALIDVALUE.addContent(new Object[]{inlineCount}));
        }
    }

    private void handleSystemQueryOptionSkipToken(String skiptoken) throws UriSyntaxException {
        this.uriResult.setSkipToken(skiptoken);
    }

    private void handleSystemQueryOptionSkip(String skip) throws UriSyntaxException {
        try {
            this.uriResult.setSkip(Integer.valueOf(skip));
        }
        catch (NumberFormatException e) {
            throw new UriSyntaxException(UriSyntaxException.INVALIDVALUE.addContent(new Object[]{skip}), (Throwable)e);
        }
        if (skip.startsWith("-")) {
            throw new UriSyntaxException(UriSyntaxException.INVALIDNEGATIVEVALUE.addContent(new Object[]{skip}));
        }
        if (skip.startsWith("+")) {
            throw new UriSyntaxException(UriSyntaxException.INVALIDVALUE.addContent(new Object[]{skip}));
        }
    }

    private void handleSystemQueryOptionTop(String top) throws UriSyntaxException {
        try {
            this.uriResult.setTop(Integer.valueOf(top));
        }
        catch (NumberFormatException e) {
            throw new UriSyntaxException(UriSyntaxException.INVALIDVALUE.addContent(new Object[]{top}), (Throwable)e);
        }
        if (top.startsWith("-")) {
            throw new UriSyntaxException(UriSyntaxException.INVALIDNEGATIVEVALUE.addContent(new Object[]{top}));
        }
        if (top.startsWith("+")) {
            throw new UriSyntaxException(UriSyntaxException.INVALIDVALUE.addContent(new Object[]{top}));
        }
    }

    private void handleSystemQueryOptionExpand(String expandStatement) throws UriSyntaxException, UriNotMatchingException, EdmException {
        ArrayList<ArrayList<NavigationPropertySegment>> expand = new ArrayList<ArrayList<NavigationPropertySegment>>();
        if (expandStatement.startsWith(",") || expandStatement.endsWith(",")) {
            throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
        }
        for (String expandItemString : expandStatement.split(",")) {
            if ("".equals(expandItemString = expandItemString.trim())) {
                throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
            }
            if (expandItemString.startsWith("/") || expandItemString.endsWith("/")) {
                throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
            }
            ArrayList<NavigationPropertySegmentImpl> expandNavigationProperties = new ArrayList<NavigationPropertySegmentImpl>();
            EdmEntitySet fromEntitySet = this.uriResult.getTargetEntitySet();
            for (String expandPropertyName : expandItemString.split("/")) {
                if ("".equals(expandPropertyName)) {
                    throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
                }
                EdmTyped property = fromEntitySet.getEntityType().getProperty(expandPropertyName);
                if (property == null) {
                    throw new UriNotMatchingException(UriNotMatchingException.PROPERTYNOTFOUND.addContent(new Object[]{expandPropertyName}));
                }
                if (property.getType().getKind() != EdmTypeKind.ENTITY) {
                    throw new UriSyntaxException(UriSyntaxException.NONAVIGATIONPROPERTY.addContent(new Object[]{expandPropertyName}));
                }
                EdmNavigationProperty navigationProperty = (EdmNavigationProperty)property;
                fromEntitySet = fromEntitySet.getRelatedEntitySet(navigationProperty);
                NavigationPropertySegmentImpl propertySegment = new NavigationPropertySegmentImpl();
                propertySegment.setNavigationProperty(navigationProperty);
                propertySegment.setTargetEntitySet(fromEntitySet);
                expandNavigationProperties.add(propertySegment);
            }
            expand.add(expandNavigationProperties);
        }
        this.uriResult.setExpand(expand);
    }

    private void handleSystemQueryOptionSelect(String selectStatement) throws UriSyntaxException, UriNotMatchingException, EdmException {
        ArrayList<SelectItem> select = new ArrayList<SelectItem>();
        if (selectStatement.startsWith(",") || selectStatement.endsWith(",")) {
            throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
        }
        for (String selectItemString : selectStatement.split(",")) {
            if ("".equals(selectItemString = selectItemString.trim())) {
                throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
            }
            if (selectItemString.startsWith("/") || selectItemString.endsWith("/")) {
                throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
            }
            SelectItemImpl selectItem = new SelectItemImpl();
            boolean exit = false;
            EdmEntitySet fromEntitySet = this.uriResult.getTargetEntitySet();
            block5: for (String selectedPropertyName : selectItemString.split("/")) {
                if ("".equals(selectedPropertyName)) {
                    throw new UriSyntaxException(UriSyntaxException.EMPTYSEGMENT);
                }
                if (exit) {
                    throw new UriSyntaxException(UriSyntaxException.INVALIDSEGMENT.addContent(new Object[]{selectItemString}));
                }
                if ("*".equals(selectedPropertyName)) {
                    selectItem.setStar(true);
                    exit = true;
                    continue;
                }
                EdmTyped property = fromEntitySet.getEntityType().getProperty(selectedPropertyName);
                if (property == null) {
                    throw new UriNotMatchingException(UriNotMatchingException.PROPERTYNOTFOUND.addContent(new Object[]{selectedPropertyName}));
                }
                switch (property.getType().getKind()) {
                    case SIMPLE: 
                    case COMPLEX: {
                        selectItem.setProperty((EdmProperty)property);
                        exit = true;
                        continue block5;
                    }
                    case ENTITY: {
                        EdmNavigationProperty navigationProperty = (EdmNavigationProperty)property;
                        EdmEntitySet targetEntitySet = fromEntitySet.getRelatedEntitySet(navigationProperty);
                        NavigationPropertySegmentImpl navigationPropertySegment = new NavigationPropertySegmentImpl();
                        navigationPropertySegment.setNavigationProperty(navigationProperty);
                        navigationPropertySegment.setTargetEntitySet(targetEntitySet);
                        selectItem.addNavigationPropertySegment(navigationPropertySegment);
                        fromEntitySet = targetEntitySet;
                        continue block5;
                    }
                    default: {
                        throw new UriSyntaxException(UriSyntaxException.INVALIDPROPERTYTYPE);
                    }
                }
            }
            select.add(selectItem);
        }
        this.uriResult.setSelect(select);
    }

    private void handleOtherQueryParameters() throws UriSyntaxException, EdmException {
        EdmFunctionImport functionImport = this.uriResult.getFunctionImport();
        if (functionImport != null) {
            for (String parameterName : functionImport.getParameterNames()) {
                EdmParameter parameter = functionImport.getParameter(parameterName);
                String value = this.otherQueryParameters.remove(parameterName);
                if (value == null) {
                    if (parameter.getFacets() == null || parameter.getFacets().isNullable() == null || parameter.getFacets().isNullable().booleanValue()) continue;
                    throw new UriSyntaxException(UriSyntaxException.MISSINGPARAMETER);
                }
                EdmLiteral uriLiteral = this.parseLiteral(value, (EdmSimpleType)parameter.getType(), parameter.getFacets());
                this.uriResult.addFunctionImportParameter(parameterName, uriLiteral);
            }
        }
        this.uriResult.setCustomQueryOptions(this.otherQueryParameters);
    }

    private EdmLiteral parseLiteral(String value, EdmSimpleType expectedType, EdmFacets facets) throws UriSyntaxException {
        EdmLiteral literal;
        try {
            literal = this.simpleTypeFacade.parseUriLiteral(value, facets);
        }
        catch (EdmLiteralException e) {
            throw UriParserImpl.convertEdmLiteralException(e);
        }
        if (expectedType.isCompatible(literal.getType())) {
            return literal;
        }
        throw new UriSyntaxException(UriSyntaxException.INCOMPATIBLELITERAL.addContent(new Object[]{value, expectedType}));
    }

    private EdmLiteral parseLiteral(String value, EdmSimpleType expectedType) throws UriSyntaxException {
        EdmLiteral literal;
        try {
            literal = this.simpleTypeFacade.parseUriLiteral(value);
        }
        catch (EdmLiteralException e) {
            throw UriParserImpl.convertEdmLiteralException(e);
        }
        if (expectedType.isCompatible(literal.getType())) {
            return literal;
        }
        throw new UriSyntaxException(UriSyntaxException.INCOMPATIBLELITERAL.addContent(new Object[]{value, expectedType}));
    }

    private static UriSyntaxException convertEdmLiteralException(EdmLiteralException e) {
        MessageReference messageReference = e.getMessageReference();
        if (EdmLiteralException.LITERALFORMAT.equals((Object)messageReference)) {
            return new UriSyntaxException(UriSyntaxException.LITERALFORMAT.addContent(new Object[]{messageReference.getContent()}), (Throwable)e);
        }
        if (EdmLiteralException.NOTEXT.equals((Object)messageReference)) {
            return new UriSyntaxException(UriSyntaxException.NOTEXT.addContent(new Object[]{messageReference.getContent()}), (Throwable)e);
        }
        if (EdmLiteralException.UNKNOWNLITERAL.equals((Object)messageReference)) {
            return new UriSyntaxException(UriSyntaxException.UNKNOWNLITERAL.addContent(new Object[]{messageReference.getContent()}), (Throwable)e);
        }
        return new UriSyntaxException(ODataBadRequestException.COMMON, (Throwable)e);
    }

    private static List<String> copyPathSegmentList(List<PathSegment> source) {
        ArrayList<String> copy = new ArrayList<String>();
        for (PathSegment segment : source) {
            copy.add(segment.getPath());
        }
        return copy;
    }

    private static String percentDecode(String value) throws UriSyntaxException {
        try {
            return Decoder.decode(value);
        }
        catch (RuntimeException e) {
            throw new UriSyntaxException(UriSyntaxException.URISYNTAX, (Throwable)e);
        }
    }

    public FilterExpression parseFilterString(EdmEntityType entityType, String expression) throws ODataMessageException {
        return new FilterParserImpl(entityType, this.strictFilter).parseFilterString(expression);
    }

    public OrderByExpression parseOrderByString(EdmEntityType entityType, String expression) throws ODataMessageException {
        return new OrderByParserImpl(entityType).parseOrderByString(expression);
    }

    public ExpandSelectTreeNode buildExpandSelectTree(List<SelectItem> select, List<ArrayList<NavigationPropertySegment>> expand) throws EdmException {
        return new ExpandSelectTreeCreator(select, expand).create();
    }

    protected PathSegment buildPathSegment(String path, Map<String, List<String>> matrixParameters) {
        return new ODataPathSegmentImpl(path, matrixParameters);
    }

    public List<KeyPredicate> getKeyFromEntityLink(EdmEntitySet entitySet, String entityLink, URI serviceRoot) throws ODataException {
        String relativeLink = serviceRoot == null ? entityLink : (entityLink.startsWith(serviceRoot.toString()) ? entityLink.substring(serviceRoot.toString().length()) : entityLink);
        Matcher matcher = INITIAL_SEGMENT_PATTERN.matcher(relativeLink);
        if (!matcher.matches()) {
            throw new UriNotMatchingException(UriNotMatchingException.MATCHPROBLEM.addContent(new Object[]{relativeLink}));
        }
        String entityContainerName = UriParserImpl.percentDecode(matcher.group(1));
        if (entityContainerName == null && !entitySet.getEntityContainer().isDefaultEntityContainer() || entityContainerName != null && !entityContainerName.equals(entitySet.getEntityContainer().getName())) {
            throw new UriNotMatchingException(UriNotMatchingException.CONTAINERNOTFOUND.addContent(new Object[]{entityContainerName}));
        }
        String entitySetName = UriParserImpl.percentDecode(matcher.group(2));
        if (!entitySetName.equals(entitySet.getName())) {
            throw new UriNotMatchingException(UriNotMatchingException.NOTFOUND.addContent(new Object[]{entitySetName}));
        }
        String keyPredicate = matcher.group(3);
        if (keyPredicate == null) {
            throw new UriSyntaxException(UriSyntaxException.ENTITYSETINSTEADOFENTITY.addContent(new Object[]{entitySetName}));
        }
        return this.parseKey(keyPredicate, entitySet.getEntityType());
    }
}

