/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.cli.impl.command.session;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.toolkit.cli.api.CommandException;
import org.apache.nifi.toolkit.cli.api.SessionException;
import org.apache.nifi.toolkit.cli.impl.command.AbstractCommand;
import org.apache.nifi.toolkit.cli.impl.result.VoidResult;

public class RemoveVariable
extends AbstractCommand<VoidResult> {
    public RemoveVariable() {
        super("remove", VoidResult.class);
    }

    @Override
    public String getDescription() {
        return "Removes the given variable from the session.";
    }

    @Override
    public VoidResult execute(CommandLine commandLine) throws CommandException {
        String[] args = commandLine.getArgs();
        if (args == null || args.length != 1 || StringUtils.isBlank((CharSequence)args[0])) {
            throw new CommandException("Incorrect number of arguments, should be: <var>");
        }
        try {
            this.getContext().getSession().remove(args[0]);
            return VoidResult.getInstance();
        }
        catch (SessionException se) {
            throw new CommandException(se.getMessage(), se);
        }
    }
}

