/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import { ComponentFixture, TestBed } from '@angular/core/testing';

import { ProvenanceEventListing } from './provenance-event-listing.component';
import { provideMockStore } from '@ngrx/store/testing';
import { initialState } from '../../state/provenance-event-listing/provenance-event-listing.reducer';
import { provenanceEventListingFeatureKey } from '../../state/provenance-event-listing';
import { provenanceFeatureKey } from '../../state';
import { initialState as initialErrorState } from '../../../../state/error/error.reducer';
import { errorFeatureKey } from '../../../../state/error';
import { initialState as initialLineageState } from '../../state/lineage/lineage.reducer';
import { lineageFeatureKey } from '../../state/lineage';
import { initialState as initialClusterSummaryState } from '../../../../state/cluster-summary/cluster-summary.reducer';
import { clusterSummaryFeatureKey } from '../../../../state/cluster-summary';

describe('ParameterContextListing', () => {
    let component: ProvenanceEventListing;
    let fixture: ComponentFixture<ProvenanceEventListing>;

    beforeEach(() => {
        TestBed.configureTestingModule({
            imports: [ProvenanceEventListing],
            providers: [
                provideMockStore({
                    initialState: {
                        [errorFeatureKey]: initialErrorState,
                        [clusterSummaryFeatureKey]: initialClusterSummaryState,
                        [provenanceFeatureKey]: {
                            [provenanceEventListingFeatureKey]: initialState,
                            [lineageFeatureKey]: initialLineageState
                        }
                    }
                })
            ]
        });
        fixture = TestBed.createComponent(ProvenanceEventListing);
        component = fixture.componentInstance;
        fixture.detectChanges();
    });

    it('should create', () => {
        expect(component).toBeTruthy();
    });
});
