/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import org.apache.nifi.minifi.toolkit.configuration.PathInputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.PathOutputStreamFactory;
import org.apache.nifi.minifi.toolkit.configuration.json.TransformNifiCommandFactory;
import org.apache.nifi.minifi.toolkit.configuration.json.TransformYamlCommandFactory;

public class ConfigMain {
    public static final int ERR_INVALID_ARGS = 1;
    public static final int ERR_UNABLE_TO_OPEN_INPUT = 3;
    public static final int ERR_UNABLE_TO_READ_TEMPLATE = 4;
    public static final int ERR_UNABLE_TO_PARSE_CONFIG = 6;
    public static final int ERR_UNABLE_TO_SAVE_CONFIG = 9;
    public static final int SUCCESS = 0;
    private final Map<String, Command> commandMap;
    private final PathInputStreamFactory pathInputStreamFactory;
    private final PathOutputStreamFactory pathOutputStreamFactory;

    public ConfigMain(PathInputStreamFactory pathInputStreamFactory, PathOutputStreamFactory pathOutputStreamFactory) {
        this.pathInputStreamFactory = pathInputStreamFactory;
        this.pathOutputStreamFactory = pathOutputStreamFactory;
        this.commandMap = this.createCommandMap();
    }

    public static void main(String[] args) {
        System.exit(new ConfigMain(FileInputStream::new, FileOutputStream::new).execute(args));
    }

    public int execute(String[] args) {
        if (args.length < 1 || !this.commandMap.containsKey(args[0].toLowerCase())) {
            this.printUsage();
            return 1;
        }
        return this.commandMap.get((Object)args[0].toLowerCase()).function.apply(args);
    }

    private void printUsage() {
        System.out.println("Usage:");
        System.out.println();
        System.out.println("Valid commands include:");
        this.commandMap.forEach((s, command) -> System.out.println(s + ": " + command.description));
    }

    public Map<String, Command> createCommandMap() {
        TreeMap<String, Command> result = new TreeMap<String, Command>();
        result.put("transform-yml", new TransformYamlCommandFactory(this.pathInputStreamFactory, this.pathOutputStreamFactory).create());
        result.put("transform-nifi", new TransformNifiCommandFactory(this.pathInputStreamFactory, this.pathOutputStreamFactory).create());
        return result;
    }

    public static class Command {
        private final Function<String[], Integer> function;
        private final String description;

        public Command(Function<String[], Integer> function, String description) {
            this.function = function;
            this.description = description;
        }
    }
}

