/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.toolkit.kafkamigrator.service;

import org.apache.nifi.toolkit.kafkamigrator.MigratorConfiguration;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.FlowPropertyXpathDescriptor;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.KafkaProcessorDescriptor;
import org.apache.nifi.toolkit.kafkamigrator.descriptor.KafkaProcessorType;
import org.apache.nifi.toolkit.kafkamigrator.migrator.ConsumeKafkaFlowMigrator;
import org.apache.nifi.toolkit.kafkamigrator.migrator.Migrator;
import org.apache.nifi.toolkit.kafkamigrator.migrator.PublishKafkaFlowMigrator;
import org.apache.nifi.toolkit.kafkamigrator.service.KafkaMigrationService;

public class KafkaFlowMigrationService
implements KafkaMigrationService {
    private static final String XPATH_FOR_PROCESSORS_IN_FLOW = ".//processor";
    private static final String CLASS_TAG_NAME = "class";

    @Override
    public String getPathForProcessors() {
        return XPATH_FOR_PROCESSORS_IN_FLOW;
    }

    @Override
    public String getPathForClass() {
        return CLASS_TAG_NAME;
    }

    @Override
    public Migrator createPublishMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_NOT_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.PUBLISH)).setPropertyXpathDescriptor(new FlowPropertyXpathDescriptor(KafkaProcessorType.PUBLISH));
        return new PublishKafkaFlowMigrator(configurationBuilder.build());
    }

    @Override
    public Migrator createConsumeMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_NOT_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.CONSUME)).setPropertyXpathDescriptor(new FlowPropertyXpathDescriptor(KafkaProcessorType.CONSUME));
        return new ConsumeKafkaFlowMigrator(configurationBuilder.build());
    }

    @Override
    public Migrator createVersionEightPublishMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.PUBLISH)).setPropertyXpathDescriptor(new FlowPropertyXpathDescriptor(KafkaProcessorType.PUBLISH));
        return new PublishKafkaFlowMigrator(configurationBuilder.build());
    }

    @Override
    public Migrator createVersionEightConsumeMigrator(MigratorConfiguration.MigratorConfigurationBuilder configurationBuilder) {
        configurationBuilder.setIsVersion8Processor(IS_VERSION_EIGHT_PROCESSOR).setProcessorDescriptor(new KafkaProcessorDescriptor(KafkaProcessorType.CONSUME)).setPropertyXpathDescriptor(new FlowPropertyXpathDescriptor(KafkaProcessorType.CONSUME));
        return new ConsumeKafkaFlowMigrator(configurationBuilder.build());
    }
}

