/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.saml2.web.authentication.logout;

import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.security.logout.LogoutRequest;
import org.apache.nifi.web.security.logout.LogoutRequestManager;
import org.apache.nifi.web.util.RequestUriBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;

public class Saml2LogoutSuccessHandler
implements LogoutSuccessHandler {
    private static final String LOGOUT_COMPLETE_PATH = "/nifi/logout-complete";
    private static final Logger logger = LoggerFactory.getLogger(Saml2LogoutSuccessHandler.class);
    private final ApplicationCookieService applicationCookieService = new StandardApplicationCookieService();
    private final LogoutRequestManager logoutRequestManager;

    public Saml2LogoutSuccessHandler(LogoutRequestManager logoutRequestManager) {
        this.logoutRequestManager = Objects.requireNonNull(logoutRequestManager, "Logout Request Manager required");
    }

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException {
        Optional<String> logoutRequestIdentifier = this.applicationCookieService.getCookieValue(request, ApplicationCookieName.LOGOUT_REQUEST_IDENTIFIER);
        if (logoutRequestIdentifier.isPresent()) {
            String requestIdentifier = logoutRequestIdentifier.get();
            LogoutRequest logoutRequest = this.logoutRequestManager.complete(requestIdentifier);
            if (logoutRequest == null) {
                logger.warn("Logout Request [{}] not found", (Object)requestIdentifier);
            } else {
                String mappedUserIdentity = logoutRequest.getMappedUserIdentity();
                logger.info("Logout Request [{}] Identity [{}] completed", (Object)requestIdentifier, (Object)mappedUserIdentity);
            }
            URI logoutCompleteUri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)request).path(LOGOUT_COMPLETE_PATH).build();
            String targetUrl = logoutCompleteUri.toString();
            response.sendRedirect(targetUrl);
        }
    }
}

