/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.authorization.util.UserGroupUtil;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.security.authentication.AuthenticationProvider;

public abstract class NiFiAuthenticationProvider
implements AuthenticationProvider {
    private final Authorizer authorizer;
    private final List<IdentityMapping> mappings;

    public NiFiAuthenticationProvider(NiFiProperties properties, Authorizer authorizer) {
        this.mappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiProperties)properties));
        this.authorizer = authorizer;
    }

    public List<IdentityMapping> getMappings() {
        return this.mappings;
    }

    protected String mapIdentity(String identity) {
        return IdentityMappingUtil.mapIdentity((String)identity, this.mappings);
    }

    protected Set<String> getUserGroups(String identity) {
        return UserGroupUtil.getUserGroups((Authorizer)this.authorizer, (String)identity);
    }
}

