/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.network.KqueueAccessor;
import io.questdb.network.KqueueFacade;
import io.questdb.network.NetworkError;
import io.questdb.std.Files;
import io.questdb.std.Unsafe;
import java.io.Closeable;

public final class Kqueue
implements Closeable {
    private static final Log LOG = LogFactory.getLog(Kqueue.class);
    private final int bufferSize;
    private final int capacity;
    private final long changeList;
    private final long eventList;
    private final int kq;
    private final KqueueFacade kqf;
    private long readAddress;
    private long writeAddress;

    public Kqueue(KqueueFacade kqf, int capacity) {
        this.kqf = kqf;
        this.capacity = capacity;
        this.bufferSize = KqueueAccessor.SIZEOF_KEVENT * capacity;
        this.changeList = this.writeAddress = Unsafe.calloc(this.bufferSize, 49);
        this.eventList = this.readAddress = Unsafe.calloc(this.bufferSize, 49);
        this.kq = kqf.kqueue();
        if (this.kq < 0) {
            throw NetworkError.instance(kqf.getNetworkFacade().errno(), "could not create kqueue");
        }
        Files.bumpFileCount(this.kq);
    }

    @Override
    public void close() {
        this.kqf.getNetworkFacade().close(this.kq, LOG);
        Unsafe.free(this.changeList, this.bufferSize, 49);
        Unsafe.free(this.eventList, this.bufferSize, 49);
    }

    public long getData() {
        return Unsafe.getUnsafe().getLong(this.readAddress + (long)KqueueAccessor.DATA_OFFSET);
    }

    public int getFd() {
        return (int)Unsafe.getUnsafe().getLong(this.readAddress + (long)KqueueAccessor.FD_OFFSET);
    }

    public int getFilter() {
        return Unsafe.getUnsafe().getShort(this.readAddress + (long)KqueueAccessor.FILTER_OFFSET);
    }

    public int listen(int sfd) {
        this.writeAddress = this.changeList;
        this.commonFd(sfd, 0L);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, KqueueAccessor.EV_ADD);
        return this.register(1);
    }

    public int poll() {
        return this.kqf.kevent(this.kq, 0L, 0, this.eventList, this.capacity);
    }

    public void readFD(int fd, long data) {
        this.commonFd(fd, data);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, (short)(KqueueAccessor.EV_ADD | KqueueAccessor.EV_ONESHOT));
    }

    public int register(int n) {
        return this.kqf.kevent(this.kq, this.changeList, n, 0L, 0);
    }

    public void removeFD(int fd) {
        this.commonFd(fd, 0L);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, KqueueAccessor.EV_DELETE);
    }

    public int removeListen(int sfd) {
        this.writeAddress = this.changeList;
        this.commonFd(sfd, 0L);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_READ);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, KqueueAccessor.EV_DELETE);
        return this.register(1);
    }

    public void setReadOffset(int offset) {
        this.readAddress = this.eventList + (long)offset;
    }

    public void setWriteOffset(int offset) {
        this.writeAddress = this.changeList + (long)offset;
    }

    public void writeFD(int fd, long data) {
        this.commonFd(fd, data);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FILTER_OFFSET, KqueueAccessor.EVFILT_WRITE);
        Unsafe.getUnsafe().putShort(this.writeAddress + (long)KqueueAccessor.FLAGS_OFFSET, (short)(KqueueAccessor.EV_ADD | KqueueAccessor.EV_ONESHOT));
    }

    private void commonFd(int fd, long data) {
        Unsafe.getUnsafe().putLong(this.writeAddress + (long)KqueueAccessor.FD_OFFSET, fd);
        Unsafe.getUnsafe().putLong(this.writeAddress + (long)KqueueAccessor.DATA_OFFSET, data);
    }
}

