/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.entitystore.iterate;

import jetbrains.exodus.entitystore.iterate.IdFilter;
import org.jetbrains.annotations.NotNull;

abstract class BloomIdFilter
implements IdFilter {
    final int[] ids;
    private final int bloomFilter;

    BloomIdFilter(@NotNull int[] ids) {
        this.ids = ids;
        int bloomFilter = 0;
        for (int id : ids) {
            bloomFilter |= 1 << (id & 0x1F);
        }
        this.bloomFilter = bloomFilter;
    }

    @Override
    public boolean hasId(int id) {
        return (this.bloomFilter & 1 << (id & 0x1F)) != 0;
    }
}

