/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.serialization;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Element;

public class FlowEncodingVersion {
    public static final String ENCODING_VERSION_ATTRIBUTE = "encoding-version";
    private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+)\\.(\\d)+");
    private final int majorVersion;
    private final int minorVersion;

    public FlowEncodingVersion(int majorVersion, int minorVersion) {
        if (majorVersion < 0) {
            throw new IllegalArgumentException("Invalid version: Major version cannot be less than 0 but was " + majorVersion);
        }
        if (minorVersion < 0) {
            throw new IllegalArgumentException("Invalid version: Minor version cannot be less than 0 but was " + minorVersion);
        }
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
    }

    public static FlowEncodingVersion parse(Element xmlElement) {
        if (xmlElement == null) {
            return null;
        }
        String version = xmlElement.getAttribute(ENCODING_VERSION_ATTRIBUTE);
        if (version == null) {
            return null;
        }
        return FlowEncodingVersion.parse(version);
    }

    public static FlowEncodingVersion parse(String version) {
        if (version == null || version.trim().isEmpty()) {
            return null;
        }
        Matcher matcher = VERSION_PATTERN.matcher(version.trim());
        if (!matcher.matches()) {
            throw new IllegalArgumentException(version + " is not a valid version for Flow serialization. Should be in format <number>.<number>");
        }
        int majorVersion = Integer.parseInt(matcher.group(1));
        int minorVersion = Integer.parseInt(matcher.group(2));
        return new FlowEncodingVersion(majorVersion, minorVersion);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }
}

