/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.store;

import java.io.IOException;
import java.io.InputStream;
import v14.h2.message.DbException;
import v14.h2.store.DataHandler;
import v14.h2.value.ValueLobDb;

class LobStorageRemoteInputStream
extends InputStream {
    private final DataHandler handler;
    private final long lob;
    private final byte[] hmac;
    private long pos;
    private long remainingBytes;

    public LobStorageRemoteInputStream(DataHandler dataHandler, ValueLobDb valueLobDb, byte[] byArray, long l) {
        this.handler = dataHandler;
        this.lob = valueLobDb.getLobId();
        this.hmac = byArray;
        this.remainingBytes = l;
    }

    @Override
    public int read() throws IOException {
        byte[] byArray = new byte[1];
        int n = this.read(byArray, 0, 1);
        return n < 0 ? n : byArray[0] & 0xFF;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            return 0;
        }
        if ((n2 = (int)Math.min((long)n2, this.remainingBytes)) == 0) {
            return -1;
        }
        try {
            n2 = this.handler.readLob(this.lob, this.hmac, this.pos, byArray, n, n2);
        }
        catch (DbException dbException) {
            throw DbException.convertToIOException(dbException);
        }
        if (n2 == 0) {
            return -1;
        }
        this.remainingBytes -= (long)n2;
        this.pos += (long)n2;
        return n2;
    }

    @Override
    public long skip(long l) {
        this.remainingBytes -= l;
        this.pos += l;
        return l;
    }
}

