/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javap;

import java.util.ArrayList;
import java.util.List;
import jpt.sun.tools.classfile.Code_attribute;
import jpt.sun.tools.classfile.ConstantPool;
import jpt.sun.tools.classfile.ConstantPoolException;
import jpt.sun.tools.classfile.DescriptorException;
import jpt.sun.tools.classfile.Instruction;
import jpt.sun.tools.classfile.Method;
import jpt.sun.tools.javap.AttributeWriter;
import jpt.sun.tools.javap.BasicWriter;
import jpt.sun.tools.javap.ClassWriter;
import jpt.sun.tools.javap.ConstantWriter;
import jpt.sun.tools.javap.Context;
import jpt.sun.tools.javap.InstructionDetailWriter;
import jpt.sun.tools.javap.LocalVariableTableWriter;
import jpt.sun.tools.javap.LocalVariableTypeTableWriter;
import jpt.sun.tools.javap.Options;
import jpt.sun.tools.javap.SourceWriter;
import jpt.sun.tools.javap.StackMapWriter;
import jpt.sun.tools.javap.TryBlockWriter;
import jpt.sun.tools.javap.TypeAnnotationWriter;

public class CodeWriter
extends BasicWriter {
    Instruction.KindVisitor<Void, Integer> instructionPrinter = new Instruction.KindVisitor<Void, Integer>(){

        @Override
        public Void visitNoOperands(Instruction instr, Integer indent) {
            return null;
        }

        @Override
        public Void visitArrayType(Instruction instr, Instruction.TypeKind kind, Integer indent) {
            CodeWriter.this.print(" " + kind.name);
            return null;
        }

        @Override
        public Void visitBranch(Instruction instr, int offset, Integer indent) {
            CodeWriter.this.print(instr.getPC() + offset);
            return null;
        }

        @Override
        public Void visitConstantPoolRef(Instruction instr, int index, Integer indent) {
            CodeWriter.this.print("#" + index);
            CodeWriter.this.tab();
            CodeWriter.this.print("// ");
            CodeWriter.this.printConstant(index);
            return null;
        }

        @Override
        public Void visitConstantPoolRefAndValue(Instruction instr, int index, int value, Integer indent) {
            CodeWriter.this.print("#" + index + ",  " + value);
            CodeWriter.this.tab();
            CodeWriter.this.print("// ");
            CodeWriter.this.printConstant(index);
            return null;
        }

        @Override
        public Void visitLocal(Instruction instr, int index, Integer indent) {
            CodeWriter.this.print(index);
            return null;
        }

        @Override
        public Void visitLocalAndValue(Instruction instr, int index, int value, Integer indent) {
            CodeWriter.this.print(index + ", " + value);
            return null;
        }

        @Override
        public Void visitLookupSwitch(Instruction instr, int default_, int npairs, int[] matches, int[] offsets, Integer indent) {
            int pc = instr.getPC();
            CodeWriter.this.print("{ // " + npairs);
            CodeWriter.this.indent(indent);
            for (int i = 0; i < npairs; ++i) {
                CodeWriter.this.print(String.format("%n%12d: %d", matches[i], pc + offsets[i]));
            }
            CodeWriter.this.print("\n     default: " + (pc + default_) + "\n}");
            CodeWriter.this.indent(-indent.intValue());
            return null;
        }

        @Override
        public Void visitTableSwitch(Instruction instr, int default_, int low, int high, int[] offsets, Integer indent) {
            int pc = instr.getPC();
            CodeWriter.this.print("{ // " + low + " to " + high);
            CodeWriter.this.indent(indent);
            for (int i = 0; i < offsets.length; ++i) {
                CodeWriter.this.print(String.format("%n%12d: %d", low + i, pc + offsets[i]));
            }
            CodeWriter.this.print("\n     default: " + (pc + default_) + "\n}");
            CodeWriter.this.indent(-indent.intValue());
            return null;
        }

        @Override
        public Void visitValue(Instruction instr, int value, Integer indent) {
            CodeWriter.this.print(value);
            return null;
        }

        @Override
        public Void visitUnknown(Instruction instr, Integer indent) {
            return null;
        }
    };
    private AttributeWriter attrWriter;
    private ClassWriter classWriter;
    private ConstantWriter constantWriter;
    private LocalVariableTableWriter localVariableTableWriter;
    private LocalVariableTypeTableWriter localVariableTypeTableWriter;
    private TypeAnnotationWriter typeAnnotationWriter;
    private SourceWriter sourceWriter;
    private StackMapWriter stackMapWriter;
    private TryBlockWriter tryBlockWriter;
    private Options options;

    public static CodeWriter instance(Context context) {
        CodeWriter instance = context.get(CodeWriter.class);
        if (instance == null) {
            instance = new CodeWriter(context);
        }
        return instance;
    }

    protected CodeWriter(Context context) {
        super(context);
        context.put(CodeWriter.class, this);
        this.attrWriter = AttributeWriter.instance(context);
        this.classWriter = ClassWriter.instance(context);
        this.constantWriter = ConstantWriter.instance(context);
        this.sourceWriter = SourceWriter.instance(context);
        this.tryBlockWriter = TryBlockWriter.instance(context);
        this.stackMapWriter = StackMapWriter.instance(context);
        this.localVariableTableWriter = LocalVariableTableWriter.instance(context);
        this.localVariableTypeTableWriter = LocalVariableTypeTableWriter.instance(context);
        this.typeAnnotationWriter = TypeAnnotationWriter.instance(context);
        this.options = Options.instance(context);
    }

    void write(Code_attribute attr, ConstantPool constant_pool) {
        this.println("Code:");
        this.indent(1);
        this.writeVerboseHeader(attr, constant_pool);
        this.writeInstrs(attr);
        this.writeExceptionTable(attr);
        this.attrWriter.write((Object)attr, attr.attributes, constant_pool);
        this.indent(-1);
    }

    public void writeVerboseHeader(Code_attribute attr, ConstantPool constant_pool) {
        String argCount;
        Method method = this.classWriter.getMethod();
        try {
            int n = method.descriptor.getParameterCount(constant_pool);
            if (!method.access_flags.is(8)) {
                ++n;
            }
            argCount = Integer.toString(n);
        }
        catch (ConstantPoolException e) {
            argCount = this.report(e);
        }
        catch (DescriptorException e) {
            argCount = this.report(e);
        }
        this.println("stack=" + attr.max_stack + ", locals=" + attr.max_locals + ", args_size=" + argCount);
    }

    public void writeInstrs(Code_attribute attr) {
        List<InstructionDetailWriter> detailWriters = this.getDetailWriters(attr);
        for (Instruction instr : attr.getInstructions()) {
            try {
                for (InstructionDetailWriter w : detailWriters) {
                    w.writeDetails(instr);
                }
                this.writeInstr(instr);
            }
            catch (ArrayIndexOutOfBoundsException | IllegalStateException e) {
                this.println(this.report("error at or after byte " + instr.getPC()));
                break;
            }
        }
        for (InstructionDetailWriter w : detailWriters) {
            w.flush();
        }
    }

    public void writeInstr(Instruction instr) {
        this.print(String.format("%4d: %-13s ", instr.getPC(), instr.getMnemonic()));
        int indentWidth = this.options.indentWidth;
        int indent = (6 + indentWidth - 1) / indentWidth;
        instr.accept(this.instructionPrinter, indent);
        this.println();
    }

    public void writeExceptionTable(Code_attribute attr) {
        if (attr.exception_table_length > 0) {
            this.println("Exception table:");
            this.indent(1);
            this.println(" from    to  target type");
            for (int i = 0; i < attr.exception_table.length; ++i) {
                Code_attribute.Exception_data handler = attr.exception_table[i];
                this.print(String.format(" %5d %5d %5d", handler.start_pc, handler.end_pc, handler.handler_pc));
                this.print("   ");
                int catch_type = handler.catch_type;
                if (catch_type == 0) {
                    this.println("any");
                    continue;
                }
                this.print("Class ");
                this.println(this.constantWriter.stringValue(catch_type));
            }
            this.indent(-1);
        }
    }

    private void printConstant(int index) {
        this.constantWriter.write(index);
    }

    private List<InstructionDetailWriter> getDetailWriters(Code_attribute attr) {
        ArrayList<InstructionDetailWriter> detailWriters = new ArrayList<InstructionDetailWriter>();
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.SOURCE)) {
            this.sourceWriter.reset(this.classWriter.getClassFile(), attr);
            if (this.sourceWriter.hasSource()) {
                detailWriters.add(this.sourceWriter);
            } else {
                this.println("(Source code not available)");
            }
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.LOCAL_VARS)) {
            this.localVariableTableWriter.reset(attr);
            detailWriters.add(this.localVariableTableWriter);
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.LOCAL_VAR_TYPES)) {
            this.localVariableTypeTableWriter.reset(attr);
            detailWriters.add(this.localVariableTypeTableWriter);
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.STACKMAPS)) {
            this.stackMapWriter.reset(attr);
            this.stackMapWriter.writeInitialDetails();
            detailWriters.add(this.stackMapWriter);
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.TRY_BLOCKS)) {
            this.tryBlockWriter.reset(attr);
            detailWriters.add(this.tryBlockWriter);
        }
        if (this.options.details.contains((Object)InstructionDetailWriter.Kind.TYPE_ANNOS)) {
            this.typeAnnotationWriter.reset(attr);
            detailWriters.add(this.typeAnnotationWriter);
        }
        return detailWriters;
    }
}

