/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javac.jvm;

import java.util.BitSet;
import jpt.sun.tools.javac.code.Symbol;
import jpt.sun.tools.javac.code.Symtab;
import jpt.sun.tools.javac.code.Type;
import jpt.sun.tools.javac.jvm.ClassFile;
import jpt.sun.tools.javac.jvm.ClassReader;
import jpt.sun.tools.javac.jvm.PoolConstant;
import jpt.sun.tools.javac.resources.CompilerProperties;
import jpt.sun.tools.javac.util.ByteBuffer;
import jpt.sun.tools.javac.util.Convert;
import jpt.sun.tools.javac.util.InvalidUtfException;
import jpt.sun.tools.javac.util.Name;
import jpt.sun.tools.javac.util.Names;

public class PoolReader {
    private final ClassReader reader;
    private final ByteBuffer buf;
    private final Names names;
    private final Symtab syms;
    private final Convert.Validation utf8validation;
    private ImmutablePoolHelper pool;
    private static final BitSet classCP = new BitSet();
    private static final BitSet constantCP = new BitSet();
    private static final BitSet moduleCP = new BitSet();
    private static final BitSet packageCP = new BitSet();
    private static final BitSet utf8CP = new BitSet();
    private static final BitSet nameAndTypeCP = new BitSet();

    PoolReader(ByteBuffer buf) {
        this(null, buf, null, null);
    }

    PoolReader(ClassReader reader, Names names, Symtab syms) {
        this(reader, reader.buf, names, syms);
    }

    PoolReader(ClassReader reader, ByteBuffer buf, Names names, Symtab syms) {
        this.reader = reader;
        this.buf = buf;
        this.names = names;
        this.syms = syms;
        this.utf8validation = reader != null ? reader.utf8validation : Convert.Validation.NONE;
    }

    Symbol.ClassSymbol getClass(int index) {
        return (Symbol.ClassSymbol)this.pool.readIfNeeded(index, classCP);
    }

    <Z> Z peekClassName(int index, Utf8Mapper<Z> mapper) {
        return this.peekItemName(index, mapper);
    }

    <Z> Z peekPackageName(int index, Utf8Mapper<Z> mapper) {
        return this.peekItemName(index, mapper);
    }

    <Z> Z peekModuleName(int index, Utf8Mapper<Z> mapper) {
        return this.peekItemName(index, mapper);
    }

    private <Z> Z peekItemName(int index, Utf8Mapper<Z> mapper) {
        try {
            index = this.buf.getChar(this.pool.offset(index));
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
        return this.peekName(index, mapper);
    }

    Symbol.ModuleSymbol getModule(int index) {
        return (Symbol.ModuleSymbol)this.pool.readIfNeeded(index, moduleCP);
    }

    Symbol.PackageSymbol getPackage(int index) {
        return (Symbol.PackageSymbol)this.pool.readIfNeeded(index, packageCP);
    }

    <Z> Z peekName(int index, Utf8Mapper<Z> mapper) {
        try {
            return this.getUtf8(index, mapper);
        }
        catch (InvalidUtfException e) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadUtf8ByteSequenceAt(e.getOffset()));
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
    }

    Name getName(int index) {
        return (Name)this.pool.readIfNeeded(index, utf8CP);
    }

    Type getType(int index) {
        return this.getName(index).map(this.reader::sigToType);
    }

    PoolConstant.NameAndType getNameAndType(int index) {
        return (PoolConstant.NameAndType)this.pool.readIfNeeded(index, nameAndTypeCP);
    }

    Object getConstant(int index) {
        return this.pool.readIfNeeded(index, constantCP);
    }

    boolean hasTag(int index, int tag) {
        return this.pool.tag(index) == tag;
    }

    private <Z> Z getUtf8(int index, Utf8Mapper<Z> mapper) throws InvalidUtfException, ByteBuffer.UnderflowException {
        int tag = this.pool.tag(index);
        int offset = this.pool.offset(index);
        if (tag == 1) {
            char utf8len = this.pool.poolbuf.getChar(offset);
            int utf8off = offset + 2;
            this.pool.poolbuf.verifyRange(utf8off, utf8len);
            return mapper.map(this.pool.poolbuf.elems, utf8off, utf8len);
        }
        throw this.reader.badClassFile("unexpected.const.pool.tag.at", Integer.toString(tag), Integer.toString(offset - 1));
    }

    private Object resolve(ByteBuffer poolbuf, int tag, int offset) throws InvalidUtfException, ByteBuffer.UnderflowException {
        switch (tag) {
            case 1: {
                char len = poolbuf.getChar(offset);
                try {
                    return this.names.fromUtf(poolbuf.elems, offset + 2, len, this.utf8validation);
                }
                catch (InvalidUtfException e) {
                    if (this.reader == null || this.reader.warnOnIllegalUtf8) {
                        if (this.reader != null) {
                            this.reader.log.warning(CompilerProperties.Warnings.InvalidUtf8InClassfile(this.reader.currentClassFile, CompilerProperties.Fragments.BadUtf8ByteSequenceAt(e.getOffset())));
                        }
                        return this.names.fromUtfLax(poolbuf.elems, offset + 2, len);
                    }
                    throw e;
                }
            }
            case 7: {
                char index = poolbuf.getChar(offset);
                Name name = ClassFile.internalize(this.getName(index));
                return this.syms.enterClass(this.reader.currentModule, name);
            }
            case 12: {
                Name name = this.getName(poolbuf.getChar(offset));
                Type type = this.getType(poolbuf.getChar(offset + 2));
                return new PoolConstant.NameAndType(name, type);
            }
            case 3: {
                return poolbuf.getInt(offset);
            }
            case 4: {
                return Float.valueOf(poolbuf.getFloat(offset));
            }
            case 5: {
                return poolbuf.getLong(offset);
            }
            case 6: {
                return poolbuf.getDouble(offset);
            }
            case 8: {
                return this.getName(poolbuf.getChar(offset)).toString();
            }
            case 20: {
                Name name = this.getName(poolbuf.getChar(offset));
                return this.syms.enterPackage(this.reader.currentModule, ClassFile.internalize(name));
            }
            case 19: {
                Name name = this.getName(poolbuf.getChar(offset));
                return this.syms.enterModule(name);
            }
        }
        throw this.reader.badClassFile("unexpected.const.pool.tag.at", Integer.toString(tag), Integer.toString(offset - 1));
    }

    int readPool(ByteBuffer poolbuf, int offset) {
        try {
            return this.readPoolInternal(poolbuf, offset);
        }
        catch (ByteBuffer.UnderflowException e) {
            throw this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
        }
    }

    private int readPoolInternal(ByteBuffer poolbuf, int offset) throws ByteBuffer.UnderflowException {
        byte tag;
        int poolSize = poolbuf.getChar(offset);
        offset += 2;
        int[] offsets = new int[poolSize];
        block7: for (int index = 1; index < poolSize; index += this.sizeof(tag)) {
            tag = poolbuf.getByte(offset++);
            offsets[index] = offset;
            switch (tag) {
                case 1: {
                    char len = poolbuf.getChar(offset);
                    offset += 2 + len;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    offset += 2;
                    continue block7;
                }
                case 15: {
                    offset += 3;
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    offset += 4;
                    continue block7;
                }
                case 5: 
                case 6: {
                    offset += 8;
                    continue block7;
                }
                default: {
                    throw this.reader.badClassFile("bad.const.pool.tag.at", Byte.toString(tag), Integer.toString(offset - 1));
                }
            }
        }
        this.pool = new ImmutablePoolHelper(poolbuf, offsets);
        return offset;
    }

    private int sizeof(int tag) {
        switch (tag) {
            case 5: 
            case 6: {
                return 2;
            }
        }
        return 1;
    }

    static {
        classCP.set(7);
        constantCP.set(3, 9);
        moduleCP.set(19);
        packageCP.set(20);
        utf8CP.set(1);
        nameAndTypeCP.set(12);
    }

    class ImmutablePoolHelper {
        final Object[] values;
        final int[] offsets;
        final ByteBuffer poolbuf;

        public ImmutablePoolHelper(ByteBuffer poolbuf, int[] offsets) {
            this.offsets = offsets;
            this.values = new Object[offsets.length];
            this.poolbuf = poolbuf;
        }

        private int checkIndex(int index) {
            if (index <= 0 || index >= this.offsets.length) {
                throw PoolReader.this.reader.badClassFile("bad.const.pool.index", ((PoolReader)PoolReader.this).reader.currentClassFile, index, this.offsets.length);
            }
            return index;
        }

        int offset(int index) {
            return this.offsets[this.checkIndex(index)];
        }

        <P> P readIfNeeded(int index, BitSet expectedTags) {
            Object p;
            Object v = this.values[this.checkIndex(index)];
            if (v != null) {
                return (P)v;
            }
            int currentTag = this.tag(index);
            if (!expectedTags.get(currentTag)) {
                throw PoolReader.this.reader.badClassFile("unexpected.const.pool.tag.at", this.tag(index), this.offset(index));
            }
            try {
                p = PoolReader.this.resolve(this.poolbuf, currentTag, this.offset(index));
            }
            catch (InvalidUtfException e) {
                throw PoolReader.this.reader.badClassFile(CompilerProperties.Fragments.BadUtf8ByteSequenceAt(e.getOffset()));
            }
            catch (ByteBuffer.UnderflowException e) {
                throw PoolReader.this.reader.badClassFile(CompilerProperties.Fragments.BadClassTruncatedAtOffset(e.getLength()));
            }
            this.values[index] = p;
            return (P)p;
        }

        int tag(int index) {
            return this.poolbuf.elems[this.offset(index) - 1];
        }
    }

    public static interface Utf8Mapper<X> {
        public X map(byte[] var1, int var2, int var3) throws InvalidUtfException;
    }
}

