/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.Key;
import java.security.KeyPair;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.keys.Identity;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.keyprovider.KeyTypeIndicator;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum BuiltinIdentities implements Identity
{
    RSA("RSA", "ssh-rsa"),
    DSA("DSA", "ssh-dss"),
    ECDSA("ECDSA", "EC", (Collection<String>)ECCurves.VALUES.stream().map(KeyTypeIndicator::getKeyType).collect(Collectors.toList())),
    ED25119("ED25519", "Ed25519", "ssh-ed25519"){

        @Override
        public boolean isSupported() {
            return SecurityUtils.isEDDSACurveSupported();
        }
    };

    public static final Set<BuiltinIdentities> VALUES;
    public static final NavigableSet<String> NAMES;
    private final String name;
    private final String algorithm;
    private final NavigableSet<String> types;

    private BuiltinIdentities(String type, String keyType) {
        this(type, type, keyType);
    }

    private BuiltinIdentities(String name, String algorithm, String keyType) {
        this(name, algorithm, Collections.singletonList(ValidateUtils.checkNotNullAndNotEmpty(keyType, "No key type specified")));
    }

    private BuiltinIdentities(String name, String algorithm, Collection<String> keyTypes) {
        this.name = name.toLowerCase();
        this.algorithm = algorithm.toUpperCase();
        this.types = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, ValidateUtils.checkNotNullAndNotEmpty(keyTypes, "No key type names provided", new Object[0])));
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public NavigableSet<String> getSupportedKeyTypes() {
        return this.types;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    public static BuiltinIdentities fromName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static BuiltinIdentities fromAlgorithm(String algorithm) {
        if (GenericUtils.isEmpty(algorithm)) {
            return null;
        }
        for (BuiltinIdentities id : VALUES) {
            if (!algorithm.equalsIgnoreCase(id.getAlgorithm())) continue;
            return id;
        }
        return null;
    }

    public static BuiltinIdentities fromKeyPair(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        return BuiltinIdentities.fromKeyType(KeyUtils.getKeyType(kp));
    }

    public static BuiltinIdentities fromKey(Key key) {
        if (key == null) {
            return null;
        }
        return BuiltinIdentities.fromKeyType(KeyUtils.getKeyType(key));
    }

    private static BuiltinIdentities fromKeyType(String type) {
        if (type == null) {
            return null;
        }
        return VALUES.stream().filter(b -> b.getSupportedKeyTypes().contains(type)).findFirst().orElse(null);
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinIdentities.class));
        NAMES = Collections.unmodifiableNavigableSet(GenericUtils.asSortedSet(String.CASE_INSENSITIVE_ORDER, NamedResource.getNameList(VALUES)));
    }

    public static final class Constants {
        public static final String RSA = "RSA";
        public static final String DSA = "DSA";
        public static final String ECDSA = "ECDSA";
        public static final String ED25519 = "ED25519";

        private Constants() {
            throw new UnsupportedOperationException("No instance allowed");
        }
    }
}

