/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.crypto.AEADBadTagException;
import javax.crypto.spec.ChaCha20ParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.sshd.common.cipher.AbstractChaCha20Cipher;
import org.apache.sshd.common.cipher.ChaCha20Cipher;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.mac.Poly1305Mac;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.BufferUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class ChaCha20CipherFactory
implements Supplier<Cipher> {
    public static final ChaCha20CipherFactory INSTANCE = new ChaCha20CipherFactory();
    private static final Logger LOG = LoggerFactory.getLogger(ChaCha20CipherFactory.class);
    private static final AtomicReference<Boolean> SUPPORTED = new AtomicReference();

    private ChaCha20CipherFactory() {
    }

    @Override
    public Cipher get() {
        if (this.hasChaCha20()) {
            LOG.debug("Using SunJCE ChaCha20");
            return ChaCha20Jdk.get();
        }
        LOG.debug("Using Java11 factory, but Java 8 ChaCha20.");
        return new ChaCha20Cipher();
    }

    private boolean hasChaCha20() {
        Boolean supported = SUPPORTED.get();
        if (supported == null) {
            try {
                javax.crypto.Cipher cipher = javax.crypto.Cipher.getInstance("ChaCha20", "SunJCE");
                supported = cipher != null;
            }
            catch (GeneralSecurityException e) {
                supported = Boolean.FALSE;
            }
            if (!SUPPORTED.compareAndSet(null, supported)) {
                supported = SUPPORTED.get();
            }
        }
        return supported;
    }

    private static class ChaCha20Jdk
    extends AbstractChaCha20Cipher {
        protected final javax.crypto.Cipher headerEngine;
        protected final javax.crypto.Cipher bodyEngine;
        protected final Mac mac = new Poly1305Mac();
        protected Cipher.Mode mode;
        private byte[] nonce;
        private long initialNonce;
        private SecretKeySpec k1;
        private SecretKeySpec k2;

        static Cipher get() {
            try {
                javax.crypto.Cipher header = javax.crypto.Cipher.getInstance("ChaCha20", "SunJCE");
                javax.crypto.Cipher body = javax.crypto.Cipher.getInstance("ChaCha20", "SunJCE");
                return new ChaCha20Jdk(header, body);
            }
            catch (GeneralSecurityException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        private ChaCha20Jdk(javax.crypto.Cipher header, javax.crypto.Cipher body) {
            this.headerEngine = header;
            this.bodyEngine = body;
        }

        @Override
        public void init(Cipher.Mode mode, byte[] key, byte[] iv) throws Exception {
            this.mode = mode;
            long hiBits = BufferUtils.getUInt(iv, 0, 4);
            ValidateUtils.checkState(hiBits == 0L, "ChaCha20 nonce is not a valid SSH packet sequence number");
            this.initialNonce = BufferUtils.getUInt(iv, 4, 8);
            this.nonce = new byte[12];
            System.arraycopy(iv, 4, this.nonce, 8, 4);
            ChaCha20ParameterSpec algorithmParameterSpec = new ChaCha20ParameterSpec(this.nonce, 0);
            this.k1 = new SecretKeySpec(Arrays.copyOfRange(key, 0, 32), "ChaCha20");
            this.bodyEngine.init(mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)this.k1, algorithmParameterSpec);
            this.init(this.mac, this.bodyEngine);
            this.k2 = new SecretKeySpec(Arrays.copyOfRange(key, 32, 64), "ChaCha20");
            this.headerEngine.init(mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)this.k2, algorithmParameterSpec);
        }

        @Override
        public void updateAAD(byte[] data, int offset, int length) throws Exception {
            ValidateUtils.checkState(this.mode != null, "Cipher not initialized");
            ValidateUtils.checkTrue(length == 4, "AAD only supported for encrypted packet length");
            if (this.mode == Cipher.Mode.Decrypt) {
                this.mac.update(data, offset, length);
            }
            this.headerEngine.doFinal(data, offset, length, data, offset);
            if (this.mode == Cipher.Mode.Encrypt) {
                this.mac.update(data, offset, length);
            }
        }

        @Override
        public void update(byte[] input, int inputOffset, int inputLen) throws Exception {
            long counter;
            ValidateUtils.checkState(this.mode != null, "Cipher not initialized");
            if (this.mode == Cipher.Mode.Decrypt) {
                this.mac.update(input, inputOffset, inputLen);
                byte[] actual = this.mac.doFinal();
                if (!Mac.equals(input, inputOffset + inputLen, actual, 0, actual.length)) {
                    throw new AEADBadTagException("Tag mismatch");
                }
            }
            this.bodyEngine.doFinal(input, inputOffset, inputLen, input, inputOffset);
            if (this.mode == Cipher.Mode.Encrypt) {
                this.mac.update(input, inputOffset, inputLen);
                this.mac.doFinal(input, inputOffset + inputLen);
            }
            ValidateUtils.checkState((counter = BufferUtils.getUInt(this.nonce, 8, 4) + 1L & 0xFFFFFFFFL) != this.initialNonce, "Packet sequence number cannot be reused with the same key");
            BufferUtils.putUInt(counter, this.nonce, 8, 4);
            ChaCha20ParameterSpec algorithmParameterSpec = new ChaCha20ParameterSpec(this.nonce, 0);
            this.bodyEngine.init(this.mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)this.k1, algorithmParameterSpec);
            this.init(this.mac, this.bodyEngine);
            this.headerEngine.init(this.mode == Cipher.Mode.Encrypt ? 1 : 2, (Key)this.k2, algorithmParameterSpec);
        }

        private void init(Mac mac, javax.crypto.Cipher engine) throws Exception {
            byte[] block = new byte[32];
            engine.update(block, 0, block.length, block);
            mac.init(block);
            engine.update(block, 0, block.length, block);
        }
    }
}

