/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.git.pgm;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.List;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.threads.CloseableExecutorService;
import org.apache.sshd.git.AbstractGitCommand;
import org.apache.sshd.git.GitLocationResolver;
import org.apache.sshd.git.pgm.EmbeddedCommandRunner;

public class GitPgmCommand
extends AbstractGitCommand {
    public GitPgmCommand(GitLocationResolver rootDirResolver, String command, CloseableExecutorService executorService) {
        super(rootDirResolver, command, executorService);
    }

    public void run() {
        String command = this.getCommand();
        OutputStream err = this.getErrorStream();
        try {
            List<String> strs = GitPgmCommand.parseDelimitedString(command, " ", true);
            String[] args = strs.toArray(new String[strs.size()]);
            for (int i = 0; i < args.length; ++i) {
                String argVal = args[i];
                if (argVal.startsWith("'") && argVal.endsWith("'")) {
                    args[i] = argVal.substring(1, argVal.length() - 1);
                    argVal = args[i];
                }
                if (!argVal.startsWith("\"") || !argVal.endsWith("\"")) continue;
                args[i] = argVal.substring(1, argVal.length() - 1);
            }
            GitLocationResolver resolver = this.getGitLocationResolver();
            Path rootDir = resolver.resolveRootDirectory(command, args, this.getServerSession(), this.getFileSystem());
            ValidateUtils.checkState((rootDir != null ? 1 : 0) != 0, (String)"No root directory provided for %s command", (Object)command);
            new EmbeddedCommandRunner(rootDir).execute(args, this.getInputStream(), this.getOutputStream(), err);
            this.onExit(0);
        }
        catch (Throwable t) {
            try {
                err.write((t.getMessage() + "\n").getBytes(StandardCharsets.UTF_8));
                err.flush();
            }
            catch (IOException e) {
                this.log.warn("Failed {} to flush command={} failure: {}", new Object[]{e.getClass().getSimpleName(), command, e.getMessage()});
            }
            this.onExit(-1, t.getMessage());
        }
    }
}

