/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.providers.packaging;

import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import javax.inject.Provider;
import org.apache.maven.lifecycle.mapping.DefaultLifecycleMapping;
import org.apache.maven.lifecycle.mapping.Lifecycle;
import org.apache.maven.lifecycle.mapping.LifecycleMapping;
import org.apache.maven.lifecycle.mapping.LifecyclePhase;

public abstract class AbstractLifecycleMappingProvider
implements Provider<LifecycleMapping> {
    protected static final String RESOURCES_PLUGIN_VERSION = "3.3.1";
    protected static final String COMPILER_PLUGIN_VERSION = "3.13.0";
    protected static final String SUREFIRE_PLUGIN_VERSION = "3.5.2";
    protected static final String INSTALL_PLUGIN_VERSION = "3.1.3";
    protected static final String DEPLOY_PLUGIN_VERSION = "3.1.3";
    protected static final String JAR_PLUGIN_VERSION = "3.4.2";
    protected static final String EAR_PLUGIN_VERSION = "3.3.0";
    protected static final String EJB_PLUGIN_VERSION = "3.2.1";
    protected static final String PLUGIN_PLUGIN_VERSION = "3.15.1";
    protected static final String RAR_PLUGIN_VERSION = "3.0.0";
    protected static final String WAR_PLUGIN_VERSION = "3.4.0";
    private final LifecycleMapping lifecycleMapping;

    protected AbstractLifecycleMappingProvider(String[] pluginBindings) {
        Objects.requireNonNull(pluginBindings);
        int len = pluginBindings.length;
        if (len < 2 || len % 2 != 0) {
            throw new IllegalArgumentException("Plugin bindings must have more than 0, even count of elements");
        }
        HashMap<String, LifecyclePhase> lifecyclePhaseBindings = new HashMap<String, LifecyclePhase>(len / 2);
        for (int i = 0; i < len; i += 2) {
            lifecyclePhaseBindings.put(pluginBindings[i], new LifecyclePhase(pluginBindings[i + 1]));
        }
        Lifecycle lifecycle = new Lifecycle();
        lifecycle.setId("default");
        lifecycle.setLifecyclePhases(Collections.unmodifiableMap(lifecyclePhaseBindings));
        this.lifecycleMapping = new DefaultLifecycleMapping(Collections.singletonList(lifecycle));
    }

    public LifecycleMapping get() {
        return this.lifecycleMapping;
    }
}

