/*
 * Decompiled with CFR 0.152.
 */
package org.mvndaemon.mvnd.execution;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.maven.execution.BuildFailure;
import org.apache.maven.execution.BuildSuccess;
import org.apache.maven.execution.MavenExecutionResult;
import org.mvndaemon.mvnd.execution.BuildResumptionAnalyzer;
import org.mvndaemon.mvnd.execution.BuildResumptionData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultBuildResumptionAnalyzer
implements BuildResumptionAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultBuildResumptionAnalyzer.class);

    @Override
    public Optional<BuildResumptionData> determineBuildResumptionData(MavenExecutionResult result) {
        if (!result.hasExceptions()) {
            return Optional.empty();
        }
        List sortedProjects = result.getTopologicallySortedProjects();
        boolean hasNoSuccess = sortedProjects.stream().noneMatch(project -> result.getBuildSummary(project) instanceof BuildSuccess);
        if (hasNoSuccess) {
            return Optional.empty();
        }
        List<String> remainingProjects = sortedProjects.stream().filter(project -> result.getBuildSummary(project) == null || result.getBuildSummary(project) instanceof BuildFailure).map(project -> project.getGroupId() + ":" + project.getArtifactId()).collect(Collectors.toList());
        if (remainingProjects.isEmpty()) {
            LOGGER.info("No remaining projects found, resuming the build would not make sense.");
            return Optional.empty();
        }
        return Optional.of(new BuildResumptionData(remainingProjects));
    }
}

