/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class Site
implements Serializable,
InputLocationTracker {
    final String id;
    final String name;
    final String url;
    final String childSiteUrlInheritAppendPath;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected Site(Builder builder) {
        String string = builder.id != null ? builder.id : (this.id = builder.base != null ? builder.base.id : null);
        String string2 = builder.name != null ? builder.name : (this.name = builder.base != null ? builder.base.name : null);
        String string3 = builder.url != null ? builder.url : (this.url = builder.base != null ? builder.base.url : null);
        this.childSiteUrlInheritAppendPath = builder.childSiteUrlInheritAppendPath != null ? builder.childSiteUrlInheritAppendPath : (builder.base != null ? builder.base.childSiteUrlInheritAppendPath : null);
        this.locations = builder.computeLocations();
        this.importedFrom = builder.importedFrom;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getChildSiteUrlInheritAppendPath() {
        return this.childSiteUrlInheritAppendPath;
    }

    @Override
    public InputLocation getLocation(Object key) {
        Objects.requireNonNull(key, "key");
        return this.locations.get(key);
    }

    public Set<Object> getLocationKeys() {
        return this.locations.keySet();
    }

    protected Stream<Object> getLocationKeyStream() {
        return this.locations.keySet().stream();
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return Site.newBuilder(this);
    }

    @Nonnull
    public Site withId(String id) {
        return Site.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public Site withName(String name) {
        return Site.newBuilder(this, true).name(name).build();
    }

    @Nonnull
    public Site withUrl(String url) {
        return Site.newBuilder(this, true).url(url).build();
    }

    @Nonnull
    public Site withChildSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
        return Site.newBuilder(this, true).childSiteUrlInheritAppendPath(childSiteUrlInheritAppendPath).build();
    }

    @Nonnull
    public static Site newInstance() {
        return Site.newInstance(true);
    }

    @Nonnull
    public static Site newInstance(boolean withDefaults) {
        return Site.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return Site.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(Site from) {
        return Site.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(Site from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isChildSiteUrlInheritAppendPath() {
        return this.getChildSiteUrlInheritAppendPath() != null ? Boolean.parseBoolean(this.getChildSiteUrlInheritAppendPath()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        Site base;
        String id;
        String name;
        String url;
        String childSiteUrlInheritAppendPath;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(Site base, boolean forceCopy) {
            if (forceCopy) {
                this.id = base.id;
                this.name = base.name;
                this.url = base.url;
                this.childSiteUrlInheritAppendPath = base.childSiteUrlInheritAppendPath;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder name(String name) {
            this.name = name;
            return this;
        }

        @Nonnull
        public Builder url(String url) {
            this.url = url;
            return this;
        }

        @Nonnull
        public Builder childSiteUrlInheritAppendPath(String childSiteUrlInheritAppendPath) {
            this.childSiteUrlInheritAppendPath = childSiteUrlInheritAppendPath;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Site build() {
            if (!(this.base == null || this.id != null && this.id != this.base.id || this.name != null && this.name != this.base.name || this.url != null && this.url != this.base.url || this.childSiteUrlInheritAppendPath != null && this.childSiteUrlInheritAppendPath != this.base.childSiteUrlInheritAppendPath)) {
                return this.base;
            }
            return new Site(this);
        }

        Map<Object, InputLocation> computeLocations() {
            Map oldlocs;
            Map<Object, Object> newlocs = this.locations != null ? this.locations : Map.of();
            Map<Object, Object> map = oldlocs = this.base != null ? this.base.locations : Map.of();
            if (newlocs.isEmpty()) {
                return Map.copyOf(oldlocs);
            }
            if (oldlocs.isEmpty()) {
                return Map.copyOf(newlocs);
            }
            return Stream.concat(newlocs.entrySet().stream(), oldlocs.entrySet().stream()).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1));
        }
    }
}

