/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb.gco;

import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.jaxb.cat.CodeListUID;
import org.apache.sis.internal.jaxb.gco.GO_URL;
import org.apache.sis.internal.jaxb.gco.StringAdapter;
import org.apache.sis.internal.jaxb.gcx.Anchor;
import org.apache.sis.internal.jaxb.gcx.FileName;
import org.apache.sis.internal.jaxb.gcx.MimeFileType;
import org.apache.sis.internal.jaxb.lan.Country;
import org.apache.sis.internal.jaxb.lan.LanguageCode;
import org.apache.sis.internal.jaxb.lan.PT_FreeText;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.iso.Types;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.util.resources.Messages;
import org.apache.sis.xml.Namespaces;
import org.opengis.util.CodeList;
import org.w3c.dom.Element;

@XmlType(name="CharacterString_PropertyType")
@XmlSeeAlso(value={PT_FreeText.class, LanguageCode.class, Country.class})
@XmlRootElement(name="CharacterString")
public class GO_CharacterString {
    public static final byte MIME_TYPE = 1;
    public static final byte FILENAME = 3;
    public static final byte URL = 2;
    private static final byte ANCHOR = 4;
    private static final byte ENUM = 5;
    private CharSequence text;
    public byte type;

    private static String nameOf(byte by) {
        switch (by) {
            case 0: {
                return "CharacterString";
            }
            case 1: {
                return "MimeFileType";
            }
            case 3: {
                return "FileName";
            }
            case 4: {
                return "Anchor";
            }
            case 5: {
                return "ControlledVocabulary";
            }
            case 2: {
                return "URL";
            }
        }
        throw new AssertionError(by);
    }

    protected GO_CharacterString() {
    }

    protected GO_CharacterString(CharSequence charSequence) {
        this.text = charSequence;
        if (charSequence instanceof Anchor) {
            this.type = (byte)4;
        } else if (Types.forCodeTitle(charSequence) != null) {
            this.type = (byte)5;
        }
    }

    private void setText(CharSequence charSequence, byte by) {
        if ((charSequence = CharSequences.trimWhitespaces(charSequence)) != null && charSequence.length() != 0) {
            if (this.text != null && !charSequence.equals(this.text)) {
                byte by2 = this.type;
                boolean bl = false;
                if (by2 > by) {
                    by2 = by;
                    by = this.type;
                    bl = true;
                }
                Context.warningOccured(Context.current(), this.getClass(), "setText", Messages.class, (short)19, GO_CharacterString.nameOf(by2), GO_CharacterString.nameOf(by));
                if (bl) {
                    return;
                }
            }
            this.text = charSequence;
            this.type = by;
        }
    }

    @XmlElements(value={@XmlElement(type=String.class, name="CharacterString"), @XmlElement(type=Anchor.class, name="Anchor", namespace="http://standards.iso.org/iso/19115/-3/gcx/1.0"), @XmlElement(type=FileName.class, name="FileName", namespace="http://standards.iso.org/iso/19115/-3/gcx/1.0"), @XmlElement(type=MimeFileType.class, name="MimeFileType", namespace="http://standards.iso.org/iso/19115/-3/gcx/1.0"), @XmlElement(type=GO_URL.class, name="URL", namespace="http://www.isotc211.org/2005/gmd")})
    private Object getValue() {
        switch (this.type) {
            case 0: {
                return StringAdapter.toString(this.text);
            }
            case 2: {
                return new GO_URL(this.text.toString());
            }
            case 3: {
                return new FileName(this.text.toString());
            }
            case 1: {
                return new MimeFileType(this.text.toString());
            }
            case 4: {
                return this.text;
            }
        }
        return null;
    }

    private void setValue(Object object) {
        if (object instanceof Anchor) {
            this.setText((CharSequence)((Object)((Anchor)object)), (byte)4);
        } else if (object instanceof FileName) {
            this.setText(object.toString(), (byte)3);
        } else if (object instanceof MimeFileType) {
            this.setText(object.toString(), (byte)1);
        } else if (object instanceof GO_URL) {
            this.setText(object.toString(), (byte)2);
        } else {
            this.setText((CharSequence)object, (byte)0);
        }
    }

    @XmlAnyElement
    private Object getCodeList() {
        if (this.type != 5) {
            return null;
        }
        CodeList<?> codeList = Types.forCodeTitle(this.text);
        String string = Types.getListName(codeList);
        String string2 = Namespaces.guessForType(string);
        if (string2 == null) {
            string2 = "";
        }
        return new JAXBElement(new QName(string2, string), CodeListUID.class, (Object)new CodeListUID(Context.current(), codeList));
    }

    private void setCodeList(Object object) {
        Element element = (Element)object;
        if (element.getNodeType() == 1) {
            Object[] objectArray;
            short s;
            Class clazz;
            Class<?> clazz2 = Types.forStandardName(element.getLocalName());
            if (clazz2 != null && CodeList.class.isAssignableFrom(clazz2)) {
                String string = element.getAttribute("codeListValue").trim();
                if (!string.isEmpty()) {
                    this.text = Types.getCodeTitle(Types.forCodeName(clazz2, string, true));
                    this.type = (byte)5;
                    return;
                }
                clazz = Errors.class;
                s = 182;
                objectArray = new Object[2];
                objectArray[1] = "codeListValue";
            } else {
                clazz = Messages.class;
                s = 33;
                objectArray = new Object[]{element.getNodeName()};
            }
            Context.warningOccured(Context.current(), GO_CharacterString.class, "setCodeList", clazz, s, objectArray);
        }
    }

    protected CharSequence toCharSequence() {
        CharSequence charSequence = CharSequences.trimWhitespaces(this.text);
        if (charSequence != null && (charSequence.length() != 0 || charSequence instanceof Anchor)) {
            return charSequence;
        }
        return null;
    }

    public final String toString() {
        CharSequence charSequence = this.text;
        return charSequence != null ? charSequence.toString() : null;
    }
}

