/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Type;
import commonj.sdo.helper.HelperContext;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.localization.ToStringLocalization;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.sdo.SDOConstants;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.helper.ClassBuffer;
import org.eclipse.persistence.sdo.helper.CodeWriter;
import org.eclipse.persistence.sdo.helper.DefaultSchemaResolver;
import org.eclipse.persistence.sdo.helper.FileCodeWriter;
import org.eclipse.persistence.sdo.helper.SDOClassGeneratorListener;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.SDOTypesGenerator;
import org.eclipse.persistence.sdo.helper.SchemaResolver;
import org.eclipse.persistence.sdo.helper.extension.SDOUtil;

public class SDOClassGenerator {
    private String indent = "";
    private static int INDENT_TAB = 3;
    private static final String lsep = System.getProperty("line.separator");
    private static final String lsep2 = String.valueOf(lsep) + lsep;
    private static final String START_PROPERTY_INDEX = "START_PROPERTY_INDEX";
    private Map generatedBuffers;
    private boolean interfaceGenerator = true;
    private boolean implGenerator = true;
    private CodeWriter codeWriter;
    private SDOClassGeneratorListener sdoClassGeneratorListener;
    private HelperContext aHelperContext;

    public SDOClassGenerator() {
        this(new SDOHelperContext());
    }

    public SDOClassGenerator(HelperContext aContext) {
        this.aHelperContext = aContext;
        this.generatedBuffers = new HashMap();
    }

    public void setInterfaceGenerator(boolean genIterfaces) {
        this.interfaceGenerator = genIterfaces;
    }

    public void setImplGenerator(boolean genImpls) {
        this.implGenerator = genImpls;
    }

    public static void main(String[] args) {
        SDOClassGenerator generator = new SDOClassGenerator(new SDOHelperContext());
        String sourceDir = null;
        String sourceFile = null;
        int argsLength = args.length;
        AbstractSessionLog.getLog().setLevel(2);
        int i = 0;
        while (i < argsLength) {
            if (args[i].equals("-help")) {
                generator.printUsage(null);
                System.exit(0);
            } else if (args[i].equals("-sourceFile")) {
                if (i == argsLength - 1) {
                    generator.printUsage("sdo_classgenerator_usage_missing_sourcefile_value");
                    System.exit(0);
                }
                sourceFile = args[++i];
            } else if (args[i].equals("-targetDirectory")) {
                if (i == argsLength - 1) {
                    generator.printUsage("sdo_classgenerator_usage_missing_targetdir");
                    System.exit(0);
                }
                sourceDir = args[++i];
            } else if (args[i].equals("-logLevel")) {
                if (i != argsLength - 1) {
                    AbstractSessionLog.getLog().setLevel(Integer.parseInt(args[++i]));
                }
            } else if (args[i].equals("-noInterfaces")) {
                generator.setInterfaceGenerator(false);
            } else if (args[i].equals("-noImpls")) {
                generator.setImplGenerator(false);
            }
            ++i;
        }
        if (sourceFile == null) {
            generator.printUsage("sdo_classgenerator_usage_missing_sourcefile");
            System.exit(0);
        }
        try {
            FileReader reader = new FileReader(sourceFile);
            FileCodeWriter fileCodeWriter = new FileCodeWriter();
            fileCodeWriter.setSourceDir(sourceDir);
            generator.generate((Reader)reader, (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
        }
        catch (IOException e) {
            AbstractSessionLog.getLog().log(7, "sdo_classgenerator_exception", e.getClass().getName(), (Object)e.getLocalizedMessage(), generator.getClass());
            AbstractSessionLog.getLog().logThrowable(7, (Throwable)e);
        }
    }

    private void printUsage(String messageID) {
        if (messageID != null) {
            System.out.println(ToStringLocalization.buildMessage((String)messageID, (Object[])new Object[]{Helper.getShortClassName(this.getClass())}));
        }
        String messageString = ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_1of8", (Object[])new Object[]{Helper.getShortClassName(this.getClass())});
        messageString = String.valueOf(messageString) + Helper.cr() + Helper.cr();
        messageString = String.valueOf(messageString) + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_2of8");
        messageString = String.valueOf(messageString) + Helper.cr();
        messageString = String.valueOf(messageString) + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_3of8");
        messageString = String.valueOf(messageString) + Helper.cr();
        messageString = String.valueOf(messageString) + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_4of8");
        messageString = String.valueOf(messageString) + Helper.cr();
        messageString = String.valueOf(messageString) + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_5of8");
        messageString = String.valueOf(messageString) + Helper.cr();
        messageString = String.valueOf(messageString) + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_6of8");
        messageString = String.valueOf(messageString) + Helper.cr();
        messageString = String.valueOf(messageString) + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_7of8");
        messageString = String.valueOf(messageString) + Helper.cr();
        messageString = String.valueOf(messageString) + ToStringLocalization.buildMessage((String)"sdo_classgenerator_usage_help_8of8");
        messageString = String.valueOf(messageString) + Helper.cr();
        System.out.println(messageString);
    }

    public Map generate(Reader xsdReader) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader xsdReader, String sourceDir) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader xsdReader, String sourceDir, SchemaResolver schemaResolver) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)fileCodeWriter, schemaResolver);
    }

    public Map generate(Reader xsdReader, SchemaResolver schemaResolver) {
        return this.generate((Source)new StreamSource(xsdReader), (CodeWriter)new FileCodeWriter(), schemaResolver);
    }

    public Map generate(Reader xsdReader, CodeWriter aCodeWriter) {
        return this.generate((Source)new StreamSource(xsdReader), aCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Reader xsdReader, CodeWriter aCodeWriter, SchemaResolver schemaResolver) {
        return this.generate(new StreamSource(xsdReader), aCodeWriter, schemaResolver, true);
    }

    public Map generate(Reader xsdReader, CodeWriter aCodeWriter, SchemaResolver schemaResolver, boolean bProcessImports) {
        return this.generate(new StreamSource(xsdReader), aCodeWriter, schemaResolver, bProcessImports);
    }

    public Map generate(Source xsdSource, String sourceDir) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate(xsdSource, (CodeWriter)fileCodeWriter, (SchemaResolver)new DefaultSchemaResolver());
    }

    public Map generate(Source xsdSource, String sourceDir, SchemaResolver schemaResolver) {
        FileCodeWriter fileCodeWriter = new FileCodeWriter();
        fileCodeWriter.setSourceDir(sourceDir);
        return this.generate(xsdSource, (CodeWriter)fileCodeWriter, schemaResolver);
    }

    public Map generate(Source xsdSource, SchemaResolver schemaResolver) {
        return this.generate(xsdSource, (CodeWriter)new FileCodeWriter(), schemaResolver, true);
    }

    public Map generate(Source xsdSource, CodeWriter aCodeWriter) {
        return this.generate(xsdSource, aCodeWriter, (SchemaResolver)new DefaultSchemaResolver(), true);
    }

    public Map generate(Source xsdSource, CodeWriter aCodeWriter, SchemaResolver schemaResolver) {
        return this.generate(xsdSource, aCodeWriter, schemaResolver, true);
    }

    public Map generate(Source xsdSource, CodeWriter aCodeWriter, SchemaResolver schemaResolver, boolean bProcessImports) {
        SDOTypesGenerator gen = new SDOTypesGenerator(this.aHelperContext);
        List<Type> types = gen.define(xsdSource, schemaResolver, true, bProcessImports);
        return this.generate(aCodeWriter, types);
    }

    public Map generate(CodeWriter aCodeWriter, List types) {
        this.generatedBuffers = new HashMap();
        this.codeWriter = aCodeWriter;
        int i = 0;
        while (i < types.size()) {
            SDOType theType = (SDOType)types.get(i);
            if (!theType.isDataType()) {
                ClassBuffer nextBuffer = this.buildClassForType(theType);
                String packageDir = nextBuffer.getPackageName();
                packageDir = packageDir.replace('.', '/');
                if (this.interfaceGenerator) {
                    String instanceClassName = Helper.getShortClassName((String)theType.getInstanceClassName());
                    this.getCodeWriter().writeInterface(packageDir, String.valueOf(instanceClassName) + ".java", nextBuffer.getInterfaceBuffer());
                }
                if (this.implGenerator) {
                    String implClassName = Helper.getShortClassName((String)theType.getImplClassName());
                    this.getCodeWriter().writeImpl(packageDir, String.valueOf(implClassName) + ".java", nextBuffer.getClassBuffer());
                }
            }
            ++i;
        }
        return this.generatedBuffers;
    }

    private ClassBuffer buildClassForType(SDOType sdoType) {
        String upperClassName;
        ClassBuffer classBuffer = new ClassBuffer(this.sdoClassGeneratorListener);
        classBuffer.setSdoType(sdoType);
        classBuffer.setGenerateInterface(this.interfaceGenerator);
        classBuffer.setSdoTypeName(sdoType.getName());
        StringBuffer currentClassBuffer = new StringBuffer();
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplPackage(currentClassBuffer);
        }
        String packageName = null;
        int lastDotIndex = sdoType.getInstanceClassName().lastIndexOf(46);
        if (lastDotIndex > -1) {
            packageName = sdoType.getInstanceClassName().substring(0, lastDotIndex);
        }
        currentClassBuffer.append(this.indent);
        currentClassBuffer.append("package ");
        if (sdoType.getURI() != null && !sdoType.getURI().equals("")) {
            classBuffer.setUri(sdoType.getURI());
        }
        currentClassBuffer.append(packageName);
        classBuffer.setPackageName(packageName);
        currentClassBuffer.append(";").append(lsep2);
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplImports(currentClassBuffer);
        }
        currentClassBuffer.append("import ").append("org.eclipse.persistence.sdo.SDODataObject").append(";").append(lsep2);
        List documentation = (List)sdoType.get(SDOConstants.DOCUMENTATION_PROPERTY);
        if (documentation != null && documentation.size() > 0) {
            currentClassBuffer.append(this.indent);
            currentClassBuffer.append(this.buildJavaDoc(documentation));
        }
        if (this.sdoClassGeneratorListener != null) {
            this.sdoClassGeneratorListener.preImplClass(currentClassBuffer);
        }
        currentClassBuffer.append(this.indent);
        currentClassBuffer.append("public class ");
        String interfaceName = upperClassName = SDOUtil.className(sdoType.getName(), true, true, true);
        classBuffer.setInterfaceName(interfaceName);
        String fullClassName = String.valueOf(upperClassName) + "Impl";
        currentClassBuffer.append(String.valueOf(fullClassName) + " ");
        classBuffer.setClassName(fullClassName);
        String implExtends = null;
        String interfaceExtends = null;
        if (sdoType.isSubType()) {
            SDOType baseType = (SDOType)sdoType.getBaseTypes().get(0);
            if (!baseType.isDataType()) {
                interfaceExtends = baseType.getInstanceClassName();
                implExtends = baseType.getImplClassName();
            }
        } else {
            implExtends = "SDODataObject";
        }
        currentClassBuffer.append("extends ").append(implExtends);
        if (this.interfaceGenerator) {
            currentClassBuffer.append(" implements ").append(interfaceName);
        }
        classBuffer.getAttributeBuffer().append(this.buildStartAndEndPropAttribute(sdoType));
        classBuffer.getMethodBuffer().append(this.buildNoArgCtor(fullClassName));
        currentClassBuffer.append(this.indent).append(" {").append(lsep2);
        if (this.interfaceGenerator) {
            StringBuffer currentInterfaceBuffer = new StringBuffer();
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfacePackage(currentInterfaceBuffer);
            }
            currentInterfaceBuffer.append(this.indent);
            currentInterfaceBuffer.append("package ");
            currentInterfaceBuffer.append(packageName);
            currentInterfaceBuffer.append(";").append(lsep2);
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfaceImports(currentInterfaceBuffer);
            }
            if (this.sdoClassGeneratorListener != null) {
                this.sdoClassGeneratorListener.preInterfaceClass(currentInterfaceBuffer);
            }
            currentInterfaceBuffer.append(this.indent);
            currentInterfaceBuffer.append("public interface ");
            currentInterfaceBuffer.append(interfaceName);
            if (interfaceExtends != null) {
                currentInterfaceBuffer.append(" extends " + interfaceExtends);
            } else {
                currentInterfaceBuffer.append(" extends java.io.Serializable");
            }
            currentInterfaceBuffer.append(this.indent).append(" {").append(lsep2);
            classBuffer.setInterfaceBuffer(currentInterfaceBuffer);
        }
        classBuffer.setClassBuffer(currentClassBuffer);
        this.getGeneratedBuffers().put(new QName(sdoType.getURI(), sdoType.getName()), classBuffer);
        List props = sdoType.getDeclaredProperties();
        int propsSize = props.size();
        int i = 0;
        while (i < propsSize) {
            SDOProperty nextProp = (SDOProperty)props.get(i);
            this.buildGetterAndSetter(classBuffer, nextProp);
            ++i;
        }
        classBuffer.close();
        return classBuffer;
    }

    private void addJavaDocLinesToBuffer(StringBuffer javaDocBuffer, List documentationList, boolean getterSetter) {
        int i = 0;
        while (i < documentationList.size()) {
            String documentation = (String)documentationList.get(i);
            StringTokenizer stok = new StringTokenizer(documentation, lsep);
            int lineCount = 0;
            while (stok.hasMoreTokens()) {
                String nextLine = stok.nextToken().trim();
                if (nextLine.length() > 0) {
                    if (lineCount > 0 || lineCount == 0 && !getterSetter) {
                        javaDocBuffer.append(this.indent).append(" * ");
                    }
                    javaDocBuffer.append(nextLine).append(lsep);
                }
                ++lineCount;
            }
            if (i < documentationList.size() - 1) {
                javaDocBuffer.append(this.indent).append(" * ");
            }
            ++i;
        }
    }

    private StringBuffer buildJavaDoc(List documentation) {
        StringBuffer javaDocBuffer = new StringBuffer();
        javaDocBuffer.append("/**").append(lsep);
        this.addJavaDocLinesToBuffer(javaDocBuffer, documentation, false);
        javaDocBuffer.append(" */").append(lsep);
        return javaDocBuffer;
    }

    private StringBuffer buildGetterJavaDoc(List documentation, String name) {
        StringBuffer javaDocBuffer = new StringBuffer();
        javaDocBuffer.append(this.indent).append("/**").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("Gets ").append(name).append(".").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("return ");
        this.addJavaDocLinesToBuffer(javaDocBuffer, documentation, true);
        javaDocBuffer.append(this.indent).append(" */").append(lsep);
        return javaDocBuffer;
    }

    private StringBuffer buildSetterJavaDoc(List documentation, String name) {
        StringBuffer javaDocBuffer = new StringBuffer();
        javaDocBuffer.append(this.indent).append("/**").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("Sets ").append(name).append(".").append(lsep);
        javaDocBuffer.append(this.indent).append(" * ").append("param value ");
        this.addJavaDocLinesToBuffer(javaDocBuffer, documentation, true);
        javaDocBuffer.append(this.indent).append(" */").append(lsep);
        return javaDocBuffer;
    }

    private StringBuffer buildStartAndEndPropAttribute(SDOType sdoType) {
        StringBuffer attrBuffer = new StringBuffer();
        this.pushIndent();
        int declPropsSize = sdoType.getDeclaredProperties().size();
        attrBuffer.append(this.indent).append("public static final int START_PROPERTY_INDEX = ");
        if (sdoType.isSubType()) {
            String baseClassName = ((SDOType)sdoType.getBaseTypes().get(0)).getImplClassName();
            attrBuffer.append(baseClassName).append(".END_PROPERTY_INDEX");
            if (declPropsSize > 0) {
                attrBuffer.append(" + 1");
            }
            attrBuffer.append(";");
        } else if (declPropsSize > 0) {
            attrBuffer.append("0;");
        } else {
            attrBuffer.append("-1;");
        }
        attrBuffer.append(lsep2);
        int end = 0;
        end = declPropsSize > 0 ? declPropsSize - 1 : 0;
        attrBuffer.append(this.indent).append("public static final int END_PROPERTY_INDEX = START_PROPERTY_INDEX + ").append(end).append(";").append(lsep2);
        this.popIndent();
        return attrBuffer;
    }

    private StringBuffer buildNoArgCtor(String className) {
        StringBuffer ctorBuffer = new StringBuffer();
        this.pushIndent();
        ctorBuffer.append(this.indent).append("public ").append(className).append("() {}").append(lsep2);
        this.popIndent();
        return ctorBuffer;
    }

    private void buildGetterAndSetter(ClassBuffer classBuffer, SDOProperty property) {
        this.pushIndent();
        List documentation = (List)property.get(SDOConstants.DOCUMENTATION_PROPERTY);
        this.buildGetMethodBuffer(classBuffer, property, documentation);
        this.buildSetMethodBuffer(classBuffer, property, documentation);
        this.popIndent();
    }

    private void buildGetMethodBuffer(ClassBuffer classBuffer, SDOProperty property, List documentation) {
        String returnType = SDOUtil.getJavaTypeForProperty(property);
        String methodName = SDOUtil.getMethodName(property.getName(), returnType);
        if (!property.getType().isChangeSummaryType() || !methodName.equals("getChangeSummary")) {
            if (documentation != null && documentation.size() > 0) {
                classBuffer.getMethodBuffer().append(this.buildGetterJavaDoc(documentation, property.getName()));
            }
            classBuffer.getMethodBuffer().append(this.indent);
            classBuffer.getMethodBuffer().append("public ");
            classBuffer.getMethodBuffer().append(returnType).append(" ");
            classBuffer.getMethodBuffer().append(methodName);
            classBuffer.getMethodBuffer().append("() {").append(lsep);
            this.pushIndent();
            classBuffer.getMethodBuffer().append(this.indent).append("return ");
            String builtIn = SDOUtil.getBuiltInType(returnType);
            if (builtIn != null) {
                classBuffer.getMethodBuffer().append("get").append(builtIn).append("(");
                classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(property.getIndexInDeclaredProperties());
                classBuffer.getMethodBuffer().append(")");
            } else {
                if (!returnType.equals(ClassConstants.OBJECT.getName())) {
                    classBuffer.getMethodBuffer().append("(");
                    classBuffer.getMethodBuffer().append(returnType).append(")");
                }
                classBuffer.getMethodBuffer().append("get(");
                classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(property.getIndexInDeclaredProperties());
                classBuffer.getMethodBuffer().append(")");
            }
            classBuffer.getMethodBuffer().append(";").append(lsep);
            this.popIndent();
            classBuffer.getMethodBuffer().append(this.indent).append("}").append(lsep2);
        }
        if (this.interfaceGenerator) {
            classBuffer.getInterfaceBuffer().append(this.indent);
            classBuffer.getInterfaceBuffer().append("public ");
            classBuffer.getInterfaceBuffer().append(returnType).append(" ");
            classBuffer.getInterfaceBuffer().append(methodName);
            classBuffer.getInterfaceBuffer().append("();").append(lsep2);
        }
    }

    private void buildSetMethodBuffer(ClassBuffer classBuffer, SDOProperty property, List documentation) {
        if (property.getType().isChangeSummaryType()) {
            return;
        }
        if (documentation != null && documentation.size() > 0) {
            classBuffer.getMethodBuffer().append(this.buildSetterJavaDoc(documentation, property.getName()));
        }
        classBuffer.getMethodBuffer().append(this.indent);
        classBuffer.getMethodBuffer().append("public void ");
        String methodName = SDOUtil.setMethodName(property.getName());
        classBuffer.getMethodBuffer().append(methodName);
        classBuffer.getMethodBuffer().append("(");
        String paramType = SDOUtil.getJavaTypeForProperty(property);
        classBuffer.getMethodBuffer().append(paramType).append(" value");
        classBuffer.getMethodBuffer().append(")").append(" {").append(lsep);
        this.pushIndent();
        classBuffer.getMethodBuffer().append(this.indent).append("set(");
        classBuffer.getMethodBuffer().append(START_PROPERTY_INDEX).append(" + ").append(property.getIndexInDeclaredProperties());
        classBuffer.getMethodBuffer().append(" , value)");
        classBuffer.getMethodBuffer().append(";").append(lsep);
        this.popIndent();
        classBuffer.getMethodBuffer().append(this.indent).append("}");
        classBuffer.getMethodBuffer().append(lsep2);
        if (this.interfaceGenerator) {
            classBuffer.getInterfaceBuffer().append(this.indent);
            classBuffer.getInterfaceBuffer().append("public void ");
            classBuffer.getInterfaceBuffer().append(methodName);
            classBuffer.getInterfaceBuffer().append("(");
            classBuffer.getInterfaceBuffer().append(paramType).append(" value");
            classBuffer.getInterfaceBuffer().append(");").append(lsep2);
        }
    }

    private void pushIndent() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < INDENT_TAB) {
            buf.append(" ");
            ++i;
        }
        this.indent = String.valueOf(this.indent) + buf.toString();
    }

    private void popIndent() {
        StringBuffer buf = new StringBuffer();
        int size = this.indent.length() - INDENT_TAB;
        int i = 0;
        while (i < size) {
            buf.append(" ");
            ++i;
        }
        this.indent = buf.toString();
    }

    public void setGeneratedBuffers(Map generatedBuffersMap) {
        this.generatedBuffers = generatedBuffersMap;
    }

    public Map getGeneratedBuffers() {
        return this.generatedBuffers;
    }

    public void setCodeWriter(CodeWriter theCodeWriter) {
        this.codeWriter = theCodeWriter;
    }

    public CodeWriter getCodeWriter() {
        return this.codeWriter;
    }

    public void setSDOClassGeneratorListener(SDOClassGeneratorListener listener) {
        this.sdoClassGeneratorListener = listener;
    }

    public SDOClassGeneratorListener getSDOClassGeneratorListener() {
        return this.sdoClassGeneratorListener;
    }
}

