/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.dispatch;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.knox.gateway.dispatch.Dispatch;
import org.apache.knox.gateway.filter.GatewayResponse;

public abstract class AbstractGatewayDispatch
implements Dispatch {
    private static final Set<String> REQUEST_EXCLUDE_HEADERS = new HashSet<String>(Arrays.asList("Host", "Authorization", "Content-Length", "Transfer-Encoding"));
    protected HttpClient client;

    @Override
    public void init() {
    }

    protected void writeResponse(HttpServletRequest request, HttpServletResponse response, InputStream stream) throws IOException {
        if (response instanceof GatewayResponse) {
            ((GatewayResponse)response).streamResponse(stream);
        } else {
            try (ServletOutputStream output = response.getOutputStream();){
                IOUtils.copy((InputStream)stream, (OutputStream)output);
            }
        }
    }

    @Override
    public synchronized HttpClient getHttpClient() {
        return this.client;
    }

    @Override
    public synchronized void setHttpClient(HttpClient client) {
        this.client = client;
    }

    @Override
    public URI getDispatchUrl(HttpServletRequest request) {
        StringBuffer str = request.getRequestURL();
        String query = request.getQueryString();
        if (query != null) {
            str.append('?');
            str.append(query);
        }
        return URI.create(str.toString());
    }

    @Override
    public void doGet(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    @Override
    public void doPost(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException, URISyntaxException {
        response.sendError(405);
    }

    @Override
    public void doPut(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    @Override
    public void doPatch(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    @Override
    public void doDelete(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    @Override
    public void doOptions(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    @Override
    public void doHead(URI url, HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(405);
    }

    public void copyRequestHeaderFields(HttpUriRequest outboundRequest, HttpServletRequest inboundRequest) {
        Enumeration headerNames = inboundRequest.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String name = (String)headerNames.nextElement();
            if (outboundRequest.containsHeader(name) || this.getOutboundRequestExcludeHeaders().contains(name)) continue;
            String value = inboundRequest.getHeader(name);
            outboundRequest.addHeader(name, value);
        }
    }

    public Set<String> getOutboundRequestExcludeHeaders() {
        return REQUEST_EXCLUDE_HEADERS;
    }

    protected void encodeUnwiseCharacters(StringBuffer str) {
        int pipe = str.indexOf("|");
        while (pipe > -1) {
            str.replace(pipe, pipe + 1, "%7C");
            pipe = str.indexOf("|", pipe + 1);
        }
        int dq = str.indexOf("\"");
        while (dq > -1) {
            str.replace(dq, dq + 1, "%22");
            dq = str.indexOf("\"", dq + 1);
        }
        int lessThan = str.indexOf("<");
        while (lessThan > -1) {
            str.replace(lessThan, lessThan + 1, "%3C");
            lessThan = str.indexOf("<", lessThan + 1);
        }
        int greaterThan = str.indexOf(">");
        while (greaterThan > -1) {
            str.replace(greaterThan, greaterThan + 1, "%3E");
            greaterThan = str.indexOf(">", greaterThan + 1);
        }
    }
}

