/*
 * Decompiled with CFR 0.152.
 */
package org.ldaptive.concurrent;

import java.util.Collection;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.ldaptive.Connection;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.LdapException;
import org.ldaptive.Request;
import org.ldaptive.Response;
import org.ldaptive.SearchFilter;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResult;
import org.ldaptive.concurrent.AbstractParallelSearchExecutor;
import org.ldaptive.concurrent.SearchOperationWorker;
import org.ldaptive.handler.SearchEntryHandler;

public class ParallelSearchExecutor
extends AbstractParallelSearchExecutor<ConnectionFactory> {
    public ParallelSearchExecutor() {
        this(Executors.newCachedThreadPool());
    }

    public ParallelSearchExecutor(ExecutorService es) {
        super(es);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Response<SearchResult>> search(ConnectionFactory factory, SearchFilter[] filters, String[] attrs, SearchEntryHandler ... handlers) throws LdapException {
        Collection response = null;
        Connection conn = factory.getConnection();
        try {
            conn.open();
            SearchOperation op = this.createSearchOperation(conn);
            SearchOperationWorker worker = new SearchOperationWorker(op, this.getExecutorService());
            Request[] sr = new SearchRequest[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                sr[i] = ParallelSearchExecutor.newSearchRequest(this);
                if (filters[i] != null) {
                    ((SearchRequest)sr[i]).setSearchFilter(filters[i]);
                }
                if (attrs != null) {
                    ((SearchRequest)sr[i]).setReturnAttributes(attrs);
                }
                if (handlers == null) continue;
                ((SearchRequest)sr[i]).setSearchEntryHandlers(handlers);
            }
            response = worker.executeToCompletion(sr);
        }
        finally {
            conn.close();
        }
        return response;
    }
}

