/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.coord;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.Projection;
import org.jetbrains.letsPlot.commons.intern.spatial.projections.ProjectionsKt;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.coord.CoordinatesMapper;
import org.jetbrains.letsPlot.core.plot.builder.coord.CoordProvider;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u00002\u00020\u0001B+\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0014\u0010\u0007\u001a\u00020\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase;", "Lorg/jetbrains/letsPlot/core/plot/builder/coord/CoordProvider;", "xLim", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "yLim", "flipped", "", "projection", "Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "(Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;ZLorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;)V", "getFlipped", "()Z", "isLinear", "getProjection", "()Lorg/jetbrains/letsPlot/commons/intern/spatial/projections/Projection;", "adjustDomain", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "domain", "createCoordinateMapper", "Lorg/jetbrains/letsPlot/core/plot/base/coord/CoordinatesMapper;", "adjustedDomain", "clientSize", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nCoordProviderBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CoordProviderBase.kt\norg/jetbrains/letsPlot/core/plot/builder/coord/CoordProviderBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,61:1\n1#2:62\n*E\n"})
public abstract class CoordProviderBase
implements CoordProvider {
    @Nullable
    private final DoubleSpan xLim;
    @Nullable
    private final DoubleSpan yLim;
    private final boolean flipped;
    @NotNull
    private final Projection projection;
    private final boolean isLinear;

    public CoordProviderBase(@Nullable DoubleSpan xLim, @Nullable DoubleSpan yLim, boolean flipped, @NotNull Projection projection) {
        Intrinsics.checkNotNullParameter((Object)projection, (String)"projection");
        this.xLim = xLim;
        this.yLim = yLim;
        this.flipped = flipped;
        this.projection = projection;
        if (!(this.xLim == null || this.xLim.getLength() > 0.0)) {
            boolean $i$a$-require-CoordProviderBase$32 = false;
            String $i$a$-require-CoordProviderBase$32 = "Coord x-limits range should be > 0.0";
            throw new IllegalArgumentException($i$a$-require-CoordProviderBase$32.toString());
        }
        if (!(this.yLim == null || this.yLim.getLength() > 0.0)) {
            boolean bl = false;
            String string = "Coord y-limits range should be > 0.0";
            throw new IllegalArgumentException(string.toString());
        }
        this.isLinear = !this.projection.getNonlinear();
    }

    public /* synthetic */ CoordProviderBase(DoubleSpan doubleSpan, DoubleSpan doubleSpan2, boolean bl, Projection projection, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            projection = ProjectionsKt.identity();
        }
        this(doubleSpan, doubleSpan2, bl, projection);
    }

    @Override
    public boolean getFlipped() {
        return this.flipped;
    }

    @NotNull
    protected final Projection getProjection() {
        return this.projection;
    }

    @Override
    public boolean isLinear() {
        return this.isLinear;
    }

    @Override
    @NotNull
    public DoubleRectangle adjustDomain(@NotNull DoubleRectangle domain) {
        DoubleSpan doubleSpan;
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        DoubleRectangle it = domain;
        boolean bl = false;
        DoubleSpan doubleSpan2 = this.xLim;
        if (doubleSpan2 == null) {
            doubleSpan2 = domain.xRange();
        }
        if ((doubleSpan = this.yLim) == null) {
            doubleSpan = domain.yRange();
        }
        DoubleRectangle withLims = new DoubleRectangle(doubleSpan2, doubleSpan);
        DoubleRectangle validDomain = this.projection.validDomain().intersect(withLims);
        if (validDomain != null && validDomain.getHeight() > 0.0 && validDomain.getWidth() > 0.0) {
        } else {
            throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("Can't create a valid domain.\n                |  data bbox: " + domain + "\n                |  x-lim: " + this.xLim + "\n                |  y-lim: " + this.yLim + "\n            "), null, (int)1, null));
        }
        return this.getFlipped() ? validDomain.flip() : validDomain;
    }

    @Override
    @NotNull
    public CoordinatesMapper createCoordinateMapper(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        Intrinsics.checkNotNullParameter((Object)adjustedDomain, (String)"adjustedDomain");
        Intrinsics.checkNotNullParameter((Object)clientSize, (String)"clientSize");
        return CoordinatesMapper.Companion.create(adjustedDomain, clientSize, this.projection, this.getFlipped());
    }

    @Override
    @NotNull
    public CoordinateSystem createCoordinateSystem(@NotNull DoubleRectangle adjustedDomain, @NotNull DoubleVector clientSize) {
        return CoordProvider.DefaultImpls.createCoordinateSystem(this, adjustedDomain, clientSize);
    }
}

