/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.assemble;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.values.Color;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsBuilder;
import org.jetbrains.letsPlot.core.plot.base.aes.AestheticsDefaults;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendDirection;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendPosition;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J`\u0010\u0007\u001a\u00020\b2\u001c\u0010\t\u001a\u0018\u0012\u0014\u0012\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u00010\u000b0\n2\u0016\u0010\r\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f\u0012\u0004\u0012\u00020\u00010\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\f2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00110\fJN\u0010\u0007\u001a\u00020\b\"\u0004\b\u0000\u0010\u00132\u001e\u0010\u0014\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00150\u000b2\u0018\u0010\r\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\f\u0012\u0004\u0012\u0002H\u00130\u000b2\u0006\u0010\u000e\u001a\u00020\u000f\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/assemble/LegendAssemblerUtil;", "", "()V", "legendDirection", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendDirection;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "mapToAesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "valueByAesIterable", "", "", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "constantByAes", "aestheticsDefaults", "Lorg/jetbrains/letsPlot/core/plot/base/aes/AestheticsDefaults;", "colorByAes", "Lorg/jetbrains/letsPlot/commons/values/Color;", "fillByAes", "T", "valuesByAes", "", "plot-builder"})
public final class LegendAssemblerUtil {
    @NotNull
    public static final LegendAssemblerUtil INSTANCE = new LegendAssemblerUtil();

    private LegendAssemblerUtil() {
    }

    @NotNull
    public final <T> Aesthetics mapToAesthetics(@NotNull Map<Aes<T>, ? extends List<? extends T>> valuesByAes, @NotNull Map<Aes<T>, ? extends T> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults) {
        Intrinsics.checkNotNullParameter(valuesByAes, (String)"valuesByAes");
        Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
        Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
        AestheticsBuilder builder = new AestheticsBuilder(0);
        for (Aes aes : Aes.Companion.values()) {
            Intrinsics.checkNotNull((Object)aes, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.Aes<kotlin.Any>");
            builder.constantAes(aes, aestheticsDefaults.defaultValue(aes));
        }
        for (Aes aes : valuesByAes.keySet()) {
            List values = (List)MapsKt.getValue(valuesByAes, (Object)aes);
            builder.aes(aes, AestheticsBuilder.Companion.list(values));
            builder.dataPointCount(values.size());
        }
        for (Aes aes : constantByAes.keySet()) {
            T t = constantByAes.get(aes);
            Intrinsics.checkNotNull(t);
            builder.constantAes(aes, t);
        }
        return builder.build();
    }

    @NotNull
    public final Aesthetics mapToAesthetics(@NotNull Collection<? extends Map<Aes<?>, ? extends Object>> valueByAesIterable, @NotNull Map<Aes<?>, ? extends Object> constantByAes, @NotNull AestheticsDefaults aestheticsDefaults, @NotNull Aes<Color> colorByAes, @NotNull Aes<Color> fillByAes) {
        Intrinsics.checkNotNullParameter(valueByAesIterable, (String)"valueByAesIterable");
        Intrinsics.checkNotNullParameter(constantByAes, (String)"constantByAes");
        Intrinsics.checkNotNullParameter((Object)aestheticsDefaults, (String)"aestheticsDefaults");
        Intrinsics.checkNotNullParameter(colorByAes, (String)"colorByAes");
        Intrinsics.checkNotNullParameter(fillByAes, (String)"fillByAes");
        ArrayList dataPoints = new ArrayList();
        for (Map<Aes<?>, Object> valueByAes : valueByAesIterable) {
            Object[] objectArray;
            HashMap dataPoint = new HashMap();
            for (Aes aes : Aes.Companion.values()) {
                Map map2 = dataPoint;
                Object object = aestheticsDefaults.defaultValueInLegend(aes);
                Intrinsics.checkNotNull((Object)object);
                map2.put(aes, object);
                objectArray = new Aes[]{Aes.Companion.getPAINT_A(), Aes.Companion.getPAINT_B(), Aes.Companion.getPAINT_C()};
                if (!CollectionsKt.contains((Iterable)CollectionsKt.listOf((Object[])objectArray), (Object)aes)) continue;
                Aes aes2 = aes;
                Aes baseAes = Intrinsics.areEqual((Object)aes2, colorByAes) ? Aes.Companion.getCOLOR() : (Intrinsics.areEqual((Object)aes2, fillByAes) ? Aes.Companion.getFILL() : aes);
                Map map3 = dataPoint;
                Object object2 = aestheticsDefaults.defaultValueInLegend(baseAes);
                Intrinsics.checkNotNull((Object)object2);
                map3.put(aes, object2);
            }
            for (Object[] objectArray2 : constantByAes.keySet()) {
                objectArray = objectArray2;
                if (!(((((Intrinsics.areEqual((Object)objectArray, (Object)Aes.Companion.getSHAPE()) ? true : Intrinsics.areEqual((Object)objectArray, (Object)Aes.Companion.getCOLOR())) ? true : Intrinsics.areEqual((Object)objectArray, (Object)Aes.Companion.getFILL())) ? true : Intrinsics.areEqual((Object)objectArray, (Object)Aes.Companion.getPAINT_A())) ? true : Intrinsics.areEqual((Object)objectArray, (Object)Aes.Companion.getPAINT_B())) ? true : Intrinsics.areEqual((Object)objectArray, (Object)Aes.Companion.getPAINT_C()))) continue;
                Map map4 = dataPoint;
                Object object = constantByAes.get(objectArray2);
                Intrinsics.checkNotNull((Object)object);
                map4.put(objectArray2, object);
            }
            for (Aes aes : valueByAes.keySet()) {
                Map map5 = dataPoint;
                Object object = valueByAes.get(aes);
                Intrinsics.checkNotNull((Object)object);
                map5.put(aes, object);
            }
            dataPoints.add(dataPoint);
        }
        AestheticsBuilder builder = new AestheticsBuilder(dataPoints.size());
        for (Aes aes : Aes.Companion.values()) {
            Intrinsics.checkNotNull((Object)aes, (String)"null cannot be cast to non-null type org.jetbrains.letsPlot.core.plot.base.Aes<kotlin.Any>");
            builder.aes(aes, (Function1)new Function1<Integer, Object>(dataPoints, aes){
                final /* synthetic */ ArrayList<Map<Aes<?>, Object>> $dataPoints;
                final /* synthetic */ Aes<?> $aes;
                {
                    this.$dataPoints = $dataPoints;
                    this.$aes = $aes;
                    super(1);
                }

                @Nullable
                public final Object invoke(int index) {
                    Object object = this.$dataPoints.get(index).get(this.$aes);
                    Intrinsics.checkNotNull((Object)object);
                    return object;
                }
            });
        }
        builder.colorAes(colorByAes).fillAes(fillByAes);
        return builder.build();
    }

    @NotNull
    public final LegendDirection legendDirection(@NotNull LegendTheme theme) {
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        LegendDirection legendDirection = theme.direction();
        if (legendDirection == LegendDirection.AUTO) {
            LegendPosition legendPosition = theme.position();
            legendDirection = legendPosition == LegendPosition.Companion.getTOP() || legendPosition == LegendPosition.Companion.getBOTTOM() ? LegendDirection.HORIZONTAL : LegendDirection.VERTICAL;
        }
        return legendDirection;
    }
}

