/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.timers;

import org.apache.jmeter.gui.GUIMenuSortOrder;
import org.apache.jmeter.gui.TestElementMetadata;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.util.BeanShellInterpreter;
import org.apache.jmeter.util.BeanShellTestElement;
import org.apache.jorphan.util.JMeterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GUIMenuSortOrder(value=0x7FFFFFFF)
@TestElementMetadata(labelResource="displayName")
public class BeanShellTimer
extends BeanShellTestElement
implements Cloneable,
Timer,
TestBean {
    private static final Logger log = LoggerFactory.getLogger(BeanShellTimer.class);
    private static final long serialVersionUID = 5L;
    private static final String INIT_FILE = "beanshell.timer.init";

    protected String getInitFileProperty() {
        return INIT_FILE;
    }

    public long delay() {
        String ret;
        block6: {
            ret = "0";
            BeanShellInterpreter bshInterpreter = this.getBeanShellInterpreter();
            if (bshInterpreter == null) {
                log.error("BeanShell not found");
                return 0L;
            }
            try {
                Object o = this.processFileOrScript(bshInterpreter);
                if (o != null) {
                    ret = o.toString();
                }
            }
            catch (JMeterException e) {
                if (!log.isWarnEnabled()) break block6;
                log.warn("Problem in BeanShell script. {}", (Object)e.toString());
            }
        }
        try {
            return Long.decode(ret);
        }
        catch (NumberFormatException e) {
            log.warn("Number format exception while decoding number: '{}'", (Object)ret);
            return 0L;
        }
    }

    public Object clone() {
        return super.clone();
    }
}

