/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.report.processor.graph.impl;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import org.apache.jmeter.report.core.Sample;
import org.apache.jmeter.report.processor.TimeRateAggregatorFactory;
import org.apache.jmeter.report.processor.graph.AbstractOverTimeGraphConsumer;
import org.apache.jmeter.report.processor.graph.AbstractSeriesSelector;
import org.apache.jmeter.report.processor.graph.CountValueSelector;
import org.apache.jmeter.report.processor.graph.GroupInfo;
import org.apache.jmeter.report.processor.graph.TimeStampKeysSelector;

public class TransactionsPerSecondGraphConsumer
extends AbstractOverTimeGraphConsumer {
    private static final String SUCCESS_SERIES_SUFFIX = "success";
    private static final String FAILURE_SERIES_SUFFIX = "failure";

    @Override
    protected TimeStampKeysSelector createTimeStampKeysSelector() {
        TimeStampKeysSelector keysSelector = new TimeStampKeysSelector();
        keysSelector.setSelectBeginTime(false);
        return keysSelector;
    }

    @Override
    protected Map<String, GroupInfo> createGroupInfos() {
        AbstractSeriesSelector seriesSelector = new AbstractSeriesSelector(true){

            @Override
            public Iterable<String> select(Sample sample) {
                String success = sample.getSuccess() ? TransactionsPerSecondGraphConsumer.SUCCESS_SERIES_SUFFIX : TransactionsPerSecondGraphConsumer.FAILURE_SERIES_SUFFIX;
                String label = sample.getName() + "-" + success;
                return Arrays.asList(label);
            }
        };
        return Collections.singletonMap("Generic group", new GroupInfo(new TimeRateAggregatorFactory(), seriesSelector, new CountValueSelector(false), false, false));
    }

    @Override
    public void initialize() {
        super.initialize();
        ((TimeRateAggregatorFactory)this.getGroupInfos().get("Generic group").getAggregatorFactory()).setGranularity(this.getGranularity());
    }
}

