/*
 * Decompiled with CFR 0.152.
 */
package com.helger.css;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.CheckForSigned;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
public class CSSSourceArea {
    private final int m_nBeginLineNumber;
    private final int m_nBeginColumnNumber;
    private final int m_nEndLineNumber;
    private final int m_nEndColumnNumber;

    public CSSSourceArea(int n, int n2, int n3, int n4) {
        this.m_nBeginLineNumber = n;
        this.m_nBeginColumnNumber = n2;
        this.m_nEndLineNumber = n3;
        this.m_nEndColumnNumber = n4;
    }

    @CheckForSigned
    public int getTokenBeginLineNumber() {
        return this.m_nBeginLineNumber;
    }

    @CheckForSigned
    public int getTokenBeginColumnNumber() {
        return this.m_nBeginColumnNumber;
    }

    @CheckForSigned
    public int getTokenEndLineNumber() {
        return this.m_nEndLineNumber;
    }

    @CheckForSigned
    public int getTokenEndColumnNumber() {
        return this.m_nEndColumnNumber;
    }

    @Nonnull
    @Nonempty
    public String getTokenLocationAsString() {
        if (this.m_nBeginLineNumber == this.m_nEndLineNumber && this.m_nBeginColumnNumber == this.m_nEndColumnNumber) {
            return "(" + this.m_nBeginLineNumber + ":" + this.m_nBeginColumnNumber + ")";
        }
        return "(" + this.m_nBeginLineNumber + ":" + this.m_nBeginColumnNumber + "/" + this.m_nEndLineNumber + ":" + this.m_nEndColumnNumber + ")";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        CSSSourceArea cSSSourceArea = (CSSSourceArea)object;
        return this.m_nBeginLineNumber == cSSSourceArea.m_nBeginLineNumber && this.m_nBeginColumnNumber == cSSSourceArea.m_nBeginColumnNumber && this.m_nEndLineNumber == cSSSourceArea.m_nEndLineNumber && this.m_nEndColumnNumber == cSSSourceArea.m_nEndColumnNumber;
    }

    public int hashCode() {
        return new HashCodeGenerator((Object)this).append(this.m_nBeginLineNumber).append(this.m_nBeginColumnNumber).append(this.m_nEndLineNumber).append(this.m_nEndColumnNumber).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("beginLine", this.m_nBeginLineNumber).append("beginColumn", this.m_nBeginColumnNumber).append("endLine", this.m_nEndLineNumber).append("endColumn", this.m_nEndColumnNumber).getToString();
    }
}

