/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.asn1;

import com.unboundid.asn1.ASN1Element;
import com.unboundid.asn1.ASN1Exception;
import com.unboundid.asn1.ASN1Messages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.NotNull;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class ASN1UTCTime
extends ASN1Element {
    @NotNull
    private static final ThreadLocal<SimpleDateFormat> DATE_FORMATTERS = new ThreadLocal();
    private static final long serialVersionUID = -3107099228691194285L;
    private final long time;
    @NotNull
    private final String stringRepresentation;

    public ASN1UTCTime() {
        this(23);
    }

    public ASN1UTCTime(byte type) {
        this(type, System.currentTimeMillis());
    }

    public ASN1UTCTime(@NotNull Date date) {
        this(23, date.getTime());
    }

    public ASN1UTCTime(byte type, @NotNull Date date) {
        this(type, date.getTime());
    }

    public ASN1UTCTime(long time) {
        this(23, time);
    }

    public ASN1UTCTime(byte type, long time) {
        super(type, StaticUtils.getBytes(ASN1UTCTime.encodeTimestamp(time)));
        GregorianCalendar calendar = new GregorianCalendar(StaticUtils.getUTCTimeZone());
        calendar.setTimeInMillis(time);
        calendar.set(14, 0);
        this.time = calendar.getTimeInMillis();
        this.stringRepresentation = ASN1UTCTime.encodeTimestamp(time);
    }

    public ASN1UTCTime(@NotNull String timestamp) throws ASN1Exception {
        this(23, timestamp);
    }

    public ASN1UTCTime(byte type, @NotNull String timestamp) throws ASN1Exception {
        super(type, StaticUtils.getBytes(timestamp));
        this.time = ASN1UTCTime.decodeTimestamp(timestamp);
        this.stringRepresentation = timestamp;
    }

    @NotNull
    public static String encodeTimestamp(@NotNull Date date) {
        return ASN1UTCTime.getDateFormatter().format(date);
    }

    @NotNull
    private static SimpleDateFormat getDateFormatter() {
        SimpleDateFormat existingFormatter = DATE_FORMATTERS.get();
        if (existingFormatter != null) {
            return existingFormatter;
        }
        SimpleDateFormat newFormatter = new SimpleDateFormat("yyMMddHHmmss'Z'");
        newFormatter.setTimeZone(StaticUtils.getUTCTimeZone());
        newFormatter.setLenient(false);
        DATE_FORMATTERS.set(newFormatter);
        return newFormatter;
    }

    @NotNull
    public static String encodeTimestamp(long time) {
        return ASN1UTCTime.encodeTimestamp(new Date(time));
    }

    public static long decodeTimestamp(@NotNull String timestamp) throws ASN1Exception {
        if (timestamp.length() != 13) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_LENGTH.get());
        }
        if (!timestamp.endsWith("Z") && !timestamp.endsWith("z")) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_DOES_NOT_END_WITH_Z.get());
        }
        for (int i = 0; i < timestamp.length() - 1; ++i) {
            char c = timestamp.charAt(i);
            if (c >= '0' && c <= '9') continue;
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_CHAR_NOT_DIGIT.get(i + 1));
        }
        int month = Integer.parseInt(timestamp.substring(2, 4));
        if (month < 1 || month > 12) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_MONTH.get());
        }
        int day = Integer.parseInt(timestamp.substring(4, 6));
        if (day < 1 || day > 31) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_DAY.get());
        }
        int hour = Integer.parseInt(timestamp.substring(6, 8));
        if (hour > 23) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_HOUR.get());
        }
        int minute = Integer.parseInt(timestamp.substring(8, 10));
        if (minute > 59) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_MINUTE.get());
        }
        int second = Integer.parseInt(timestamp.substring(10, 12));
        if (second > 60) {
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_INVALID_SECOND.get());
        }
        try {
            return ASN1UTCTime.getDateFormatter().parse(timestamp).getTime();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ASN1Exception(ASN1Messages.ERR_UTC_TIME_STRING_CANNOT_PARSE.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    public long getTime() {
        return this.time;
    }

    @NotNull
    public Date getDate() {
        return new Date(this.time);
    }

    @NotNull
    public String getStringRepresentation() {
        return this.stringRepresentation;
    }

    @NotNull
    public static ASN1UTCTime decodeAsUTCTime(@NotNull byte[] elementBytes) throws ASN1Exception {
        try {
            int valueStartPos = 2;
            int length = elementBytes[1] & 0x7F;
            if (length != elementBytes[1]) {
                int numLengthBytes = length;
                length = 0;
                for (int i = 0; i < numLengthBytes; ++i) {
                    length <<= 8;
                    length |= elementBytes[valueStartPos++] & 0xFF;
                }
            }
            if (elementBytes.length - valueStartPos != length) {
                throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_LENGTH_MISMATCH.get(length, elementBytes.length - valueStartPos));
            }
            byte[] elementValue = new byte[length];
            System.arraycopy(elementBytes, valueStartPos, elementValue, 0, length);
            return new ASN1UTCTime(elementBytes[0], StaticUtils.toUTF8String(elementValue));
        }
        catch (ASN1Exception ae) {
            Debug.debugException(ae);
            throw ae;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new ASN1Exception(ASN1Messages.ERR_ELEMENT_DECODE_EXCEPTION.get(e), e);
        }
    }

    @NotNull
    public static ASN1UTCTime decodeAsUTCTime(@NotNull ASN1Element element) throws ASN1Exception {
        return new ASN1UTCTime(element.getType(), StaticUtils.toUTF8String(element.getValue()));
    }

    @Override
    public void toString(@NotNull StringBuilder buffer) {
        buffer.append(this.stringRepresentation);
    }
}

