<!--
   Licensed to the Apache Software Foundation (ASF) under one or more
   contributor license agreements.  See the NOTICE file distributed with
   this work for additional information regarding copyright ownership.
   The ASF licenses this file to You under the Apache License, Version 2.0
   (the "License"); you may not use this file except in compliance with
   the License.  You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
  -->

Security Reports
--------------------------------------------------------------------------------

### Security Updates

Please note that binary patches are not produced for individual vulnerabilities. To obtain the fix for a particular 
vulnerability you should upgrade to the officially released version where that vulnerability has been fixed.

#### List of Vulnerabilities

Note: the vulnerability reports linked below will provide additional details including reference to the public 
announcement and a short description.

| CVE Number    | Type                                             | Fix Versions                                                    |
|---------------|--------------------------------------------------|-----------------------------------------------------------------|
|[CVE-2020-1940]| Sensitive information disclosure vulnerability   | 1.24.0, 1.10.8, 1.8.20, 1.6.20, 1.4.26, patch for 1.2 see [OAK-8870] |
| | |

### Reporting Vulnerabilities with Apache Jackrabbit Oak

The Apache Software Foundation takes an active stance in eliminating security problems. We strongly encourage everyone 
to report vulnerabilities to the Apache security mailing list _security(at)apache.org_, before disclosing them in a public forum.

Please note that the security mailing list should only be used for reporting undisclosed vulnerabilities and 
managing the process of fixing them. We cannot accept regular bug reports or other queries at this address. If you wish 
to report a bug that isn't an undisclosed security vulnerability, please use [https://issues.apache.org/jira/projects/OAK/issues](https://issues.apache.org/jira/projects/OAK/issues).

###Errors and Omissions

Please report any errors or omissions to _security(at)apache.org_.


<!-- hidden references -->
[CVE-2020-1940]: https://cve.mitre.org/cgi-bin/cvename.cgi?name=CVE-2020-1940
[OAK-8870]: https://issues.apache.org/jira/browse/OAK-8870?focusedCommentId=17025637&page=com.atlassian.jira.plugin.system.issuetabpanels%3Acomment-tabpanel#comment-17025637