/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DiagnosticInfo;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.ContentFilterElementResult;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ContentFilterResult
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=607");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=609");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=608");
    private final ContentFilterElementResult[] elementResults;
    private final DiagnosticInfo[] elementDiagnosticInfos;

    public ContentFilterResult(ContentFilterElementResult[] elementResults, DiagnosticInfo[] elementDiagnosticInfos) {
        this.elementResults = elementResults;
        this.elementDiagnosticInfos = elementDiagnosticInfos;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public ContentFilterElementResult[] getElementResults() {
        return this.elementResults;
    }

    public DiagnosticInfo[] getElementDiagnosticInfos() {
        return this.elementDiagnosticInfos;
    }

    protected ContentFilterResult(ContentFilterResultBuilder<?, ?> b) {
        super(b);
        this.elementResults = ((ContentFilterResultBuilder)b).elementResults;
        this.elementDiagnosticInfos = ((ContentFilterResultBuilder)b).elementDiagnosticInfos;
    }

    public static ContentFilterResultBuilder<?, ?> builder() {
        return new ContentFilterResultBuilderImpl();
    }

    public ContentFilterResultBuilder<?, ?> toBuilder() {
        return new ContentFilterResultBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContentFilterResult)) {
            return false;
        }
        ContentFilterResult other = (ContentFilterResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getElementResults(), other.getElementResults())) {
            return false;
        }
        return Arrays.deepEquals(this.getElementDiagnosticInfos(), other.getElementDiagnosticInfos());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContentFilterResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getElementResults());
        result = result * 59 + Arrays.deepHashCode(this.getElementDiagnosticInfos());
        return result;
    }

    @Override
    public String toString() {
        return "ContentFilterResult(elementResults=" + Arrays.deepToString(this.getElementResults()) + ", elementDiagnosticInfos=" + Arrays.deepToString(this.getElementDiagnosticInfos()) + ")";
    }

    private static final class ContentFilterResultBuilderImpl
    extends ContentFilterResultBuilder<ContentFilterResult, ContentFilterResultBuilderImpl> {
        private ContentFilterResultBuilderImpl() {
        }

        @Override
        protected ContentFilterResultBuilderImpl self() {
            return this;
        }

        @Override
        public ContentFilterResult build() {
            return new ContentFilterResult(this);
        }
    }

    public static abstract class ContentFilterResultBuilder<C extends ContentFilterResult, B extends ContentFilterResultBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private ContentFilterElementResult[] elementResults;
        private DiagnosticInfo[] elementDiagnosticInfos;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ContentFilterResultBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ContentFilterResult instance, ContentFilterResultBuilder<?, ?> b) {
            b.elementResults(instance.elementResults);
            b.elementDiagnosticInfos(instance.elementDiagnosticInfos);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B elementResults(ContentFilterElementResult[] elementResults) {
            this.elementResults = elementResults;
            return (B)this.self();
        }

        public B elementDiagnosticInfos(DiagnosticInfo[] elementDiagnosticInfos) {
            this.elementDiagnosticInfos = elementDiagnosticInfos;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ContentFilterResult.ContentFilterResultBuilder(super=" + super.toString() + ", elementResults=" + Arrays.deepToString(this.elementResults) + ", elementDiagnosticInfos=" + Arrays.deepToString(this.elementDiagnosticInfos) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ContentFilterResult> {
        @Override
        public Class<ContentFilterResult> getType() {
            return ContentFilterResult.class;
        }

        @Override
        public ContentFilterResult decode(SerializationContext context, UaDecoder decoder) {
            ContentFilterElementResult[] elementResults = (ContentFilterElementResult[])decoder.readStructArray("ElementResults", ContentFilterElementResult.TYPE_ID);
            DiagnosticInfo[] elementDiagnosticInfos = decoder.readDiagnosticInfoArray("ElementDiagnosticInfos");
            return new ContentFilterResult(elementResults, elementDiagnosticInfos);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ContentFilterResult value) {
            encoder.writeStructArray("ElementResults", (Object[])value.getElementResults(), ContentFilterElementResult.TYPE_ID);
            encoder.writeDiagnosticInfoArray("ElementDiagnosticInfos", value.getElementDiagnosticInfos());
        }
    }
}

