/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.channel;

import java.util.concurrent.ExecutorService;
import org.eclipse.milo.opcua.stack.core.channel.ChannelParameters;
import org.eclipse.milo.opcua.stack.core.channel.ChunkDecoder;
import org.eclipse.milo.opcua.stack.core.channel.ChunkEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.OpcUaBinaryStreamEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.util.TaskQueue;

public class SerializationQueue {
    private static final int MAX_QUEUE_SIZE = Integer.getInteger("milo.stack.serialization.maxQueueSize", 256);
    private final OpcUaBinaryStreamEncoder binaryEncoder;
    private final OpcUaBinaryStreamDecoder binaryDecoder;
    private final ChunkEncoder chunkEncoder;
    private final ChunkDecoder chunkDecoder;
    private final TaskQueue encodingQueue;
    private final TaskQueue decodingQueue;
    private final ChannelParameters parameters;

    public SerializationQueue(ExecutorService executor, ChannelParameters parameters, SerializationContext context) {
        this.parameters = parameters;
        this.chunkEncoder = new ChunkEncoder(parameters);
        this.chunkDecoder = new ChunkDecoder(parameters, context.getEncodingLimits());
        this.binaryEncoder = new OpcUaBinaryStreamEncoder(context);
        this.binaryDecoder = new OpcUaBinaryStreamDecoder(context);
        this.encodingQueue = new TaskQueue(executor);
        this.decodingQueue = TaskQueue.newBuilder().setExecutor(executor).setMaxQueueSize(MAX_QUEUE_SIZE).build();
    }

    public boolean encode(Encoder encoder) {
        return this.encodingQueue.execute(() -> encoder.encode(this.binaryEncoder, this.chunkEncoder));
    }

    public boolean decode(Decoder decoder) {
        return this.decodingQueue.execute(() -> decoder.decode(this.binaryDecoder, this.chunkDecoder));
    }

    public void pause() {
        this.encodingQueue.pause();
        this.decodingQueue.pause();
    }

    public ChannelParameters getParameters() {
        return this.parameters;
    }

    @FunctionalInterface
    public static interface Encoder {
        public void encode(OpcUaBinaryStreamEncoder var1, ChunkEncoder var2);
    }

    @FunctionalInterface
    public static interface Decoder {
        public void decode(OpcUaBinaryStreamDecoder var1, ChunkDecoder var2);
    }
}

