/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.basic;

import java.util.ArrayList;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.schema.node.IMNode;
import org.apache.iotdb.commons.schema.node.MNodeType;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.commons.schema.node.role.IDeviceMNode;
import org.apache.iotdb.commons.schema.node.role.IInternalMNode;
import org.apache.iotdb.commons.schema.node.role.IMeasurementMNode;
import org.apache.iotdb.commons.schema.node.utils.IMNodeContainer;
import org.apache.iotdb.commons.schema.node.visitor.MNodeVisitor;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.IMemMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.container.MemMNodeContainer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.mem.mnode.info.BasicMNodeInfo;

public class BasicMNode
implements IMemMNode {
    private static final long serialVersionUID = -770028375899514063L;
    private IMemMNode parent;
    private final BasicMNodeInfo basicMNodeInfo;
    private String fullPath;

    public BasicMNode(IMemMNode parent, String name) {
        this.parent = parent;
        this.basicMNodeInfo = new BasicMNodeInfo(name);
    }

    public String getName() {
        return this.basicMNodeInfo.getName();
    }

    public void setName(String name) {
        this.basicMNodeInfo.setName(name);
    }

    public IMemMNode getParent() {
        return this.parent;
    }

    public void setParent(IMemMNode parent) {
        this.parent = parent;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            this.fullPath = this.concatFullPath();
        }
        return this.fullPath;
    }

    String concatFullPath() {
        StringBuilder builder = new StringBuilder(this.getName());
        IMemMNode curr = this;
        while (curr.getParent() != null) {
            curr = (IMemMNode)curr.getParent();
            builder.insert(0, '.').insert(0, curr.getName());
        }
        return builder.toString();
    }

    public void setFullPath(String fullPath) {
        this.fullPath = fullPath;
    }

    public PartialPath getPartialPath() {
        ArrayList<String> detachedPath = new ArrayList<String>();
        IMemMNode temp = this;
        detachedPath.add(temp.getName());
        while (temp.getParent() != null) {
            temp = (IMemMNode)temp.getParent();
            detachedPath.add(0, temp.getName());
        }
        return new PartialPath(detachedPath.toArray(new String[0]));
    }

    public boolean hasChild(String name) {
        return false;
    }

    public IMemMNode getChild(String name) {
        return null;
    }

    public IMemMNode addChild(String name, IMemMNode child) {
        return null;
    }

    public IMemMNode addChild(IMemMNode child) {
        return null;
    }

    public IMemMNode deleteChild(String name) {
        return null;
    }

    public IMNodeContainer<IMemMNode> getChildren() {
        return MemMNodeContainer.emptyMNodeContainer();
    }

    public void setChildren(IMNodeContainer<IMemMNode> children) {
    }

    public boolean isAboveDatabase() {
        return false;
    }

    public boolean isDatabase() {
        return false;
    }

    public boolean isDevice() {
        return false;
    }

    public boolean isMeasurement() {
        return false;
    }

    public MNodeType getMNodeType() {
        return MNodeType.UNIMPLEMENT;
    }

    public IDatabaseMNode<IMemMNode> getAsDatabaseMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public IDeviceMNode<IMemMNode> getAsDeviceMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public IInternalMNode<IMemMNode> getAsInternalMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public IMeasurementMNode<IMemMNode> getAsMeasurementMNode() {
        throw new UnsupportedOperationException("Wrong MNode Type");
    }

    public <R, C> R accept(MNodeVisitor<R, C> visitor, C context) {
        return (R)visitor.visitBasicMNode((IMNode)this, context);
    }

    public int estimateSize() {
        return 76 + this.basicMNodeInfo.estimateSize();
    }

    public IMemMNode getAsMNode() {
        return this;
    }
}

