/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections4.bloomfilter;

import java.util.Objects;
import java.util.function.IntPredicate;
import org.apache.commons.collections4.bloomfilter.BitMaps;
import org.apache.commons.collections4.bloomfilter.Hasher;
import org.apache.commons.collections4.bloomfilter.IndexExtractor;
import org.apache.commons.collections4.bloomfilter.Shape;

public class EnhancedDoubleHasher
implements Hasher {
    private final long initial;
    private final long increment;

    private static long toLong(byte[] byteArray, int offset, int len) {
        long val = 0L;
        int shift = 64;
        int end = offset + Math.min(len, 8);
        for (int i = offset; i < end; ++i) {
            val |= (long)(byteArray[i] & 0xFF) << (shift -= 8);
        }
        return val;
    }

    public EnhancedDoubleHasher(byte[] buffer) {
        if (buffer.length == 0) {
            throw new IllegalArgumentException("buffer length must be greater than 0");
        }
        int segment = buffer.length / 2;
        this.initial = EnhancedDoubleHasher.toLong(buffer, 0, segment);
        this.increment = EnhancedDoubleHasher.toLong(buffer, segment, buffer.length - segment);
    }

    public EnhancedDoubleHasher(long initial, long increment) {
        this.initial = initial;
        this.increment = increment;
    }

    long getIncrement() {
        return this.increment;
    }

    long getInitial() {
        return this.initial;
    }

    @Override
    public IndexExtractor indices(final Shape shape) {
        Objects.requireNonNull(shape, "shape");
        return new IndexExtractor(){
            final /* synthetic */ EnhancedDoubleHasher this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public int[] asIndexArray() {
                int[] result = new int[shape.getNumberOfHashFunctions()];
                int[] idx = new int[1];
                this.processIndices(i -> {
                    int n = idx[0];
                    idx[0] = n + 1;
                    result[n] = i;
                    return true;
                });
                return result;
            }

            @Override
            public boolean processIndices(IntPredicate consumer) {
                Objects.requireNonNull(consumer, "consumer");
                int bits = shape.getNumberOfBits();
                int index = BitMaps.mod(this.this$0.initial, bits);
                if (!consumer.test(index)) {
                    return false;
                }
                int inc = BitMaps.mod(this.this$0.increment, bits);
                int k = shape.getNumberOfHashFunctions();
                if (k >= bits) {
                    int tet = 1;
                    for (int i = 1; i < k; ++i) {
                        int n = index = (index -= inc) < 0 ? index + bits : index;
                        if (!consumer.test(index)) {
                            return false;
                        }
                        int n2 = inc = (inc -= tet) < 0 ? inc + bits : inc;
                        if (++tet != bits) continue;
                        tet = 0;
                    }
                } else {
                    for (int i = 1; i < k; ++i) {
                        int n = index = (index -= inc) < 0 ? index + bits : index;
                        if (!consumer.test(index)) {
                            return false;
                        }
                        inc = (inc -= i) < 0 ? inc + bits : inc;
                    }
                }
                return true;
            }
        };
    }
}

