/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http;

import io.micronaut.core.annotation.Nullable;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.HttpStatus;
import io.micronaut.http.MediaType;
import io.micronaut.http.MutableHttpHeaders;
import io.micronaut.http.MutableHttpMessage;
import io.micronaut.http.cookie.Cookie;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;

public interface MutableHttpResponse<B>
extends HttpResponse<B>,
MutableHttpMessage<B> {
    public MutableHttpResponse<B> cookie(Cookie var1);

    default public MutableHttpResponse<B> cookies(Set<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            this.cookie(cookie);
        }
        return this;
    }

    @Override
    public <T> MutableHttpResponse<T> body(@Nullable T var1);

    public MutableHttpResponse<B> status(HttpStatus var1, CharSequence var2);

    @Override
    default public MutableHttpResponse<B> headers(Consumer<MutableHttpHeaders> headers) {
        return (MutableHttpResponse)MutableHttpMessage.super.headers(headers);
    }

    @Override
    default public MutableHttpResponse<B> header(CharSequence name, CharSequence value) {
        return (MutableHttpResponse)MutableHttpMessage.super.header(name, value);
    }

    @Override
    default public MutableHttpResponse<B> headers(Map<CharSequence, CharSequence> namesAndValues) {
        return (MutableHttpResponse)MutableHttpMessage.super.headers(namesAndValues);
    }

    default public MutableHttpResponse<B> characterEncoding(CharSequence encoding) {
        if (encoding != null) {
            this.getContentType().ifPresent(mediaType -> this.contentType(new MediaType(mediaType.toString(), Collections.singletonMap("charset", encoding.toString()))));
        }
        return this;
    }

    default public MutableHttpResponse<B> characterEncoding(Charset encoding) {
        return this.characterEncoding(encoding.toString());
    }

    @Override
    default public MutableHttpResponse<B> contentLength(long length) {
        return (MutableHttpResponse)MutableHttpMessage.super.contentLength(length);
    }

    @Override
    default public MutableHttpResponse<B> contentType(CharSequence contentType) {
        return (MutableHttpResponse)MutableHttpMessage.super.contentType(contentType);
    }

    @Override
    default public MutableHttpResponse<B> contentType(MediaType mediaType) {
        return (MutableHttpResponse)MutableHttpMessage.super.contentType(mediaType);
    }

    @Override
    default public MutableHttpResponse<B> contentEncoding(CharSequence encoding) {
        return (MutableHttpResponse)MutableHttpMessage.super.contentEncoding(encoding);
    }

    default public MutableHttpResponse<B> locale(Locale locale) {
        this.getHeaders().add("Content-Language", locale.toString());
        return this;
    }

    default public MutableHttpResponse<B> status(int status) {
        return this.status(HttpStatus.valueOf(status));
    }

    default public MutableHttpResponse<B> status(int status, CharSequence message) {
        return this.status(HttpStatus.valueOf(status), message);
    }

    @Override
    default public MutableHttpResponse<B> status(HttpStatus status) {
        return this.status(status, null);
    }

    default public MutableHttpResponse<B> attribute(CharSequence name, Object value) {
        return (MutableHttpResponse)this.setAttribute(name, value);
    }
}

