/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import java.lang.reflect.Method;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableLimitSort
extends Sort
implements EnumerableRel {
    public EnumerableLimitSort(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        super(cluster, traitSet, input, collation, offset, fetch);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (this.getConvention() == input.getConvention());
    }

    public static EnumerableLimitSort create(RelNode input, RelCollation collation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        RelOptCluster cluster = input.getCluster();
        RelTraitSet traitSet = cluster.traitSetOf((RelTrait)EnumerableConvention.INSTANCE).replace(collation);
        return new EnumerableLimitSort(cluster, traitSet, input, collation, offset, fetch);
    }

    @Override
    public EnumerableLimitSort copy(RelTraitSet traitSet, RelNode newInput, RelCollation newCollation, @Nullable RexNode offset, @Nullable RexNode fetch) {
        return new EnumerableLimitSort(this.getCluster(), traitSet, newInput, newCollation, offset, fetch);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(implementor.getTypeFactory(), this.getRowType(), result.format);
        Expression childExp = builder.append("child", result.block);
        PhysType inputPhysType = result.physType;
        Pair<Expression, Expression> pair = inputPhysType.generateCollationKey(this.collation.getFieldCollations());
        Object fetchVal = this.fetch == null ? Expressions.constant((Object)Integer.MAX_VALUE) : EnumerableLimit.getExpression(this.fetch);
        Object offsetVal = this.offset == null ? Expressions.constant((Object)0) : EnumerableLimit.getExpression(this.offset);
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.call((Method)BuiltInMethod.ORDER_BY_WITH_FETCH_AND_OFFSET.method, (Iterable)Expressions.list((Object[])new Expression[]{childExp, builder.append("keySelector", (Expression)pair.left)}).appendIfNotNull((Object)builder.appendIfNotNull("comparator", (Expression)pair.right)).appendIfNotNull((Object)builder.appendIfNotNull("offset", (Expression)Expressions.constant((Object)offsetVal))).appendIfNotNull((Object)builder.appendIfNotNull("fetch", (Expression)Expressions.constant((Object)fetchVal))))));
        return implementor.result(physType, builder.toBlock());
    }
}

